/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.format.helpers;

import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.format.AbstractFormatAttribute;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import io.ray.shaded.com.google.common.net.InternetDomainName;

public final class SharedHostNameAttribute
extends AbstractFormatAttribute {
    public SharedHostNameAttribute(String fmt) {
        super(fmt, NodeType.STRING, new NodeType[0]);
    }

    @Override
    public void validate(ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        String value = data.getInstance().getNode().textValue();
        try {
            InternetDomainName.from(value);
        }
        catch (IllegalArgumentException ignored) {
            report.error(this.newMsg(data, bundle, "err.format.invalidHostname").putArgument("value", value));
        }
    }
}

