/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.object;

import io.ray.api.id.BaseId;
import io.ray.api.id.ObjectId;
import io.ray.shaded.com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class NativeRayObject {
    public byte[] data;
    public byte[] metadata;
    public List<byte[]> containedObjectIds;

    public NativeRayObject(byte[] data, byte[] metadata) {
        Preconditions.checkState(NativeRayObject.bufferLength(data) > 0 || NativeRayObject.bufferLength(metadata) > 0);
        this.data = data;
        this.metadata = metadata;
        this.containedObjectIds = Collections.emptyList();
    }

    public void setContainedObjectIds(List<ObjectId> containedObjectIds) {
        this.containedObjectIds = NativeRayObject.toBinaryList(containedObjectIds);
    }

    private static int bufferLength(byte[] buffer) {
        if (buffer == null) {
            return 0;
        }
        return buffer.length;
    }

    private static List<byte[]> toBinaryList(List<ObjectId> ids) {
        return ids.stream().map(BaseId::getBytes).collect(Collectors.toList());
    }

    public String toString() {
        return "<data>: " + NativeRayObject.bufferLength(this.data) + ", <metadata>: " + NativeRayObject.bufferLength(this.metadata);
    }
}

