/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.runtimeenv;

import com.github.fge.jackson.JsonLoader;
import io.ray.api.exception.RuntimeEnvException;
import io.ray.api.runtimeenv.RuntimeEnv;
import io.ray.api.runtimeenv.RuntimeEnvConfig;
import io.ray.runtime.generated.RuntimeEnvCommon;
import io.ray.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import io.ray.shaded.com.fasterxml.jackson.core.TreeNode;
import io.ray.shaded.com.fasterxml.jackson.databind.JsonNode;
import io.ray.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.ray.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import io.ray.shaded.com.google.protobuf.InvalidProtocolBufferException;
import io.ray.shaded.com.google.protobuf.util.JsonFormat;
import java.io.IOException;

public class RuntimeEnvImpl
implements RuntimeEnv {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    public ObjectNode runtimeEnvs = MAPPER.createObjectNode();
    private static final String CONFIG_FIELD_NAME = "config";

    @Override
    public void set(String name, Object value) throws RuntimeEnvException {
        if (CONFIG_FIELD_NAME.equals(name) && !(value instanceof RuntimeEnvConfig)) {
            throw new RuntimeEnvException(name + "must be instance of " + RuntimeEnvConfig.class);
        }
        JsonNode node = null;
        try {
            node = (JsonNode)MAPPER.valueToTree(value);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeEnvException("Failed to set field.", e);
        }
        this.runtimeEnvs.set(name, node);
    }

    @Override
    public void setJsonStr(String name, String jsonStr) throws RuntimeEnvException {
        JsonNode node = null;
        try {
            node = JsonLoader.fromString(jsonStr);
        }
        catch (IOException e) {
            throw new RuntimeEnvException("Failed to set json field.", e);
        }
        this.runtimeEnvs.set(name, node);
    }

    @Override
    public <T> T get(String name, Class<T> classOfT) throws RuntimeEnvException {
        JsonNode jsonNode = this.runtimeEnvs.get(name);
        if (jsonNode == null) {
            return null;
        }
        try {
            return MAPPER.treeToValue((TreeNode)jsonNode, classOfT);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeEnvException("Failed to get field.", e);
        }
    }

    @Override
    public String getJsonStr(String name) throws RuntimeEnvException {
        try {
            return MAPPER.writeValueAsString(this.runtimeEnvs.get(name));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeEnvException("Failed to get json field.", e);
        }
    }

    @Override
    public boolean contains(String name) {
        return this.runtimeEnvs.has(name);
    }

    @Override
    public boolean remove(String name) {
        if (this.contains(name)) {
            this.runtimeEnvs.remove(name);
            return true;
        }
        return false;
    }

    @Override
    public String serialize() throws RuntimeEnvException {
        try {
            return MAPPER.writeValueAsString(this.runtimeEnvs);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeEnvException("Failed to serialize.", e);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.runtimeEnvs.isEmpty();
    }

    @Override
    public String serializeToRuntimeEnvInfo() throws RuntimeEnvException {
        RuntimeEnvCommon.RuntimeEnvInfo protoRuntimeEnvInfo = this.GenerateRuntimeEnvInfo();
        JsonFormat.Printer printer = JsonFormat.printer();
        try {
            return printer.print(protoRuntimeEnvInfo);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeEnvException("Failed to serialize to runtime env info.", e);
        }
    }

    @Override
    public void setConfig(RuntimeEnvConfig runtimeEnvConfig) {
        this.set(CONFIG_FIELD_NAME, runtimeEnvConfig);
    }

    @Override
    public RuntimeEnvConfig getConfig() {
        if (!this.contains(CONFIG_FIELD_NAME)) {
            return null;
        }
        return this.get(CONFIG_FIELD_NAME, RuntimeEnvConfig.class);
    }

    public RuntimeEnvCommon.RuntimeEnvInfo GenerateRuntimeEnvInfo() throws RuntimeEnvException {
        String serializeRuntimeEnv = this.serialize();
        RuntimeEnvCommon.RuntimeEnvInfo.Builder protoRuntimeEnvInfoBuilder = RuntimeEnvCommon.RuntimeEnvInfo.newBuilder();
        protoRuntimeEnvInfoBuilder.setSerializedRuntimeEnv(serializeRuntimeEnv);
        RuntimeEnvConfig runtimeEnvConfig = this.getConfig();
        if (runtimeEnvConfig != null) {
            RuntimeEnvCommon.RuntimeEnvConfig.Builder protoRuntimeEnvConfigBuilder = RuntimeEnvCommon.RuntimeEnvConfig.newBuilder();
            protoRuntimeEnvConfigBuilder.setSetupTimeoutSeconds(runtimeEnvConfig.getSetupTimeoutSeconds());
            protoRuntimeEnvConfigBuilder.setEagerInstall(runtimeEnvConfig.getEagerInstall());
            protoRuntimeEnvInfoBuilder.setRuntimeEnvConfig(protoRuntimeEnvConfigBuilder.build());
        }
        return protoRuntimeEnvInfoBuilder.build();
    }
}

