# coding: utf-8

"""
    国税庁API

    国税庁が提供するインボイス制度適格請求書発行事業者公表システムWeb-APIを使用するためのクライアントAPI(https://www.invoice-kohyo.nta.go.jp/web-api/index.html)

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from typing import List, Optional
from pydantic import BaseModel, Field, conlist, constr
from kendama.models.announcement import Announcement

class ResponseBody(BaseModel):
    """
    ResponseBody
    """
    last_update_date: Optional[date] = Field(None, alias="lastUpdateDate", description="最終更新年月日")
    count: Optional[constr(strict=True, max_length=8, min_length=1)] = Field(None, description="総件数")
    divide_number: Optional[constr(strict=True, max_length=6, min_length=1)] = Field(None, alias="divideNumber", description="分割番号")
    divide_size: Optional[constr(strict=True, max_length=6, min_length=1)] = Field(None, alias="divideSize", description="分割数")
    announcement: Optional[conlist(Announcement)] = None
    __properties = ["lastUpdateDate", "count", "divideNumber", "divideSize", "announcement"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ResponseBody:
        """Create an instance of ResponseBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in announcement (list)
        _items = []
        if self.announcement:
            for _item in self.announcement:
                if _item:
                    _items.append(_item.to_dict())
            _dict['announcement'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ResponseBody:
        """Create an instance of ResponseBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ResponseBody.parse_obj(obj)

        _obj = ResponseBody.parse_obj({
            "last_update_date": obj.get("lastUpdateDate"),
            "count": obj.get("count"),
            "divide_number": obj.get("divideNumber"),
            "divide_size": obj.get("divideSize"),
            "announcement": [Announcement.from_dict(_item) for _item in obj.get("announcement")] if obj.get("announcement") is not None else None
        })
        return _obj


