# -*- coding: utf-8 -*-
"""
C/C++ language-specific code review checklist.
"""

CHECKLIST = """
## C/C++ 代码审查检查清单

### 内存管理
- [ ] 每个 `malloc`/`new` 是否有对应的 `free`/`delete`
- [ ] 是否存在内存泄漏
- [ ] 是否有缓冲区溢出风险
- [ ] 指针使用前是否检查 NULL
- [ ] 是否正确使用智能指针 (C++)

### 并发安全
- [ ] 是否正确加锁/解锁
- [ ] 是否有潜在的死锁风险
- [ ] 是否有竞态条件
- [ ] 原子操作是否正确使用

### 资源管理
- [ ] 文件句柄是否正确关闭
- [ ] 是否存在资源泄漏

### 错误处理
- [ ] 错误码是否被检查和处理
- [ ] 异常是否被正确捕获和处理 (C++)
- [ ] 是否有未处理的边界情况

### 安全性
- [ ] 是否存在整数溢出风险
- [ ] 是否存在格式化字符串漏洞
- [ ] 是否存在类型转换问题

### 性能
- [ ] 是否有不必要的拷贝
- [ ] 循环和递归是否有正确的终止条件
- [ ] 数据结构选择是否合适

### 代码质量
- [ ] 是否遵循命名规范
- [ ] 函数参数是否过多
- [ ] 函数是否过长/过于复杂
- [ ] 注释是否充分且有意义
- [ ] 是否有魔法数字/硬编码

### 编译器警告
- [ ] 是否有未解决的编译器警告
- [ ] 是否启用了合适的警告级别
"""
