# -*- coding: utf-8 -*-
"""
Java language-specific code review checklist.
"""

CHECKLIST = """
## Java 代码审查检查清单

### 代码风格和约定
- [ ] 是否遵循 Java 命名约定 (驼峰式命名法)
- [ ] 包名是否使用小写字母并使用有意义的名称
- [ ] 类名是否以大写字母开头
- [ ] 方法和变量是否以小写字母开头
- [ ] 常量是否全部大写并用下划线分隔
- [ ] 代码格式是否一致 (缩进、括号位置等)

### 面向对象设计
- [ ] 是否遵循 SOLID 原则
- [ ] 类的职责是否单一明确
- [ ] 类的继承层次是否合理
- [ ] 是否使用接口来实现多态
- [ ] 是否存在过度复杂的类设计

### 异常处理
- [ ] 是否适当捕获和处理异常
- [ ] 是否使用特定异常而非通用异常
- [ ] 是否在 finally 块中正确释放资源
- [ ] 是否有未处理的检查型异常
- [ ] 是否使用了 try-with-resources 自动关闭资源

### 线程安全
- [ ] 共享数据是否有同步保护
- [ ] 是否存在死锁风险
- [ ] 是否正确使用 volatile、synchronized、Lock 和 Condition
- [ ] 是否适当使用了线程安全集合
- [ ] 是否存在竞态条件

### 性能考量
- [ ] 是否避免了不必要的对象创建
- [ ] 集合类使用是否高效
- [ ] 是否有内存泄漏的风险
- [ ] 是否考虑了大数据量时的性能问题
- [ ] I/O 和网络操作是否高效

### 安全性
- [ ] 是否存在 SQL 注入风险
- [ ] 是否存在 XSS 和 CSRF 风险
- [ ] 敏感数据是否加密存储
- [ ] 是否正确验证用户输入
- [ ] 是否实施了最小权限原则

### 依赖管理
- [ ] 是否使用了过时或有安全漏洞的依赖
- [ ] 是否明确指定了依赖版本
- [ ] 依赖项是否冗余或过度引入

### 测试
- [ ] 是否有单元测试覆盖主要功能
- [ ] 测试边界条件和异常路径
- [ ] 测试代码是否清晰易懂
- [ ] 是否使用模拟对象测试外部依赖

### 文档
- [ ] 公共 API 是否有 JavaDoc 注释
- [ ] 复杂逻辑是否有注释说明
- [ ] 注释是否准确且最新
"""
