""" Code is generated by ucloud-model, DO NOT EDIT IT. """

import typing


from ucloud.core.client import Client
from ucloud.services.ubill.schemas import apis


class UBillClient(Client):
    def __init__(
        self, config: dict, transport=None, middleware=None, logger=None
    ):
        super(UBillClient, self).__init__(config, transport, middleware, logger)

    def get_balance(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """GetBalance - 获取账户余额

        **Request**


        **Response**

        - **AccountInfo** (dict) - 见 **AccountInfo** 模型定义

        **Response Model**

        **AccountInfo**
        - **Amount** (str) - 账户余额
        - **AmountAvailable** (str) - 账户可用余额
        - **AmountCredit** (str) - 信用账户余额
        - **AmountFree** (str) - 赠送账户余额
        - **AmountFreeze** (str) - 冻结账户金额


        """
        # build request
        d = {}
        req and d.update(req)
        d = apis.GetBalanceRequestSchema().dumps(d)

        resp = self.invoke("GetBalance", d, **kwargs)
        return apis.GetBalanceResponseSchema().loads(resp)

    def get_bill_data_file_url(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """GetBillDataFileUrl - 生成账单数据文件下载的 url

        **Request**

        - **BillPeriod** (int) - (Required) 账期（时间戳格式）
        - **BillType** (int) - (Required) 账单类型，传 0 时获取账单总览报表，传 1 获取账单明细报表
        - **PaidType** (int) - 获取账单总览报表时，账单的支付状态，传 0 时获取待支付账单，传 1 时获取已支付账单。获取账单明细报表时该参数无效
        - **RequireVersion** (str) - 如需求其他语言版本的账单则使用此参数。默认中文。如 RequireVersion = "EN"，则提供英文版本账单。

        **Response**

        - **FileUrl** (str) - 交易账单数据下载URL
        - **IsValid** (str) - 生成的 URL是否有效，即有对应数据文件

        """
        # build request
        d = {}
        req and d.update(req)
        d = apis.GetBillDataFileUrlRequestSchema().dumps(d)

        resp = self.invoke("GetBillDataFileUrl", d, **kwargs)
        return apis.GetBillDataFileUrlResponseSchema().loads(resp)
