
# def get_panoptic_data(self, is_thing, order=None, lbl_col='anno.lbl.name', 
#                         bbox_format='xywh', val_format='abs', df=None, 
#                         inplace=False):
#     '''Get panoptic data from df
#     Args:
#         is_thing (dict): mapping which categories can have instances 
#             e.g.:{'car': 1, 'person': 1, 'background': 0}
#         order (dict): A class to pixel mapping {class: px_val}, will be     
#             generated by unique labels in lbl_col if no order is provided
#             Note: You have to generate the pixelmap in the same manner
#         lbl_col (str): Column to look for the training labels
#         data_format (str): 'abs' - absolute panopt-data, 'rel' - relative
#         bbox_format (str): 'xywh' - topleftwh, 'lost' - midmidwh
#         df (pd.DataFrame): Frame to generate the pixel maps from
#         inplace (bool): Overwrite the own LOST-dataframe when True
#     Returns: 
#         tuple (pd.DataFrame, dict): Panoptic dataframe and order

#     '''
#     if df is None:
#         df = self.df 

#     if 'bbox' in df['anno.dtype'].unique():
#         df = df[df['anno.dtype'] == 'polygon']
#         print('WARNING: bboxes were found in dataframe. I removed them.')
#         assert(len(df) > 1), 'Dataframe has no polygon annotations!'
    
#     if order is None:
#         order = {l: i for i, l in enumerate(self.get_unique_labels(lbl_col))}

#     # unique image ids by img name
#     df['panopt.image_id'] = df['img.img_path'].map(lambda x: x.split('.')[0])

#     # polygon area per instance
#     df['panopt.area'] = df.map(lambda row: self._get_area(row), axis=1)
    
#     # bbox per instance
#     df['panopt.bbox'] = df['anno.data'].map(
#         lambda x: list(self._poly_to_bbox(x, bbox_format=bbox_format).values()))

#     # category_id, class id, we want to map it with the train-pixel value
#     df['panopt.category_id'] = df[lbl_col].map(lambda x: order[x])
    
#     # segment id per image in coco format 
#     df['panopt.id'] = None
#     for img_path, df_im in df.groupby('img.img_path'):
#         for category, df_cat in df_im.groupby('panopt.category_id'):
#             df_slice = df_im[df_im['panopt.category_id']==category]
#             df_slice['panopt.id'] = [i for i in range(len(df_slice))]
#             def get_segment_id(row):
#                 thing = is_thing[row[lbl_col]]
#                 return 1000 * row['panopt.category_id'] * thing + row['panopt.id']
#             df_slice['panopt.id'] = df_slice.apply(lambda row: get_segment_id(row), axis=1)
#             df_im[df_im['panopt.category_id']==category] = df_slice
#         df[df['img.img_path']==img_path] = df_im

#     # TODO: iscrowd
#     df['panopt.iscrowd'] = 0

#     if val_format == 'abs':
#         im_sizes = df['img.img_path'].map(lambda x: np.array(get_image_size(x)))

#         def _area_to_abs(area):
#             new_area = []
#             for i in range(len(area)):
#                 new_area.append(area[i] * im_sizes[i].prod())
#             return new_area

#         def _bbox_to_abs(bbox):
#             new_box = []
#             for i in range(len(bbox)):
#                 new_box.append(bbox[i] * np.hstack((im_sizes[i], im_sizes[i])) )
#             return new_box

#         df['panopt.bbox'] = _bbox_to_abs(df['panopt.bbox'])
#         df['panopt.area'] = _area_to_abs(df['panopt.area'])

#     if inplace:
#         self.df = df
#     return df, order

# def get_panoptic_segmentation(self, dst_dir, fill_value=0, df=None, inplace=False):
#     from panopticapi.utils import id2rgb
#     os.makedirs(dst_dir, exist_ok=True)
#     if df is None:
#         df = self.df
#     df = df[df['anno.dtype']=='polygon']
#     df['panopt.path'] = None
#     image_paths = self.get_unique_img_paths(df=df)
    
#     for i, image_path in enumerate(image_paths):    
#         print_progress_bar(i+1, len(image_paths), prefix='create panopt. maps:')
#         if not os.path.exists(image_path):
#             raise Exception('Image {} does not exist'.format(image_path))
#         im_w, im_h = get_image_size(image_path)
#         px_map = np.full([im_h, im_w], fill_value, dtype=np.int32)
#         image_annos = df[df['img.img_path']==image_path]

#         def draw_instance(instance):
#             poly = instance['anno.data']
#             poly = (np.array([list(point.values()) for point in poly]) * [im_w, im_h]).astype(np.int32)
#             cv2.fillPoly(px_map, [poly], instance['panopt.id'])

#         for i, instance in image_annos.iterrows():
#             draw_instance(instance)
#         px_map = id2rgb(px_map)
#         img_name = image_path.split('/')[-1]
#         filename = img_name.split('.')[0]
#         filename = filename + '.png'
#         mask_path = os.path.abspath(os.path.join(dst_dir, filename))
#         # cv2.imwrite(mask_path, px_map)
#         Image.fromarray(px_map).save(mask_path)
#         image_annos.loc[:, 'panopt.path'] = mask_path
#         df.loc[df['img.img_path']==image_path] = image_annos

#     if inplace:
#         self.df = df
#     return df