/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.EventProcessor;
import com.lmax.disruptor.EventReleaseAware;
import com.lmax.disruptor.EventReleaser;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.LifecycleAware;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.WorkHandler;
import java.util.concurrent.atomic.AtomicBoolean;

public final class WorkProcessor<T>
implements EventProcessor {
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final Sequence sequence = new Sequence(-1L);
    private final RingBuffer<T> ringBuffer;
    private final SequenceBarrier sequenceBarrier;
    private final WorkHandler<? super T> workHandler;
    private final ExceptionHandler<? super T> exceptionHandler;
    private final Sequence workSequence;
    private final EventReleaser eventReleaser = new EventReleaser(){

        @Override
        public void release() {
            WorkProcessor.this.sequence.set(Long.MAX_VALUE);
        }
    };

    public WorkProcessor(RingBuffer<T> ringBuffer, SequenceBarrier sequenceBarrier, WorkHandler<? super T> workHandler, ExceptionHandler<? super T> exceptionHandler, Sequence workSequence) {
        this.ringBuffer = ringBuffer;
        this.sequenceBarrier = sequenceBarrier;
        this.workHandler = workHandler;
        this.exceptionHandler = exceptionHandler;
        this.workSequence = workSequence;
        if (this.workHandler instanceof EventReleaseAware) {
            ((EventReleaseAware)((Object)this.workHandler)).setEventReleaser(this.eventReleaser);
        }
    }

    @Override
    public Sequence getSequence() {
        return this.sequence;
    }

    @Override
    public void halt() {
        this.running.set(false);
        this.sequenceBarrier.alert();
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public void run() {
        if (!this.running.compareAndSet(false, true)) {
            throw new IllegalStateException("Thread is already running");
        }
        this.sequenceBarrier.clearAlert();
        this.notifyStart();
        boolean processedSequence = true;
        long cachedAvailableSequence = Long.MIN_VALUE;
        long nextSequence = this.sequence.get();
        Object event = null;
        while (true) {
            try {
                while (true) {
                    if (processedSequence) {
                        processedSequence = false;
                        do {
                            nextSequence = this.workSequence.get() + 1L;
                            this.sequence.set(nextSequence - 1L);
                        } while (!this.workSequence.compareAndSet(nextSequence - 1L, nextSequence));
                    }
                    if (cachedAvailableSequence >= nextSequence) {
                        event = this.ringBuffer.get(nextSequence);
                        this.workHandler.onEvent(event);
                        processedSequence = true;
                        continue;
                    }
                    cachedAvailableSequence = this.sequenceBarrier.waitFor(nextSequence);
                }
            }
            catch (AlertException ex) {
                if (this.running.get()) continue;
            }
            catch (Throwable ex) {
                this.exceptionHandler.handleEventException(ex, nextSequence, event);
                processedSequence = true;
                continue;
            }
            break;
        }
        this.notifyShutdown();
        this.running.set(false);
    }

    private void notifyStart() {
        if (this.workHandler instanceof LifecycleAware) {
            try {
                ((LifecycleAware)((Object)this.workHandler)).onStart();
            }
            catch (Throwable ex) {
                this.exceptionHandler.handleOnStartException(ex);
            }
        }
    }

    private void notifyShutdown() {
        if (this.workHandler instanceof LifecycleAware) {
            try {
                ((LifecycleAware)((Object)this.workHandler)).onShutdown();
            }
            catch (Throwable ex) {
                this.exceptionHandler.handleOnShutdownException(ex);
            }
        }
    }
}

