/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.metric;

import io.ray.shaded.com.google.common.base.MoreObjects;

public class MetricConfig {
    private static final long DEFAULT_TIME_INTERVAL_MS = 5000L;
    private static final int DEFAULT_THREAD_POLL_SIZE = 1;
    private static final long DEFAULT_SHUTDOWN_WAIT_TIME_MS = 3000L;
    public static final MetricConfig DEFAULT_CONFIG = new MetricConfig(5000L, 1, 3000L);
    private final long timeIntervalMs;
    private final int threadPoolSize;
    private final long shutdownWaitTimeMs;

    public MetricConfig(long timeIntervalMs, int threadPoolSize, long shutdownWaitTimeMs) {
        this.timeIntervalMs = timeIntervalMs;
        this.threadPoolSize = threadPoolSize;
        this.shutdownWaitTimeMs = shutdownWaitTimeMs;
    }

    public long timeIntervalMs() {
        return this.timeIntervalMs;
    }

    public int threadPoolSize() {
        return this.threadPoolSize;
    }

    public long shutdownWaitTimeMs() {
        return this.shutdownWaitTimeMs;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("timeIntervalMs", this.timeIntervalMs).add("threadPoolSize", this.threadPoolSize).add("shutdownWaitTimeMs", this.shutdownWaitTimeMs).toString();
    }

    public static MetricConfigBuilder builder() {
        return new MetricConfigBuilder();
    }

    public static class MetricConfigBuilder {
        private long timeIntervalMs = 5000L;
        private int threadPooSize = 1;
        private long shutdownWaitTimeMs = 3000L;

        public MetricConfig create() {
            return new MetricConfig(this.timeIntervalMs, this.threadPooSize, this.shutdownWaitTimeMs);
        }

        public MetricConfigBuilder timeIntervalMs(long timeIntervalMs) {
            this.timeIntervalMs = timeIntervalMs;
            return this;
        }

        public MetricConfigBuilder threadPoolSize(int threadPooSize) {
            this.threadPooSize = threadPooSize;
            return this;
        }

        public MetricConfigBuilder shutdownWaitTimeMs(long shutdownWaitTimeMs) {
            this.shutdownWaitTimeMs = shutdownWaitTimeMs;
            return this;
        }
    }
}

