/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.metric;

import io.ray.runtime.metric.Count;
import io.ray.runtime.metric.Gauge;
import io.ray.runtime.metric.Histogram;
import io.ray.runtime.metric.Metric;
import io.ray.runtime.metric.MetricConfig;
import io.ray.runtime.metric.MetricId;
import io.ray.runtime.metric.MetricType;
import io.ray.runtime.metric.Sum;
import io.ray.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricRegistry {
    public static final MetricRegistry DEFAULT_REGISTRY = new MetricRegistry();
    private static final Logger LOG = LoggerFactory.getLogger(MetricRegistry.class);
    private final Map<MetricId, Metric> registeredMetrics = new HashMap<MetricId, Metric>(64);
    private MetricConfig metricConfig;
    private ScheduledExecutorService scheduledExecutorService;
    private volatile boolean isRunning = false;

    public void startup() {
        this.startup(MetricConfig.DEFAULT_CONFIG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup(MetricConfig metricConfig) {
        MetricRegistry metricRegistry = this;
        synchronized (metricRegistry) {
            if (!this.isRunning) {
                this.metricConfig = metricConfig;
                this.scheduledExecutorService = new ScheduledThreadPoolExecutor(metricConfig.threadPoolSize(), new ThreadFactoryBuilder().setNameFormat("metric-registry-%d").build());
                this.scheduledExecutorService.scheduleAtFixedRate(this::update, metricConfig.timeIntervalMs(), metricConfig.timeIntervalMs(), TimeUnit.MILLISECONDS);
                this.isRunning = true;
                LOG.info("Finished startup metric registry, metricConfig is {}.", (Object)metricConfig);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        MetricRegistry metricRegistry = this;
        synchronized (metricRegistry) {
            if (this.isRunning && this.scheduledExecutorService != null) {
                try {
                    this.scheduledExecutorService.shutdownNow();
                    if (!this.scheduledExecutorService.awaitTermination(this.metricConfig.shutdownWaitTimeMs(), TimeUnit.MILLISECONDS)) {
                        LOG.warn("Metric registry did not shut down in {}ms time, so try to shut down again.", (Object)this.metricConfig.shutdownWaitTimeMs());
                        this.scheduledExecutorService.shutdownNow();
                    }
                }
                catch (InterruptedException e) {
                    LOG.warn("Interrupted when shutting down metric registry, so try to shut down again.", (Object)e.getMessage(), (Object)e);
                    this.scheduledExecutorService.shutdownNow();
                }
                if (this.scheduledExecutorService.isShutdown()) {
                    this.isRunning = false;
                    this.scheduledExecutorService = null;
                    LOG.info("Metric registry has been shut down.");
                } else {
                    LOG.warn("Failed to shut down metric registry service.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Metric register(Metric metric) {
        MetricRegistry metricRegistry = this;
        synchronized (metricRegistry) {
            if (!this.isRunning) {
                LOG.warn("Failed to register a metric, because the metric registry is not running.");
                return null;
            }
            try {
                MetricId id = this.genMetricIdByMetric(metric);
                Metric ori = this.registeredMetrics.putIfAbsent(id, metric);
                if (ori == null) {
                    return metric;
                }
                LOG.info("Metric {} has already registered, so use the previous one.", (Object)id);
                return ori;
            }
            catch (Exception e) {
                LOG.warn("Failed to register a metric: ", (Object)e.getMessage(), (Object)e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Metric metric) {
        MetricRegistry metricRegistry = this;
        synchronized (metricRegistry) {
            if (!this.isRunning) {
                LOG.warn("Failed to unregister a metric, because the metric registry is not running.");
            }
            try {
                MetricId id = this.genMetricIdByMetric(metric);
                this.registeredMetrics.remove(id);
            }
            catch (Exception e) {
                LOG.warn("Failed to unregister a metric: ", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private void update() {
        this.registeredMetrics.forEach((id, metric) -> metric.record());
    }

    private MetricType getMetricType(Metric metric) {
        if (metric instanceof Count) {
            return MetricType.COUNT;
        }
        if (metric instanceof Gauge) {
            return MetricType.GAUGE;
        }
        if (metric instanceof Sum) {
            return MetricType.SUM;
        }
        if (metric instanceof Histogram) {
            return MetricType.HISTOGRAM;
        }
        throw new RuntimeException("Unknown metric type, the metric is " + metric.getClass().getSimpleName());
    }

    private MetricId genMetricIdByMetric(Metric metric) {
        return new MetricId(this.getMetricType(metric), metric.name, metric.tags);
    }
}

