/*
 * Decompiled with CFR 0.152.
 */
package io.ray.serve.poll;

import io.ray.serve.exception.RayServeException;
import io.ray.serve.poll.LongPollNamespace;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class KeyType
implements Serializable {
    private static final long serialVersionUID = -8838552786234630401L;
    private final LongPollNamespace longPollNamespace;
    private final String key;
    private int hashCode;
    private String name;

    public KeyType(LongPollNamespace longPollNamespace, String key) {
        this.longPollNamespace = longPollNamespace;
        this.key = key;
        this.hashCode = Objects.hash(new Object[]{this.longPollNamespace, this.key});
        this.name = this.parseName();
    }

    public LongPollNamespace getLongPollNamespace() {
        return this.longPollNamespace;
    }

    public String getKey() {
        return this.key;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KeyType keyType = (KeyType)obj;
        return Objects.equals((Object)this.longPollNamespace, (Object)keyType.getLongPollNamespace()) && Objects.equals(this.key, keyType.getKey());
    }

    private String parseName() {
        if (this.longPollNamespace == null && StringUtils.isBlank(this.key)) {
            return "";
        }
        if (this.longPollNamespace == null) {
            return this.key;
        }
        if (StringUtils.isBlank(this.key)) {
            return this.longPollNamespace.name();
        }
        return "(" + this.longPollNamespace.name() + "," + this.key + ")";
    }

    public String toString() {
        return this.name;
    }

    public static KeyType parseFrom(String key) {
        if (key == null) {
            return null;
        }
        if (StringUtils.isBlank(key)) {
            return new KeyType(null, null);
        }
        if (key.startsWith("(")) {
            String[] fields = StringUtils.split(StringUtils.substring(key, 1, key.length() - 1), ",", 2);
            if (fields.length != 2) {
                throw new RayServeException("Illegal KeyType string: " + key);
            }
            return new KeyType(LongPollNamespace.parseFrom(fields[0]), fields[1].trim());
        }
        LongPollNamespace longPollNamespace = LongPollNamespace.parseFrom(key);
        if (null != longPollNamespace) {
            return new KeyType(longPollNamespace, null);
        }
        return new KeyType(null, key);
    }
}

