from enum import IntEnum


class SocketCodes(IntEnum):
    """IntEnum containing all websocket responses and request codes taken from `com.narvii.util.ws.WsMessage`"""

    MESSAGE = 1000
    NOTIFICATION = 10

    AGORA_TOKEN_REQUEST = 200
    AGORA_TOKEN_RESPONSE = 201

    CHAT_THREAD_MEMBERSHIP_BANNED = 5
    CHAT_THREAD_NOT_AVAILABLE = 3
    CHAT_THREAD_NO_PRESENTER = 6
    CHAT_THREAD_ORGANIZER_LEFT = 2
    CHAT_THREAD_PRIVATE_NOT_ACCEPT = 99

    COMMUNITY_DISABLED = 1
    ERROR_MESSAGE = 1

    FETCH_PLAY_LIST_REQUEST = 122
    FETCH_THREAD_CHANNEL_USER_LIST_REQUEST = 105

    FORCE_UPDATE_USER_ROLE_MESSAGE = 128
    FORCE_UPDATE_USER_ROLE_REQ = 126
    FORCE_UPDATE_USER_ROLE_RESP = 127

    JOIN_THREAD_CHANNEL_REQUEST = 100
    JOIN_THREAD_CHANNEL_RESPONSE = 101

    LEAVE_THREAD_CHANNEL_REQUEST = 103
    LEAVE_THREAD_CHANNEL_RESPONSE = 104

    LIVE_LAYER_USER_JOINED_EVENT = 400
    LIVE_LAYER_USER_LEFT_EVENT = 401

    MULTI_DEVICE_ERROR = 118

    REPORT_LIVE_LAYER_ACTIVE_REQUEST = 304
    REPORT_LIVE_LAYER_ACTIVE_RESPONSE = 305
    REPORT_LIVE_LAYER_INACTIVE_REQUEST = 306
    REPORT_LIVE_LAYER_INACTIVE_RESPONSE = 307

    SCREEN_RROM_PLAY_LIST_RESPONSE = 119

    SUBSCRIBE_LIVE_LAYER_REQUEST = 300
    SUBSCRIBE_LIVE_LAYER_RESPONSE = 301

    THREAD_CHANNEL_FORCE_QUIT_MESSAGE = 115
    THREAD_CHANNEL_USER_JOINED_MESSAGE = 106
    THREAD_CHANNEL_USER_LEFT_MESSAGE = 107
    THREAD_CHANNEL_USER_LIST_MESSAGE = 102
    THREAD_CHANNEL_USER_PING_REQUEST = 116
    THREAD_CHANNEL_USER_PING_RESPONSE = 117
    THREAD_CHANNEL_USER_STATUS_CHANGED_MESSAGE = 114

    THREAD_STATUS_CHANGED_MESSAGE = 111

    THREAD_WAIT_LIST_APPROVE_MESSAGE = 130
    THREAD_WAIT_LIST_CHANGED_MESSAGE = 131
    THREAD_WAIT_LIST_CLEAN_REQUEST = 132
    THREAD_WAIT_LIST_CLEAN_RESPONSE = 133
    THREAD_WAIT_LIST_JOIN_APPROVE_REQUEST = 134
    THREAD_WAIT_LIST_JOIN_APPROVE_RESPONSE = 135
    THREAD_WAIT_LIST_JOIN_CANCEL_REQUEST = 136
    THREAD_WAIT_LIST_JOIN_CANCEL_RESPENSE = 137
    THREAD_WAIT_LIST_JOIN_REQUEST = 138
    THREAD_WAIT_LIST_JOIN_RESPONSE = 139

    UNSUBSCRIBE_LIVE_LAYER_REQUEST = 302
    UNSUBSCRIBE_LIVE_LAYER_RESPONSE = 303

    UPDATE_PLAY_LIST_REQUEST = 120
    UPDATE_PLAY_LIST_RESPONSE = 121

    UPDATE_THREAD_CHANNEL_REQUEST = 108
    UPDATE_THREAD_CHANNEL_RESPONSE = 109

    UPDATE_USER_ROLE_REQUEST = 112
    UPDATE_USER_ROLE_RESPONSE = 113

    USER_PROFILE_BANNED = 4


class MessageTypes(IntEnum):
    TEXT = 0
    STRIKE_MESSAGE = 1
    VOICE_MESSAGE = 2
    STICKER_MESSAGE = 3
    VOICE_CHAT_NOT_ANSWERED = 52
    VOICE_CHAT_NOT_CANCELLED = 53
    VOICE_CHAT_NOT_DECLINED = 54
    VIDEO_CHAT_NOT_ANSWERED = 55
    VIDEO_CHAT_NOT_CANCELLED = 56
    VIDEO_CHAT_NOT_DECLINED = 57
    AVATAR_CHAT_NOT_ANSWERED = 58
    AVATAR_CHAT_NOT_CANCELLED = 59
    AVATAR_CHAT_NOT_DECLINED = 60
    DELETE_MESSAGE = 100
    GROUP_MEMBER_JOIN = 101
    GROUP_MEMBER_LEAVE = 102
    CHAT_INVITE = 103
    CHAT_BACKGROUND_CHANGED = 104
    CHAT_TITLE_CHANGED = 105
    CHAT_ICON_CHANGED = 106
    VOICE_CHAT_START = 107
    VIDEO_CHAT_START = 108
    AVATAR_CHAT_START = 109
    VOICE_CHAT_END = 110
    VIDEO_CHAT_END = 111
    AVATAR_CHAT_END = 112
    CHAT_CONTENT_CHANGED = 113
    SCREEN_ROOM_START = 114
    SCREEN_ROOM_END = 115
    CHAT_HOST_TRANSFERED = 116
    TEXT_MESSAGE_FORCE_REMOVED = 117
    CHAT_REMOVED_MESSAGE = 118
    TEXT_MESSAGE_REMOVED_BY_ADMIN = 119
    CHAT_TIP = 120
    CHAT_PIN_ANNOUNCEMENT = 121
    VOICE_CHAT_PERMISSION_OPEN_TO_EVERYONE = 122
    VOICE_CHAT_PERMISSION_INVITED_AND_REQUESTED = 123
    VOICE_CHAT_PERMISSION_INVITE_ONLY = 124
    CHAT_VIEW_ONLY_ENABLED = 125
    CHAT_VIEW_ONLY_DISABLED = 126
    CHAT_UNPIN_ANNOUNCEMENT = 127
    CHAT_TIPPING_ENABLED = 128
    CHAT_TIPPING_DISABLED = 129
    TIMESTAMP_MESSAGE = 65281
    WELCOME_MESSAGE = 65282
    INVITE_MESSAGE = 65283
