# Generated by Django 3.0.5 on 2021-05-20 10:35

import django.db.models.deletion
import modelcluster.fields

from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        ("wagtailcore", "0059_apply_collection_ordering"),
    ]

    operations = [
        migrations.CreateModel(
            name="PeriodicReviewFrequencySettings",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "site",
                    models.OneToOneField(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="wagtailcore.Site",
                    ),
                ),
            ],
            options={
                "abstract": False,
                "verbose_name": "periodic review frequency",
                "verbose_name_plural": "periodic review frequencies",
            },
        ),
        migrations.CreateModel(
            name="PeriodicReviewFrequencyRule",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "sort_order",
                    models.IntegerField(blank=True, editable=False, null=True),
                ),
                (
                    "frequency",
                    models.PositiveIntegerField(
                        choices=[
                            (1, "1 month"),
                            (2, "2 months"),
                            (3, "3 months"),
                            (6, "6 months"),
                            (12, "12 months"),
                            (18, "18 months"),
                            (24, "2 years"),
                            (36, "3 years"),
                            (48, "4 years"),
                        ],
                        default=12,
                        verbose_name="review frequency",
                    ),
                ),
                (
                    "content_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.ContentType",
                        verbose_name="content type",
                    ),
                ),
                (
                    "sitesettings",
                    modelcluster.fields.ParentalKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="frequency_rules",
                        to="wagtail_periodic_review.PeriodicReviewFrequencySettings",
                    ),
                ),
            ],
            options={
                "ordering": ["sort_order"],
                "abstract": False,
            },
        ),
        migrations.AddConstraint(
            model_name="periodicreviewfrequencyrule",
            constraint=models.UniqueConstraint(
                fields=("sitesettings", "content_type"), name="unique_rule"
            ),
        ),
    ]
