# Generated by Django 2.0.1 on 2018-01-06 15:49

import django.contrib.postgres.fields.jsonb
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Division',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('uid', models.CharField(blank=True, editable=False, max_length=500)),
                ('slug', models.SlugField(blank=True, editable=False, max_length=255, unique=True)),
                ('name', models.CharField(max_length=255)),
                ('label', models.CharField(blank=True, max_length=255)),
                ('short_label', models.CharField(blank=True, max_length=50, null=True)),
                ('code', models.CharField(help_text='Code representing a geography: FIPS code for states and         counties, district number for districts, precinct number for         precincts, etc.', max_length=200)),
                ('code_components', django.contrib.postgres.fields.jsonb.JSONField(blank=True, help_text='Component parts of code', null=True)),
                ('effective', models.BooleanField(default=True)),
                ('effective_start', models.DateTimeField(blank=True, null=True)),
                ('effective_end', models.DateTimeField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='DivisionLevel',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('uid', models.CharField(blank=True, editable=False, max_length=500)),
                ('slug', models.SlugField(blank=True, editable=False, max_length=255, unique=True)),
                ('name', models.CharField(choices=[('country', 'Country'), ('state', 'State'), ('district', 'District'), ('county', 'County'), ('township', 'Township'), ('precinct', 'Precinct')], max_length=255, unique=True)),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='children', to='geography.DivisionLevel')),
            ],
        ),
        migrations.CreateModel(
            name='Geometry',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('simplification', models.FloatField(help_text='Minimum quantile of planar         triangle areas for simplfying topojson.', validators=[django.core.validators.MinValueValidator(0.0), django.core.validators.MaxValueValidator(1.0)])),
                ('topojson', django.contrib.postgres.fields.jsonb.JSONField()),
                ('source', models.URLField(blank=True, help_text='Link to the source of this geography data.', null=True)),
                ('series', models.CharField(blank=True, help_text='Year of boundary series, e.g., 2016 TIGER/Line files.', max_length=4, null=True)),
                ('effective', models.BooleanField(default=True)),
                ('effective_start', models.DateField(blank=True, null=True)),
                ('effective_end', models.DateField(blank=True, null=True)),
                ('division', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='geometries', to='geography.Division')),
                ('subdivision_level', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='+', to='geography.DivisionLevel')),
            ],
            options={
                'verbose_name_plural': 'Geometries',
            },
        ),
        migrations.CreateModel(
            name='IntersectRelationship',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('intersection', models.DecimalField(blank=True, decimal_places=6, help_text='The portion of the to_division that intersects this division.', max_digits=7, null=True)),
                ('from_division', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='geography.Division')),
                ('to_division', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='geography.Division')),
            ],
        ),
        migrations.AddField(
            model_name='division',
            name='intersecting',
            field=models.ManyToManyField(help_text='Intersecting divisions intersect this one geographically but do not necessarily have a parent/child relationship. The relationship between a congressional district and a precinct is an example of an intersecting relationship.', related_name='_division_intersecting_+', through='geography.IntersectRelationship', to='geography.Division'),
        ),
        migrations.AddField(
            model_name='division',
            name='level',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='divisions', to='geography.DivisionLevel'),
        ),
        migrations.AddField(
            model_name='division',
            name='parent',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='children', to='geography.Division'),
        ),
        migrations.AlterUniqueTogether(
            name='intersectrelationship',
            unique_together={('from_division', 'to_division')},
        ),
    ]
