# Copyright (C) 2023 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""
    MI Server API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: v1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import re  # noqa: F401
from typing import TYPE_CHECKING, Any, BinaryIO, Dict, List, Optional, Union  # noqa: F401

from . import ApiBase

if TYPE_CHECKING:
    import pathlib

    from ..models import *


class DataApi(ApiBase):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def export_binary_data_for_latest(
        self,
        *,
        database_key: "str",
        record_history_guid: "str",
        attribute_guid: "str",
        mode: "Optional[str]" = None,
        x_ansys_vc_mode: "Optional[str]" = None,
        max_width: "Optional[int]" = None,
        max_height: "Optional[int]" = None,
    ) -> "Union[None, str]":
        """Get the binary data for a given attribute and the latest version of a record history in given database. Must be a file or picture attribute.

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
        record_history_guid: str
        attribute_guid: str
        mode: str
            The version control mode. If not provided, defaults to write mode if the user is allowed to see that. Can also be set in the header.
        x_ansys_vc_mode: str
            The version control mode. If not provided, defaults to write mode if the user is allowed to see that. Can also be set in the query string.
        max_width: int
        max_height: int

        Returns
        -------
        Union[None, str]
        """
        data = self._export_binary_data_for_latest_with_http_info(
            database_key,
            record_history_guid,
            attribute_guid,
            mode,
            x_ansys_vc_mode,
            max_width,
            max_height,
            _return_http_data_only=True,
        )
        return data  # type: ignore[no-any-return]

    def _export_binary_data_for_latest_with_http_info(
        self,
        database_key: "str",
        record_history_guid: "str",
        attribute_guid: "str",
        mode: "Optional[str]" = None,
        x_ansys_vc_mode: "Optional[str]" = None,
        max_width: "Optional[int]" = None,
        max_height: "Optional[int]" = None,
        **kwargs: Any,
    ) -> Any:
        all_params = [
            "database_key",
            "record_history_guid",
            "attribute_guid",
            "mode",
            "x_ansys_vc_mode",
            "max_width",
            "max_height",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method export_binary_data_for_latest"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'export_binary_data_for_latest'"
            )
        # verify the required parameter "record_history_guid" is set
        if "record_history_guid" not in params or params["record_history_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'record_history_guid' when calling 'export_binary_data_for_latest'"
            )
        # verify the required parameter "attribute_guid" is set
        if "attribute_guid" not in params or params["attribute_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'attribute_guid' when calling 'export_binary_data_for_latest'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]
        if "record_history_guid" in params and record_history_guid is not None:
            path_params["record-history-guid"] = params["record_history_guid"]
        if "attribute_guid" in params and attribute_guid is not None:
            path_params["attribute-guid"] = params["attribute_guid"]

        query_params: List[Any] = []
        if "mode" in params and mode is not None:
            query_params.append(("mode", params["mode"]))
        if "max_width" in params and max_width is not None:
            query_params.append(("maxWidth", params["max_width"]))
        if "max_height" in params and max_height is not None:
            query_params.append(("maxHeight", params["max_height"]))

        header_params: Dict[str, Any] = {}
        if "x_ansys_vc_mode" in params and x_ansys_vc_mode is not None:
            header_params["X-Ansys-VC-Mode"] = params["x_ansys_vc_mode"]

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/octet-stream", "application/json"]
        )

        response_type_map: Dict[int, Optional[str]] = {
            200: "file",
            404: None,
            400: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/record-histories/{record-history-guid}/latest/attributes/{attribute-guid}:export",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def export_binary_data_for_latest_from_table(
        self,
        *,
        database_key: "str",
        table_guid: "str",
        record_history_guid: "str",
        attribute_guid: "str",
        mode: "Optional[str]" = None,
        x_ansys_vc_mode: "Optional[str]" = None,
        max_width: "Optional[int]" = None,
        max_height: "Optional[int]" = None,
    ) -> "Union[None, str]":
        """Get the binary data for a given attribute and the latest version of a record history in given database and table. Must be a file or picture attribute.

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
        table_guid: str
        record_history_guid: str
        attribute_guid: str
        mode: str
            The version control mode. If not provided, defaults to write mode if the user is allowed to see that. Can also be set in the header.
        x_ansys_vc_mode: str
            The version control mode. If not provided, defaults to write mode if the user is allowed to see that. Can also be set in the query string.
        max_width: int
        max_height: int

        Returns
        -------
        Union[None, str]
        """
        data = self._export_binary_data_for_latest_from_table_with_http_info(
            database_key,
            table_guid,
            record_history_guid,
            attribute_guid,
            mode,
            x_ansys_vc_mode,
            max_width,
            max_height,
            _return_http_data_only=True,
        )
        return data  # type: ignore[no-any-return]

    def _export_binary_data_for_latest_from_table_with_http_info(
        self,
        database_key: "str",
        table_guid: "str",
        record_history_guid: "str",
        attribute_guid: "str",
        mode: "Optional[str]" = None,
        x_ansys_vc_mode: "Optional[str]" = None,
        max_width: "Optional[int]" = None,
        max_height: "Optional[int]" = None,
        **kwargs: Any,
    ) -> Any:
        all_params = [
            "database_key",
            "table_guid",
            "record_history_guid",
            "attribute_guid",
            "mode",
            "x_ansys_vc_mode",
            "max_width",
            "max_height",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method export_binary_data_for_latest_from_table"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'export_binary_data_for_latest_from_table'"
            )
        # verify the required parameter "table_guid" is set
        if "table_guid" not in params or params["table_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'table_guid' when calling 'export_binary_data_for_latest_from_table'"
            )
        # verify the required parameter "record_history_guid" is set
        if "record_history_guid" not in params or params["record_history_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'record_history_guid' when calling 'export_binary_data_for_latest_from_table'"
            )
        # verify the required parameter "attribute_guid" is set
        if "attribute_guid" not in params or params["attribute_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'attribute_guid' when calling 'export_binary_data_for_latest_from_table'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]
        if "table_guid" in params and table_guid is not None:
            path_params["table-guid"] = params["table_guid"]
        if "record_history_guid" in params and record_history_guid is not None:
            path_params["record-history-guid"] = params["record_history_guid"]
        if "attribute_guid" in params and attribute_guid is not None:
            path_params["attribute-guid"] = params["attribute_guid"]

        query_params: List[Any] = []
        if "mode" in params and mode is not None:
            query_params.append(("mode", params["mode"]))
        if "max_width" in params and max_width is not None:
            query_params.append(("maxWidth", params["max_width"]))
        if "max_height" in params and max_height is not None:
            query_params.append(("maxHeight", params["max_height"]))

        header_params: Dict[str, Any] = {}
        if "x_ansys_vc_mode" in params and x_ansys_vc_mode is not None:
            header_params["X-Ansys-VC-Mode"] = params["x_ansys_vc_mode"]

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/octet-stream", "application/json"]
        )

        response_type_map: Dict[int, Optional[str]] = {
            200: "file",
            404: None,
            400: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/tables/{table-guid}/record-histories/{record-history-guid}/latest/attributes/{attribute-guid}:export",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def export_binary_data_for_version(
        self,
        *,
        database_key: "str",
        record_history_guid: "str",
        record_version_guid: "str",
        attribute_guid: "str",
        mode: "Optional[str]" = None,
        x_ansys_vc_mode: "Optional[str]" = None,
        max_width: "Optional[int]" = None,
        max_height: "Optional[int]" = None,
    ) -> "Union[None, str]":
        """Get the binary data for a given database, record history, record version and attribute. Must be a file or picture attribute.

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
        record_history_guid: str
        record_version_guid: str
        attribute_guid: str
        mode: str
            The version control mode. If not provided, defaults to write mode if the user is allowed to see that. Can also be set in the header.
        x_ansys_vc_mode: str
            The version control mode. If not provided, defaults to write mode if the user is allowed to see that. Can also be set in the query string.
        max_width: int
        max_height: int

        Returns
        -------
        Union[None, str]
        """
        data = self._export_binary_data_for_version_with_http_info(
            database_key,
            record_history_guid,
            record_version_guid,
            attribute_guid,
            mode,
            x_ansys_vc_mode,
            max_width,
            max_height,
            _return_http_data_only=True,
        )
        return data  # type: ignore[no-any-return]

    def _export_binary_data_for_version_with_http_info(
        self,
        database_key: "str",
        record_history_guid: "str",
        record_version_guid: "str",
        attribute_guid: "str",
        mode: "Optional[str]" = None,
        x_ansys_vc_mode: "Optional[str]" = None,
        max_width: "Optional[int]" = None,
        max_height: "Optional[int]" = None,
        **kwargs: Any,
    ) -> Any:
        all_params = [
            "database_key",
            "record_history_guid",
            "record_version_guid",
            "attribute_guid",
            "mode",
            "x_ansys_vc_mode",
            "max_width",
            "max_height",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method export_binary_data_for_version"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'export_binary_data_for_version'"
            )
        # verify the required parameter "record_history_guid" is set
        if "record_history_guid" not in params or params["record_history_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'record_history_guid' when calling 'export_binary_data_for_version'"
            )
        # verify the required parameter "record_version_guid" is set
        if "record_version_guid" not in params or params["record_version_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'record_version_guid' when calling 'export_binary_data_for_version'"
            )
        # verify the required parameter "attribute_guid" is set
        if "attribute_guid" not in params or params["attribute_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'attribute_guid' when calling 'export_binary_data_for_version'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]
        if "record_history_guid" in params and record_history_guid is not None:
            path_params["record-history-guid"] = params["record_history_guid"]
        if "record_version_guid" in params and record_version_guid is not None:
            path_params["record-version-guid"] = params["record_version_guid"]
        if "attribute_guid" in params and attribute_guid is not None:
            path_params["attribute-guid"] = params["attribute_guid"]

        query_params: List[Any] = []
        if "mode" in params and mode is not None:
            query_params.append(("mode", params["mode"]))
        if "max_width" in params and max_width is not None:
            query_params.append(("maxWidth", params["max_width"]))
        if "max_height" in params and max_height is not None:
            query_params.append(("maxHeight", params["max_height"]))

        header_params: Dict[str, Any] = {}
        if "x_ansys_vc_mode" in params and x_ansys_vc_mode is not None:
            header_params["X-Ansys-VC-Mode"] = params["x_ansys_vc_mode"]

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/octet-stream", "application/json"]
        )

        response_type_map: Dict[int, Optional[str]] = {
            200: "file",
            404: None,
            400: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/record-histories/{record-history-guid}/record-versions/{record-version-guid}/attributes/{attribute-guid}:export",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def export_binary_data_for_version_from_table(
        self,
        *,
        database_key: "str",
        table_guid: "str",
        record_history_guid: "str",
        record_version_guid: "str",
        attribute_guid: "str",
        mode: "Optional[str]" = None,
        x_ansys_vc_mode: "Optional[str]" = None,
        max_width: "Optional[int]" = None,
        max_height: "Optional[int]" = None,
    ) -> "Union[None, str]":
        """Get the binary data for a given database, table, record history, record version and attribute. Must be a file or picture attribute.

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
        table_guid: str
        record_history_guid: str
        record_version_guid: str
        attribute_guid: str
        mode: str
            The version control mode. If not provided, defaults to write mode if the user is allowed to see that. Can also be set in the header.
        x_ansys_vc_mode: str
            The version control mode. If not provided, defaults to write mode if the user is allowed to see that. Can also be set in the query string.
        max_width: int
        max_height: int

        Returns
        -------
        Union[None, str]
        """
        data = self._export_binary_data_for_version_from_table_with_http_info(
            database_key,
            table_guid,
            record_history_guid,
            record_version_guid,
            attribute_guid,
            mode,
            x_ansys_vc_mode,
            max_width,
            max_height,
            _return_http_data_only=True,
        )
        return data  # type: ignore[no-any-return]

    def _export_binary_data_for_version_from_table_with_http_info(
        self,
        database_key: "str",
        table_guid: "str",
        record_history_guid: "str",
        record_version_guid: "str",
        attribute_guid: "str",
        mode: "Optional[str]" = None,
        x_ansys_vc_mode: "Optional[str]" = None,
        max_width: "Optional[int]" = None,
        max_height: "Optional[int]" = None,
        **kwargs: Any,
    ) -> Any:
        all_params = [
            "database_key",
            "table_guid",
            "record_history_guid",
            "record_version_guid",
            "attribute_guid",
            "mode",
            "x_ansys_vc_mode",
            "max_width",
            "max_height",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method export_binary_data_for_version_from_table"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'export_binary_data_for_version_from_table'"
            )
        # verify the required parameter "table_guid" is set
        if "table_guid" not in params or params["table_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'table_guid' when calling 'export_binary_data_for_version_from_table'"
            )
        # verify the required parameter "record_history_guid" is set
        if "record_history_guid" not in params or params["record_history_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'record_history_guid' when calling 'export_binary_data_for_version_from_table'"
            )
        # verify the required parameter "record_version_guid" is set
        if "record_version_guid" not in params or params["record_version_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'record_version_guid' when calling 'export_binary_data_for_version_from_table'"
            )
        # verify the required parameter "attribute_guid" is set
        if "attribute_guid" not in params or params["attribute_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'attribute_guid' when calling 'export_binary_data_for_version_from_table'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]
        if "table_guid" in params and table_guid is not None:
            path_params["table-guid"] = params["table_guid"]
        if "record_history_guid" in params and record_history_guid is not None:
            path_params["record-history-guid"] = params["record_history_guid"]
        if "record_version_guid" in params and record_version_guid is not None:
            path_params["record-version-guid"] = params["record_version_guid"]
        if "attribute_guid" in params and attribute_guid is not None:
            path_params["attribute-guid"] = params["attribute_guid"]

        query_params: List[Any] = []
        if "mode" in params and mode is not None:
            query_params.append(("mode", params["mode"]))
        if "max_width" in params and max_width is not None:
            query_params.append(("maxWidth", params["max_width"]))
        if "max_height" in params and max_height is not None:
            query_params.append(("maxHeight", params["max_height"]))

        header_params: Dict[str, Any] = {}
        if "x_ansys_vc_mode" in params and x_ansys_vc_mode is not None:
            header_params["X-Ansys-VC-Mode"] = params["x_ansys_vc_mode"]

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/octet-stream", "application/json"]
        )

        response_type_map: Dict[int, Optional[str]] = {
            200: "file",
            404: None,
            400: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/tables/{table-guid}/record-histories/{record-history-guid}/record-versions/{record-version-guid}/attributes/{attribute-guid}:export",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def get_datum_for_latest(
        self,
        *,
        database_key: "str",
        record_history_guid: "str",
        attribute_guid: "str",
        mode: "Optional[str]" = None,
        x_ansys_vc_mode: "Optional[str]" = None,
    ) -> "Union[GrantaServerApiDataDatum, None]":
        """Get a datum for a given attribute and the latest version of a record history in given database.

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
        record_history_guid: str
        attribute_guid: str
        mode: str
            The version control mode. If not provided, defaults to write mode if the user is allowed to see that. Can also be set in the header.
        x_ansys_vc_mode: str
            The version control mode. If not provided, defaults to write mode if the user is allowed to see that. Can also be set in the query string.

        Returns
        -------
        Union[GrantaServerApiDataDatum, None]
        """
        data = self._get_datum_for_latest_with_http_info(
            database_key,
            record_history_guid,
            attribute_guid,
            mode,
            x_ansys_vc_mode,
            _return_http_data_only=True,
        )
        return data  # type: ignore[no-any-return]

    def _get_datum_for_latest_with_http_info(
        self,
        database_key: "str",
        record_history_guid: "str",
        attribute_guid: "str",
        mode: "Optional[str]" = None,
        x_ansys_vc_mode: "Optional[str]" = None,
        **kwargs: Any,
    ) -> Any:
        all_params = [
            "database_key",
            "record_history_guid",
            "attribute_guid",
            "mode",
            "x_ansys_vc_mode",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method get_datum_for_latest"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'get_datum_for_latest'"
            )
        # verify the required parameter "record_history_guid" is set
        if "record_history_guid" not in params or params["record_history_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'record_history_guid' when calling 'get_datum_for_latest'"
            )
        # verify the required parameter "attribute_guid" is set
        if "attribute_guid" not in params or params["attribute_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'attribute_guid' when calling 'get_datum_for_latest'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]
        if "record_history_guid" in params and record_history_guid is not None:
            path_params["record-history-guid"] = params["record_history_guid"]
        if "attribute_guid" in params and attribute_guid is not None:
            path_params["attribute-guid"] = params["attribute_guid"]

        query_params: List[Any] = []
        if "mode" in params and mode is not None:
            query_params.append(("mode", params["mode"]))

        header_params: Dict[str, Any] = {}
        if "x_ansys_vc_mode" in params and x_ansys_vc_mode is not None:
            header_params["X-Ansys-VC-Mode"] = params["x_ansys_vc_mode"]

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        response_type_map: Dict[int, Optional[str]] = {
            200: "GrantaServerApiDataDatum",
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/record-histories/{record-history-guid}/latest/attributes/{attribute-guid}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def get_datum_for_latest_from_table(
        self,
        *,
        database_key: "str",
        table_guid: "str",
        record_history_guid: "str",
        attribute_guid: "str",
        mode: "Optional[str]" = None,
        x_ansys_vc_mode: "Optional[str]" = None,
    ) -> "Union[GrantaServerApiDataDatum, None]":
        """Get a datum for a given attribute and the latest version of a record history in given database and table.

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
        table_guid: str
        record_history_guid: str
        attribute_guid: str
        mode: str
            The version control mode. If not provided, defaults to write mode if the user is allowed to see that. Can also be set in the header.
        x_ansys_vc_mode: str
            The version control mode. If not provided, defaults to write mode if the user is allowed to see that. Can also be set in the query string.

        Returns
        -------
        Union[GrantaServerApiDataDatum, None]
        """
        data = self._get_datum_for_latest_from_table_with_http_info(
            database_key,
            table_guid,
            record_history_guid,
            attribute_guid,
            mode,
            x_ansys_vc_mode,
            _return_http_data_only=True,
        )
        return data  # type: ignore[no-any-return]

    def _get_datum_for_latest_from_table_with_http_info(
        self,
        database_key: "str",
        table_guid: "str",
        record_history_guid: "str",
        attribute_guid: "str",
        mode: "Optional[str]" = None,
        x_ansys_vc_mode: "Optional[str]" = None,
        **kwargs: Any,
    ) -> Any:
        all_params = [
            "database_key",
            "table_guid",
            "record_history_guid",
            "attribute_guid",
            "mode",
            "x_ansys_vc_mode",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method get_datum_for_latest_from_table"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'get_datum_for_latest_from_table'"
            )
        # verify the required parameter "table_guid" is set
        if "table_guid" not in params or params["table_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'table_guid' when calling 'get_datum_for_latest_from_table'"
            )
        # verify the required parameter "record_history_guid" is set
        if "record_history_guid" not in params or params["record_history_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'record_history_guid' when calling 'get_datum_for_latest_from_table'"
            )
        # verify the required parameter "attribute_guid" is set
        if "attribute_guid" not in params or params["attribute_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'attribute_guid' when calling 'get_datum_for_latest_from_table'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]
        if "table_guid" in params and table_guid is not None:
            path_params["table-guid"] = params["table_guid"]
        if "record_history_guid" in params and record_history_guid is not None:
            path_params["record-history-guid"] = params["record_history_guid"]
        if "attribute_guid" in params and attribute_guid is not None:
            path_params["attribute-guid"] = params["attribute_guid"]

        query_params: List[Any] = []
        if "mode" in params and mode is not None:
            query_params.append(("mode", params["mode"]))

        header_params: Dict[str, Any] = {}
        if "x_ansys_vc_mode" in params and x_ansys_vc_mode is not None:
            header_params["X-Ansys-VC-Mode"] = params["x_ansys_vc_mode"]

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        response_type_map: Dict[int, Optional[str]] = {
            200: "GrantaServerApiDataDatum",
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/tables/{table-guid}/record-histories/{record-history-guid}/latest/attributes/{attribute-guid}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def get_datum_for_version(
        self,
        *,
        database_key: "str",
        record_history_guid: "str",
        record_version_guid: "str",
        attribute_guid: "str",
        mode: "Optional[str]" = None,
        x_ansys_vc_mode: "Optional[str]" = None,
    ) -> "Union[GrantaServerApiDataDatum, None]":
        """Get a datum for a given database, record history, record version and attribute.

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
        record_history_guid: str
        record_version_guid: str
        attribute_guid: str
        mode: str
            The version control mode. If not provided, defaults to write mode if the user is allowed to see that. Can also be set in the header.
        x_ansys_vc_mode: str
            The version control mode. If not provided, defaults to write mode if the user is allowed to see that. Can also be set in the query string.

        Returns
        -------
        Union[GrantaServerApiDataDatum, None]
        """
        data = self._get_datum_for_version_with_http_info(
            database_key,
            record_history_guid,
            record_version_guid,
            attribute_guid,
            mode,
            x_ansys_vc_mode,
            _return_http_data_only=True,
        )
        return data  # type: ignore[no-any-return]

    def _get_datum_for_version_with_http_info(
        self,
        database_key: "str",
        record_history_guid: "str",
        record_version_guid: "str",
        attribute_guid: "str",
        mode: "Optional[str]" = None,
        x_ansys_vc_mode: "Optional[str]" = None,
        **kwargs: Any,
    ) -> Any:
        all_params = [
            "database_key",
            "record_history_guid",
            "record_version_guid",
            "attribute_guid",
            "mode",
            "x_ansys_vc_mode",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method get_datum_for_version"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'get_datum_for_version'"
            )
        # verify the required parameter "record_history_guid" is set
        if "record_history_guid" not in params or params["record_history_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'record_history_guid' when calling 'get_datum_for_version'"
            )
        # verify the required parameter "record_version_guid" is set
        if "record_version_guid" not in params or params["record_version_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'record_version_guid' when calling 'get_datum_for_version'"
            )
        # verify the required parameter "attribute_guid" is set
        if "attribute_guid" not in params or params["attribute_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'attribute_guid' when calling 'get_datum_for_version'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]
        if "record_history_guid" in params and record_history_guid is not None:
            path_params["record-history-guid"] = params["record_history_guid"]
        if "record_version_guid" in params and record_version_guid is not None:
            path_params["record-version-guid"] = params["record_version_guid"]
        if "attribute_guid" in params and attribute_guid is not None:
            path_params["attribute-guid"] = params["attribute_guid"]

        query_params: List[Any] = []
        if "mode" in params and mode is not None:
            query_params.append(("mode", params["mode"]))

        header_params: Dict[str, Any] = {}
        if "x_ansys_vc_mode" in params and x_ansys_vc_mode is not None:
            header_params["X-Ansys-VC-Mode"] = params["x_ansys_vc_mode"]

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        response_type_map: Dict[int, Optional[str]] = {
            200: "GrantaServerApiDataDatum",
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/record-histories/{record-history-guid}/record-versions/{record-version-guid}/attributes/{attribute-guid}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def get_datum_for_version_from_table(
        self,
        *,
        database_key: "str",
        table_guid: "str",
        record_history_guid: "str",
        record_version_guid: "str",
        attribute_guid: "str",
        mode: "Optional[str]" = None,
        x_ansys_vc_mode: "Optional[str]" = None,
    ) -> "Union[GrantaServerApiDataDatum, None]":
        """Get a datum for a given database, table, record history, record version and attribute.

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
        table_guid: str
        record_history_guid: str
        record_version_guid: str
        attribute_guid: str
        mode: str
            The version control mode. If not provided, defaults to write mode if the user is allowed to see that. Can also be set in the header.
        x_ansys_vc_mode: str
            The version control mode. If not provided, defaults to write mode if the user is allowed to see that. Can also be set in the query string.

        Returns
        -------
        Union[GrantaServerApiDataDatum, None]
        """
        data = self._get_datum_for_version_from_table_with_http_info(
            database_key,
            table_guid,
            record_history_guid,
            record_version_guid,
            attribute_guid,
            mode,
            x_ansys_vc_mode,
            _return_http_data_only=True,
        )
        return data  # type: ignore[no-any-return]

    def _get_datum_for_version_from_table_with_http_info(
        self,
        database_key: "str",
        table_guid: "str",
        record_history_guid: "str",
        record_version_guid: "str",
        attribute_guid: "str",
        mode: "Optional[str]" = None,
        x_ansys_vc_mode: "Optional[str]" = None,
        **kwargs: Any,
    ) -> Any:
        all_params = [
            "database_key",
            "table_guid",
            "record_history_guid",
            "record_version_guid",
            "attribute_guid",
            "mode",
            "x_ansys_vc_mode",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method get_datum_for_version_from_table"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'get_datum_for_version_from_table'"
            )
        # verify the required parameter "table_guid" is set
        if "table_guid" not in params or params["table_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'table_guid' when calling 'get_datum_for_version_from_table'"
            )
        # verify the required parameter "record_history_guid" is set
        if "record_history_guid" not in params or params["record_history_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'record_history_guid' when calling 'get_datum_for_version_from_table'"
            )
        # verify the required parameter "record_version_guid" is set
        if "record_version_guid" not in params or params["record_version_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'record_version_guid' when calling 'get_datum_for_version_from_table'"
            )
        # verify the required parameter "attribute_guid" is set
        if "attribute_guid" not in params or params["attribute_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'attribute_guid' when calling 'get_datum_for_version_from_table'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]
        if "table_guid" in params and table_guid is not None:
            path_params["table-guid"] = params["table_guid"]
        if "record_history_guid" in params and record_history_guid is not None:
            path_params["record-history-guid"] = params["record_history_guid"]
        if "record_version_guid" in params and record_version_guid is not None:
            path_params["record-version-guid"] = params["record_version_guid"]
        if "attribute_guid" in params and attribute_guid is not None:
            path_params["attribute-guid"] = params["attribute_guid"]

        query_params: List[Any] = []
        if "mode" in params and mode is not None:
            query_params.append(("mode", params["mode"]))

        header_params: Dict[str, Any] = {}
        if "x_ansys_vc_mode" in params and x_ansys_vc_mode is not None:
            header_params["X-Ansys-VC-Mode"] = params["x_ansys_vc_mode"]

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        response_type_map: Dict[int, Optional[str]] = {
            200: "GrantaServerApiDataDatum",
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/tables/{table-guid}/record-histories/{record-history-guid}/record-versions/{record-version-guid}/attributes/{attribute-guid}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )
