# Copyright (C) 2023 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""
    MI Server API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: v1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import re  # noqa: F401
from typing import TYPE_CHECKING, Any, BinaryIO, Dict, List, Optional, Union  # noqa: F401

from . import ApiBase

if TYPE_CHECKING:
    import pathlib

    from ..models import *


class SchemaConstantsApi(ApiBase):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def create_constant(
        self,
        *,
        database_key: "str",
        body: "Optional[GrantaServerApiSchemaConstantsCreateConstant]" = None,
    ) -> "Union[GrantaServerApiSchemaConstantsConstant, None]":
        """Create a new constant.

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
            Database in which constant will be created
        body: GrantaServerApiSchemaConstantsCreateConstant
            Constant to add to database

        Returns
        -------
        Union[GrantaServerApiSchemaConstantsConstant, None]
        """
        data = self._create_constant_with_http_info(database_key, body, _return_http_data_only=True)
        return data  # type: ignore[no-any-return]

    def _create_constant_with_http_info(
        self,
        database_key: "str",
        body: "Optional[GrantaServerApiSchemaConstantsCreateConstant]" = None,
        **kwargs: Any,
    ) -> Any:
        all_params = [
            "database_key",
            "body",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method create_constant"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'create_constant'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        if "body" in params and body is not None:
            body_params = params["body"]
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # HTTP header 'Content-Type'
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json-patch+json", "application/json", "text/json", "application/*+json"]
        )

        response_type_map: Dict[int, Optional[str]] = {
            201: "GrantaServerApiSchemaConstantsConstant",
            400: None,
            403: None,
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/constants",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def delete_constant(
        self, *, database_key: "str", constant_guid: "str"
    ) -> "Union[GrantaServerApiExceptionsDeletionConstantDeletionException, None]":
        """Delete a constant

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
            Database in which constant will be search for
        constant_guid: str
            Guid of constant to delete

        Returns
        -------
        Union[GrantaServerApiExceptionsDeletionConstantDeletionException, None]
        """
        data = self._delete_constant_with_http_info(
            database_key, constant_guid, _return_http_data_only=True
        )
        return data  # type: ignore[no-any-return]

    def _delete_constant_with_http_info(
        self, database_key: "str", constant_guid: "str", **kwargs: Any
    ) -> Any:
        all_params = [
            "database_key",
            "constant_guid",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method delete_constant"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'delete_constant'"
            )
        # verify the required parameter "constant_guid" is set
        if "constant_guid" not in params or params["constant_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'constant_guid' when calling 'delete_constant'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]
        if "constant_guid" in params and constant_guid is not None:
            path_params["constant-guid"] = params["constant_guid"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        response_type_map: Dict[int, Optional[str]] = {
            400: "GrantaServerApiExceptionsDeletionConstantDeletionException",
            200: None,
            403: None,
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/constants/{constant-guid}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def get_constant(
        self, *, database_key: "str", constant_guid: "str"
    ) -> "Union[GrantaServerApiSchemaConstantsConstant, None]":
        """Get individual constant

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
            Database in which constant will be search for
        constant_guid: str
            Guid of requested constant

        Returns
        -------
        Union[GrantaServerApiSchemaConstantsConstant, None]
        """
        data = self._get_constant_with_http_info(
            database_key, constant_guid, _return_http_data_only=True
        )
        return data  # type: ignore[no-any-return]

    def _get_constant_with_http_info(
        self, database_key: "str", constant_guid: "str", **kwargs: Any
    ) -> Any:
        all_params = [
            "database_key",
            "constant_guid",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method get_constant"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'get_constant'"
            )
        # verify the required parameter "constant_guid" is set
        if "constant_guid" not in params or params["constant_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'constant_guid' when calling 'get_constant'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]
        if "constant_guid" in params and constant_guid is not None:
            path_params["constant-guid"] = params["constant_guid"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        response_type_map: Dict[int, Optional[str]] = {
            200: "GrantaServerApiSchemaConstantsConstant",
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/constants/{constant-guid}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def get_constants(
        self, *, database_key: "str"
    ) -> "Union[GrantaServerApiSchemaConstantsConstantsInfo, None]":
        """Get all constants

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str

        Returns
        -------
        Union[GrantaServerApiSchemaConstantsConstantsInfo, None]
        """
        data = self._get_constants_with_http_info(database_key, _return_http_data_only=True)
        return data  # type: ignore[no-any-return]

    def _get_constants_with_http_info(self, database_key: "str", **kwargs: Any) -> Any:
        all_params = [
            "database_key",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method get_constants"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'get_constants'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        response_type_map: Dict[int, Optional[str]] = {
            200: "GrantaServerApiSchemaConstantsConstantsInfo",
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/constants",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def update_constant(
        self,
        *,
        database_key: "str",
        constant_guid: "str",
        body: "Optional[GrantaServerApiSchemaConstantsUpdateConstant]" = None,
    ) -> "Union[GrantaServerApiSchemaConstantsConstant, None]":
        """Update constant.

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
            Database in which constant will be search for
        constant_guid: str
            Guid of constant to update
        body: GrantaServerApiSchemaConstantsUpdateConstant
            Constant data to be updated

        Returns
        -------
        Union[GrantaServerApiSchemaConstantsConstant, None]
        """
        data = self._update_constant_with_http_info(
            database_key, constant_guid, body, _return_http_data_only=True
        )
        return data  # type: ignore[no-any-return]

    def _update_constant_with_http_info(
        self,
        database_key: "str",
        constant_guid: "str",
        body: "Optional[GrantaServerApiSchemaConstantsUpdateConstant]" = None,
        **kwargs: Any,
    ) -> Any:
        all_params = [
            "database_key",
            "constant_guid",
            "body",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method update_constant"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'update_constant'"
            )
        # verify the required parameter "constant_guid" is set
        if "constant_guid" not in params or params["constant_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'constant_guid' when calling 'update_constant'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]
        if "constant_guid" in params and constant_guid is not None:
            path_params["constant-guid"] = params["constant_guid"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        if "body" in params and body is not None:
            body_params = params["body"]
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # HTTP header 'Content-Type'
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json-patch+json", "application/json", "text/json", "application/*+json"]
        )

        response_type_map: Dict[int, Optional[str]] = {
            200: "GrantaServerApiSchemaConstantsConstant",
            400: None,
            403: None,
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/constants/{constant-guid}",
            "PATCH",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )
