# Copyright (C) 2023 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""
    MI Server API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: v1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import re  # noqa: F401
from typing import TYPE_CHECKING, Any, BinaryIO, Dict, List, Optional, Union  # noqa: F401

from . import ApiBase

if TYPE_CHECKING:
    import pathlib

    from ..models import *


class SchemaExportersApi(ApiBase):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def create_exporters_file(
        self,
        *,
        database_key: "str",
        folder_guid: "str",
        file: "Optional[Union[BinaryIO, pathlib.Path]]" = None,
        description: "Optional[str]" = None,
    ) -> "Union[GrantaServerApiSchemaFilesFileHeader, None]":
        """Create a new Exporter File.

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
        folder_guid: str
        file: Union[BinaryIO, pathlib.Path]
        description: str

        Returns
        -------
        Union[GrantaServerApiSchemaFilesFileHeader, None]
        """
        data = self._create_exporters_file_with_http_info(
            database_key, folder_guid, file, description, _return_http_data_only=True
        )
        return data  # type: ignore[no-any-return]

    def _create_exporters_file_with_http_info(
        self,
        database_key: "str",
        folder_guid: "str",
        file: "Optional[Union[BinaryIO, pathlib.Path]]" = None,
        description: "Optional[str]" = None,
        **kwargs: Any,
    ) -> Any:
        all_params = [
            "database_key",
            "folder_guid",
            "file",
            "description",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method create_exporters_file"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'create_exporters_file'"
            )
        # verify the required parameter "folder_guid" is set
        if "folder_guid" not in params or params["folder_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'folder_guid' when calling 'create_exporters_file'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]
        if "folder_guid" in params and folder_guid is not None:
            path_params["folder-guid"] = params["folder_guid"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}
        if "file" in params and file is not None:
            local_var_files["file"] = params["file"]
        if "description" in params and description is not None:
            form_params.append(("description", params["description"]))

        body_params = None
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(
            ["text/plain", "application/json", "text/json"]
        )

        # multipart/form-data request detected. Content-Type header will be
        # populated by openapi-common based on request content.

        response_type_map: Dict[int, Optional[str]] = {
            201: "GrantaServerApiSchemaFilesFileHeader",
            400: None,
            403: None,
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/exporters/{folder-guid}/files",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def create_exporters_folder(
        self,
        *,
        database_key: "str",
        body: "Optional[GrantaServerApiSchemaFilesCreateFolder]" = None,
    ) -> "Union[GrantaServerApiSchemaFilesFolder, None]":
        """Create a new Exporters Folder.

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
        body: GrantaServerApiSchemaFilesCreateFolder

        Returns
        -------
        Union[GrantaServerApiSchemaFilesFolder, None]
        """
        data = self._create_exporters_folder_with_http_info(
            database_key, body, _return_http_data_only=True
        )
        return data  # type: ignore[no-any-return]

    def _create_exporters_folder_with_http_info(
        self,
        database_key: "str",
        body: "Optional[GrantaServerApiSchemaFilesCreateFolder]" = None,
        **kwargs: Any,
    ) -> Any:
        all_params = [
            "database_key",
            "body",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method create_exporters_folder"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'create_exporters_folder'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        if "body" in params and body is not None:
            body_params = params["body"]
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(
            ["text/plain", "application/json", "text/json"]
        )

        # HTTP header 'Content-Type'
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json-patch+json", "application/json", "text/json", "application/*+json"]
        )

        response_type_map: Dict[int, Optional[str]] = {
            201: "GrantaServerApiSchemaFilesFolder",
            400: None,
            403: None,
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/exporters",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def delete_exporters_file(
        self, *, database_key: "str", folder_guid: "str", file_guid: "str"
    ) -> "None":
        """Delete an Exporter File.

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
        folder_guid: str
        file_guid: str

        Returns
        -------
        None
        """
        data = self._delete_exporters_file_with_http_info(
            database_key, folder_guid, file_guid, _return_http_data_only=True
        )
        return data  # type: ignore[no-any-return]

    def _delete_exporters_file_with_http_info(
        self, database_key: "str", folder_guid: "str", file_guid: "str", **kwargs: Any
    ) -> Any:
        all_params = [
            "database_key",
            "folder_guid",
            "file_guid",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method delete_exporters_file"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'delete_exporters_file'"
            )
        # verify the required parameter "folder_guid" is set
        if "folder_guid" not in params or params["folder_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'folder_guid' when calling 'delete_exporters_file'"
            )
        # verify the required parameter "file_guid" is set
        if "file_guid" not in params or params["file_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'file_guid' when calling 'delete_exporters_file'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]
        if "folder_guid" in params and folder_guid is not None:
            path_params["folder-guid"] = params["folder_guid"]
        if "file_guid" in params and file_guid is not None:
            path_params["file-guid"] = params["file_guid"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None

        response_type_map: Dict[int, Optional[str]] = {
            200: None,
            403: None,
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/exporters/{folder-guid}/files/{file-guid}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def delete_exporters_folder(self, *, database_key: "str", folder_guid: "str") -> "None":
        """Delete an Exporter Folder.

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
        folder_guid: str

        Returns
        -------
        None
        """
        data = self._delete_exporters_folder_with_http_info(
            database_key, folder_guid, _return_http_data_only=True
        )
        return data  # type: ignore[no-any-return]

    def _delete_exporters_folder_with_http_info(
        self, database_key: "str", folder_guid: "str", **kwargs: Any
    ) -> Any:
        all_params = [
            "database_key",
            "folder_guid",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method delete_exporters_folder"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'delete_exporters_folder'"
            )
        # verify the required parameter "folder_guid" is set
        if "folder_guid" not in params or params["folder_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'folder_guid' when calling 'delete_exporters_folder'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]
        if "folder_guid" in params and folder_guid is not None:
            path_params["folder-guid"] = params["folder_guid"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None

        response_type_map: Dict[int, Optional[str]] = {
            200: None,
            403: None,
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/exporters/{folder-guid}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def export_exporters_file(
        self, *, database_key: "str", folder_guid: "str", file_guid: "str"
    ) -> "None":
        """Get Exporter File as a file

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
        folder_guid: str
        file_guid: str

        Returns
        -------
        None
        """
        data = self._export_exporters_file_with_http_info(
            database_key, folder_guid, file_guid, _return_http_data_only=True
        )
        return data  # type: ignore[no-any-return]

    def _export_exporters_file_with_http_info(
        self, database_key: "str", folder_guid: "str", file_guid: "str", **kwargs: Any
    ) -> Any:
        all_params = [
            "database_key",
            "folder_guid",
            "file_guid",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method export_exporters_file"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'export_exporters_file'"
            )
        # verify the required parameter "folder_guid" is set
        if "folder_guid" not in params or params["folder_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'folder_guid' when calling 'export_exporters_file'"
            )
        # verify the required parameter "file_guid" is set
        if "file_guid" not in params or params["file_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'file_guid' when calling 'export_exporters_file'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]
        if "folder_guid" in params and folder_guid is not None:
            path_params["folder-guid"] = params["folder_guid"]
        if "file_guid" in params and file_guid is not None:
            path_params["file-guid"] = params["file_guid"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None

        response_type_map: Dict[int, Optional[str]] = {
            200: None,
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/exporters/{folder-guid}/files/{file-guid}:export",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def get_exporter_file(
        self, *, database_key: "str", folder_guid: "str", file_guid: "str"
    ) -> "Union[GrantaServerApiSchemaFilesFileHeader, None]":
        """Get the header information for an Exporter File

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
        folder_guid: str
        file_guid: str

        Returns
        -------
        Union[GrantaServerApiSchemaFilesFileHeader, None]
        """
        data = self._get_exporter_file_with_http_info(
            database_key, folder_guid, file_guid, _return_http_data_only=True
        )
        return data  # type: ignore[no-any-return]

    def _get_exporter_file_with_http_info(
        self, database_key: "str", folder_guid: "str", file_guid: "str", **kwargs: Any
    ) -> Any:
        all_params = [
            "database_key",
            "folder_guid",
            "file_guid",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method get_exporter_file"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'get_exporter_file'"
            )
        # verify the required parameter "folder_guid" is set
        if "folder_guid" not in params or params["folder_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'folder_guid' when calling 'get_exporter_file'"
            )
        # verify the required parameter "file_guid" is set
        if "file_guid" not in params or params["file_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'file_guid' when calling 'get_exporter_file'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]
        if "folder_guid" in params and folder_guid is not None:
            path_params["folder-guid"] = params["folder_guid"]
        if "file_guid" in params and file_guid is not None:
            path_params["file-guid"] = params["file_guid"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(
            ["text/plain", "application/json", "text/json"]
        )

        response_type_map: Dict[int, Optional[str]] = {
            200: "GrantaServerApiSchemaFilesFileHeader",
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/exporters/{folder-guid}/files/{file-guid}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def get_exporters_child_folders(
        self, *, database_key: "str", folder_guid: "str"
    ) -> "Union[GrantaServerApiSchemaFilesFoldersInfo, None]":
        """Get Child Exporters Folders

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
        folder_guid: str

        Returns
        -------
        Union[GrantaServerApiSchemaFilesFoldersInfo, None]
        """
        data = self._get_exporters_child_folders_with_http_info(
            database_key, folder_guid, _return_http_data_only=True
        )
        return data  # type: ignore[no-any-return]

    def _get_exporters_child_folders_with_http_info(
        self, database_key: "str", folder_guid: "str", **kwargs: Any
    ) -> Any:
        all_params = [
            "database_key",
            "folder_guid",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method get_exporters_child_folders"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'get_exporters_child_folders'"
            )
        # verify the required parameter "folder_guid" is set
        if "folder_guid" not in params or params["folder_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'folder_guid' when calling 'get_exporters_child_folders'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]
        if "folder_guid" in params and folder_guid is not None:
            path_params["folder-guid"] = params["folder_guid"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(
            ["text/plain", "application/json", "text/json"]
        )

        response_type_map: Dict[int, Optional[str]] = {
            200: "GrantaServerApiSchemaFilesFoldersInfo",
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/exporters/{folder-guid}:child-folders",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def get_exporters_files(
        self, *, database_key: "str", folder_guid: "str"
    ) -> "Union[GrantaServerApiSchemaFilesFilesInfo, None]":
        """Get the Exporter Files in a Folder

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
        folder_guid: str

        Returns
        -------
        Union[GrantaServerApiSchemaFilesFilesInfo, None]
        """
        data = self._get_exporters_files_with_http_info(
            database_key, folder_guid, _return_http_data_only=True
        )
        return data  # type: ignore[no-any-return]

    def _get_exporters_files_with_http_info(
        self, database_key: "str", folder_guid: "str", **kwargs: Any
    ) -> Any:
        all_params = [
            "database_key",
            "folder_guid",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method get_exporters_files"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'get_exporters_files'"
            )
        # verify the required parameter "folder_guid" is set
        if "folder_guid" not in params or params["folder_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'folder_guid' when calling 'get_exporters_files'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]
        if "folder_guid" in params and folder_guid is not None:
            path_params["folder-guid"] = params["folder_guid"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(
            ["text/plain", "application/json", "text/json"]
        )

        response_type_map: Dict[int, Optional[str]] = {
            200: "GrantaServerApiSchemaFilesFilesInfo",
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/exporters/{folder-guid}/files",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def get_exporters_folder(
        self, *, database_key: "str", folder_guid: "str"
    ) -> "Union[GrantaServerApiSchemaFilesFolder, None]":
        """Get Exporters Folder

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
        folder_guid: str

        Returns
        -------
        Union[GrantaServerApiSchemaFilesFolder, None]
        """
        data = self._get_exporters_folder_with_http_info(
            database_key, folder_guid, _return_http_data_only=True
        )
        return data  # type: ignore[no-any-return]

    def _get_exporters_folder_with_http_info(
        self, database_key: "str", folder_guid: "str", **kwargs: Any
    ) -> Any:
        all_params = [
            "database_key",
            "folder_guid",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method get_exporters_folder"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'get_exporters_folder'"
            )
        # verify the required parameter "folder_guid" is set
        if "folder_guid" not in params or params["folder_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'folder_guid' when calling 'get_exporters_folder'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]
        if "folder_guid" in params and folder_guid is not None:
            path_params["folder-guid"] = params["folder_guid"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(
            ["text/plain", "application/json", "text/json"]
        )

        response_type_map: Dict[int, Optional[str]] = {
            200: "GrantaServerApiSchemaFilesFolder",
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/exporters/{folder-guid}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def get_exporters_folders(
        self, *, database_key: "str"
    ) -> "Union[GrantaServerApiSchemaFilesFoldersInfo, None]":
        """Get All Exporter Folders

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str

        Returns
        -------
        Union[GrantaServerApiSchemaFilesFoldersInfo, None]
        """
        data = self._get_exporters_folders_with_http_info(database_key, _return_http_data_only=True)
        return data  # type: ignore[no-any-return]

    def _get_exporters_folders_with_http_info(self, database_key: "str", **kwargs: Any) -> Any:
        all_params = [
            "database_key",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method get_exporters_folders"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'get_exporters_folders'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(
            ["text/plain", "application/json", "text/json"]
        )

        response_type_map: Dict[int, Optional[str]] = {
            200: "GrantaServerApiSchemaFilesFoldersInfo",
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/exporters",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def get_exporters_root_folder(
        self, *, database_key: "str"
    ) -> "Union[GrantaServerApiSchemaFilesFolder, None]":
        """Get Root Exporters Folder

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str

        Returns
        -------
        Union[GrantaServerApiSchemaFilesFolder, None]
        """
        data = self._get_exporters_root_folder_with_http_info(
            database_key, _return_http_data_only=True
        )
        return data  # type: ignore[no-any-return]

    def _get_exporters_root_folder_with_http_info(self, database_key: "str", **kwargs: Any) -> Any:
        all_params = [
            "database_key",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method get_exporters_root_folder"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'get_exporters_root_folder'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(
            ["text/plain", "application/json", "text/json"]
        )

        response_type_map: Dict[int, Optional[str]] = {
            200: "GrantaServerApiSchemaFilesFolder",
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/exporters:root-folder",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def move_exporters_file(
        self,
        *,
        database_key: "str",
        folder_guid: "str",
        file_guid: "str",
        body: "Optional[GrantaServerApiSchemaFilesMoveFile]" = None,
    ) -> "Union[GrantaServerApiSchemaFilesFileHeader, None]":
        """Move an existing Exporter File.

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
        folder_guid: str
        file_guid: str
        body: GrantaServerApiSchemaFilesMoveFile

        Returns
        -------
        Union[GrantaServerApiSchemaFilesFileHeader, None]
        """
        data = self._move_exporters_file_with_http_info(
            database_key, folder_guid, file_guid, body, _return_http_data_only=True
        )
        return data  # type: ignore[no-any-return]

    def _move_exporters_file_with_http_info(
        self,
        database_key: "str",
        folder_guid: "str",
        file_guid: "str",
        body: "Optional[GrantaServerApiSchemaFilesMoveFile]" = None,
        **kwargs: Any,
    ) -> Any:
        all_params = [
            "database_key",
            "folder_guid",
            "file_guid",
            "body",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method move_exporters_file"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'move_exporters_file'"
            )
        # verify the required parameter "folder_guid" is set
        if "folder_guid" not in params or params["folder_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'folder_guid' when calling 'move_exporters_file'"
            )
        # verify the required parameter "file_guid" is set
        if "file_guid" not in params or params["file_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'file_guid' when calling 'move_exporters_file'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]
        if "folder_guid" in params and folder_guid is not None:
            path_params["folder-guid"] = params["folder_guid"]
        if "file_guid" in params and file_guid is not None:
            path_params["file-guid"] = params["file_guid"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        if "body" in params and body is not None:
            body_params = params["body"]
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(
            ["text/plain", "application/json", "text/json"]
        )

        # HTTP header 'Content-Type'
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json-patch+json", "application/json", "text/json", "application/*+json"]
        )

        response_type_map: Dict[int, Optional[str]] = {
            200: "GrantaServerApiSchemaFilesFileHeader",
            400: None,
            403: None,
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/exporters/{folder-guid}/files/{file-guid}:move",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def move_exporters_folder(
        self,
        *,
        database_key: "str",
        folder_guid: "str",
        body: "Optional[GrantaServerApiSchemaFilesMoveFolder]" = None,
    ) -> "Union[GrantaServerApiSchemaFilesFolder, None]":
        """Move an existing Exporter Folder.

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
        folder_guid: str
        body: GrantaServerApiSchemaFilesMoveFolder

        Returns
        -------
        Union[GrantaServerApiSchemaFilesFolder, None]
        """
        data = self._move_exporters_folder_with_http_info(
            database_key, folder_guid, body, _return_http_data_only=True
        )
        return data  # type: ignore[no-any-return]

    def _move_exporters_folder_with_http_info(
        self,
        database_key: "str",
        folder_guid: "str",
        body: "Optional[GrantaServerApiSchemaFilesMoveFolder]" = None,
        **kwargs: Any,
    ) -> Any:
        all_params = [
            "database_key",
            "folder_guid",
            "body",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method move_exporters_folder"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'move_exporters_folder'"
            )
        # verify the required parameter "folder_guid" is set
        if "folder_guid" not in params or params["folder_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'folder_guid' when calling 'move_exporters_folder'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]
        if "folder_guid" in params and folder_guid is not None:
            path_params["folder-guid"] = params["folder_guid"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        if "body" in params and body is not None:
            body_params = params["body"]
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(
            ["text/plain", "application/json", "text/json"]
        )

        # HTTP header 'Content-Type'
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json-patch+json", "application/json", "text/json", "application/*+json"]
        )

        response_type_map: Dict[int, Optional[str]] = {
            200: "GrantaServerApiSchemaFilesFolder",
            400: None,
            403: None,
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/exporters/{folder-guid}:move",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def refetch_exporters(
        self, *, database_key: "str"
    ) -> "Union[GrantaServerApiSchemaFilesExporterRefetchInfo, None]":
        """Re-fetch the Exporter Files.

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str

        Returns
        -------
        Union[GrantaServerApiSchemaFilesExporterRefetchInfo, None]
        """
        data = self._refetch_exporters_with_http_info(database_key, _return_http_data_only=True)
        return data  # type: ignore[no-any-return]

    def _refetch_exporters_with_http_info(self, database_key: "str", **kwargs: Any) -> Any:
        all_params = [
            "database_key",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method refetch_exporters"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'refetch_exporters'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(
            ["text/plain", "application/json", "text/json"]
        )

        response_type_map: Dict[int, Optional[str]] = {
            200: "GrantaServerApiSchemaFilesExporterRefetchInfo",
            400: None,
            403: None,
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/exporters:re-fetch",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def update_exporters_file(
        self,
        *,
        database_key: "str",
        folder_guid: "str",
        file_guid: "str",
        body: "Optional[GrantaServerApiSchemaFilesUpdateFile]" = None,
    ) -> "Union[GrantaServerApiSchemaFilesFileHeader, None]":
        """Update an existing Exporter File.

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
        folder_guid: str
        file_guid: str
        body: GrantaServerApiSchemaFilesUpdateFile

        Returns
        -------
        Union[GrantaServerApiSchemaFilesFileHeader, None]
        """
        data = self._update_exporters_file_with_http_info(
            database_key, folder_guid, file_guid, body, _return_http_data_only=True
        )
        return data  # type: ignore[no-any-return]

    def _update_exporters_file_with_http_info(
        self,
        database_key: "str",
        folder_guid: "str",
        file_guid: "str",
        body: "Optional[GrantaServerApiSchemaFilesUpdateFile]" = None,
        **kwargs: Any,
    ) -> Any:
        all_params = [
            "database_key",
            "folder_guid",
            "file_guid",
            "body",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method update_exporters_file"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'update_exporters_file'"
            )
        # verify the required parameter "folder_guid" is set
        if "folder_guid" not in params or params["folder_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'folder_guid' when calling 'update_exporters_file'"
            )
        # verify the required parameter "file_guid" is set
        if "file_guid" not in params or params["file_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'file_guid' when calling 'update_exporters_file'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]
        if "folder_guid" in params and folder_guid is not None:
            path_params["folder-guid"] = params["folder_guid"]
        if "file_guid" in params and file_guid is not None:
            path_params["file-guid"] = params["file_guid"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        if "body" in params and body is not None:
            body_params = params["body"]
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(
            ["text/plain", "application/json", "text/json"]
        )

        # HTTP header 'Content-Type'
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json-patch+json", "application/json", "text/json", "application/*+json"]
        )

        response_type_map: Dict[int, Optional[str]] = {
            200: "GrantaServerApiSchemaFilesFileHeader",
            400: None,
            403: None,
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/exporters/{folder-guid}/files/{file-guid}",
            "PATCH",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def update_exporters_folder(
        self,
        *,
        database_key: "str",
        folder_guid: "str",
        body: "Optional[GrantaServerApiSchemaFilesUpdateFolder]" = None,
    ) -> "Union[GrantaServerApiSchemaFilesFolder, None]":
        """Update an existing Exporters Folder.

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
        folder_guid: str
        body: GrantaServerApiSchemaFilesUpdateFolder

        Returns
        -------
        Union[GrantaServerApiSchemaFilesFolder, None]
        """
        data = self._update_exporters_folder_with_http_info(
            database_key, folder_guid, body, _return_http_data_only=True
        )
        return data  # type: ignore[no-any-return]

    def _update_exporters_folder_with_http_info(
        self,
        database_key: "str",
        folder_guid: "str",
        body: "Optional[GrantaServerApiSchemaFilesUpdateFolder]" = None,
        **kwargs: Any,
    ) -> Any:
        all_params = [
            "database_key",
            "folder_guid",
            "body",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method update_exporters_folder"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'update_exporters_folder'"
            )
        # verify the required parameter "folder_guid" is set
        if "folder_guid" not in params or params["folder_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'folder_guid' when calling 'update_exporters_folder'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]
        if "folder_guid" in params and folder_guid is not None:
            path_params["folder-guid"] = params["folder_guid"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        if "body" in params and body is not None:
            body_params = params["body"]
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(
            ["text/plain", "application/json", "text/json"]
        )

        # HTTP header 'Content-Type'
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json-patch+json", "application/json", "text/json", "application/*+json"]
        )

        response_type_map: Dict[int, Optional[str]] = {
            200: "GrantaServerApiSchemaFilesFolder",
            400: None,
            403: None,
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/exporters/{folder-guid}",
            "PATCH",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )
