# Copyright (C) 2023 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""
    MI Server API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: v1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import re  # noqa: F401
from typing import TYPE_CHECKING, Any, BinaryIO, Dict, List, Optional, Union  # noqa: F401

from . import ApiBase

if TYPE_CHECKING:
    import pathlib

    from ..models import *


class SchemaUnitsApi(ApiBase):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def create_unit(
        self, *, database_key: "str", body: "Optional[GrantaServerApiSchemaUnitsCreateUnit]" = None
    ) -> "Union[GrantaServerApiSchemaUnitsUnit, None]":
        """Create a new unit.

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
        body: GrantaServerApiSchemaUnitsCreateUnit

        Returns
        -------
        Union[GrantaServerApiSchemaUnitsUnit, None]
        """
        data = self._create_unit_with_http_info(database_key, body, _return_http_data_only=True)
        return data  # type: ignore[no-any-return]

    def _create_unit_with_http_info(
        self,
        database_key: "str",
        body: "Optional[GrantaServerApiSchemaUnitsCreateUnit]" = None,
        **kwargs: Any,
    ) -> Any:
        all_params = [
            "database_key",
            "body",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(f"Got an unexpected keyword argument '{key}' to method create_unit")
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'create_unit'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        if "body" in params and body is not None:
            body_params = params["body"]
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # HTTP header 'Content-Type'
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json-patch+json", "application/json", "text/json", "application/*+json"]
        )

        response_type_map: Dict[int, Optional[str]] = {
            201: "GrantaServerApiSchemaUnitsUnit",
            400: None,
            403: None,
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/units",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def create_unit_system(
        self,
        *,
        database_key: "str",
        body: "Optional[GrantaServerApiSchemaUnitsCreateUnitSystem]" = None,
    ) -> "Union[GrantaServerApiSchemaUnitsUnitSystem, None]":
        """Create a new unit system.

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
        body: GrantaServerApiSchemaUnitsCreateUnitSystem

        Returns
        -------
        Union[GrantaServerApiSchemaUnitsUnitSystem, None]
        """
        data = self._create_unit_system_with_http_info(
            database_key, body, _return_http_data_only=True
        )
        return data  # type: ignore[no-any-return]

    def _create_unit_system_with_http_info(
        self,
        database_key: "str",
        body: "Optional[GrantaServerApiSchemaUnitsCreateUnitSystem]" = None,
        **kwargs: Any,
    ) -> Any:
        all_params = [
            "database_key",
            "body",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method create_unit_system"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'create_unit_system'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        if "body" in params and body is not None:
            body_params = params["body"]
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # HTTP header 'Content-Type'
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json-patch+json", "application/json", "text/json", "application/*+json"]
        )

        response_type_map: Dict[int, Optional[str]] = {
            201: "GrantaServerApiSchemaUnitsUnitSystem",
            400: None,
            403: None,
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/unit-systems",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def delete_unit(self, *, database_key: "str", unit_guid: "str") -> "None":
        """Delete unit.

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
        unit_guid: str

        Returns
        -------
        None
        """
        data = self._delete_unit_with_http_info(
            database_key, unit_guid, _return_http_data_only=True
        )
        return data  # type: ignore[no-any-return]

    def _delete_unit_with_http_info(
        self, database_key: "str", unit_guid: "str", **kwargs: Any
    ) -> Any:
        all_params = [
            "database_key",
            "unit_guid",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(f"Got an unexpected keyword argument '{key}' to method delete_unit")
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'delete_unit'"
            )
        # verify the required parameter "unit_guid" is set
        if "unit_guid" not in params or params["unit_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'unit_guid' when calling 'delete_unit'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]
        if "unit_guid" in params and unit_guid is not None:
            path_params["unit-guid"] = params["unit_guid"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None

        response_type_map: Dict[int, Optional[str]] = {
            200: None,
            400: None,
            403: None,
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/units/{unit-guid}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def delete_unit_system(self, *, database_key: "str", unit_system_guid: "str") -> "None":
        """Delete a unit system.

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
        unit_system_guid: str

        Returns
        -------
        None
        """
        data = self._delete_unit_system_with_http_info(
            database_key, unit_system_guid, _return_http_data_only=True
        )
        return data  # type: ignore[no-any-return]

    def _delete_unit_system_with_http_info(
        self, database_key: "str", unit_system_guid: "str", **kwargs: Any
    ) -> Any:
        all_params = [
            "database_key",
            "unit_system_guid",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method delete_unit_system"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'delete_unit_system'"
            )
        # verify the required parameter "unit_system_guid" is set
        if "unit_system_guid" not in params or params["unit_system_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'unit_system_guid' when calling 'delete_unit_system'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]
        if "unit_system_guid" in params and unit_system_guid is not None:
            path_params["unit-system-guid"] = params["unit_system_guid"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None

        response_type_map: Dict[int, Optional[str]] = {
            200: None,
            400: None,
            403: None,
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/unit-systems/{unit-system-guid}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def get_compatible_units(
        self, *, database_key: "str", unit_guid: "str"
    ) -> "Union[GrantaServerApiSchemaUnitsUnitsInfo, None]":
        """Get compatible units for unit

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
        unit_guid: str

        Returns
        -------
        Union[GrantaServerApiSchemaUnitsUnitsInfo, None]
        """
        data = self._get_compatible_units_with_http_info(
            database_key, unit_guid, _return_http_data_only=True
        )
        return data  # type: ignore[no-any-return]

    def _get_compatible_units_with_http_info(
        self, database_key: "str", unit_guid: "str", **kwargs: Any
    ) -> Any:
        all_params = [
            "database_key",
            "unit_guid",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method get_compatible_units"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'get_compatible_units'"
            )
        # verify the required parameter "unit_guid" is set
        if "unit_guid" not in params or params["unit_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'unit_guid' when calling 'get_compatible_units'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]
        if "unit_guid" in params and unit_guid is not None:
            path_params["unit-guid"] = params["unit_guid"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        response_type_map: Dict[int, Optional[str]] = {
            200: "GrantaServerApiSchemaUnitsUnitsInfo",
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/units/{unit-guid}:compatible-units",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def get_unit(
        self, *, database_key: "str", unit_guid: "str"
    ) -> "Union[GrantaServerApiSchemaUnitsUnit, None]":
        """Get individual units

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
        unit_guid: str

        Returns
        -------
        Union[GrantaServerApiSchemaUnitsUnit, None]
        """
        data = self._get_unit_with_http_info(database_key, unit_guid, _return_http_data_only=True)
        return data  # type: ignore[no-any-return]

    def _get_unit_with_http_info(self, database_key: "str", unit_guid: "str", **kwargs: Any) -> Any:
        all_params = [
            "database_key",
            "unit_guid",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(f"Got an unexpected keyword argument '{key}' to method get_unit")
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'get_unit'"
            )
        # verify the required parameter "unit_guid" is set
        if "unit_guid" not in params or params["unit_guid"] is None:
            raise ValueError("Missing the required parameter 'unit_guid' when calling 'get_unit'")

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]
        if "unit_guid" in params and unit_guid is not None:
            path_params["unit-guid"] = params["unit_guid"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        response_type_map: Dict[int, Optional[str]] = {
            200: "GrantaServerApiSchemaUnitsUnit",
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/units/{unit-guid}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def get_unit_equivalents(
        self, *, database_key: "str", unit_guid: "str"
    ) -> "Union[GrantaServerApiSchemaUnitsUnitEquivalentsInfo, None]":
        """Get equivalent units (one per unit system)

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
        unit_guid: str

        Returns
        -------
        Union[GrantaServerApiSchemaUnitsUnitEquivalentsInfo, None]
        """
        data = self._get_unit_equivalents_with_http_info(
            database_key, unit_guid, _return_http_data_only=True
        )
        return data  # type: ignore[no-any-return]

    def _get_unit_equivalents_with_http_info(
        self, database_key: "str", unit_guid: "str", **kwargs: Any
    ) -> Any:
        all_params = [
            "database_key",
            "unit_guid",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method get_unit_equivalents"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'get_unit_equivalents'"
            )
        # verify the required parameter "unit_guid" is set
        if "unit_guid" not in params or params["unit_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'unit_guid' when calling 'get_unit_equivalents'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]
        if "unit_guid" in params and unit_guid is not None:
            path_params["unit-guid"] = params["unit_guid"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        response_type_map: Dict[int, Optional[str]] = {
            200: "GrantaServerApiSchemaUnitsUnitEquivalentsInfo",
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/units/{unit-guid}/equivalent-units",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def get_unit_system(
        self, *, database_key: "str", unit_system_guid: "str"
    ) -> "Union[GrantaServerApiSchemaUnitsUnitSystem, None]":
        """Get an individual unit system

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
        unit_system_guid: str

        Returns
        -------
        Union[GrantaServerApiSchemaUnitsUnitSystem, None]
        """
        data = self._get_unit_system_with_http_info(
            database_key, unit_system_guid, _return_http_data_only=True
        )
        return data  # type: ignore[no-any-return]

    def _get_unit_system_with_http_info(
        self, database_key: "str", unit_system_guid: "str", **kwargs: Any
    ) -> Any:
        all_params = [
            "database_key",
            "unit_system_guid",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method get_unit_system"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'get_unit_system'"
            )
        # verify the required parameter "unit_system_guid" is set
        if "unit_system_guid" not in params or params["unit_system_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'unit_system_guid' when calling 'get_unit_system'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]
        if "unit_system_guid" in params and unit_system_guid is not None:
            path_params["unit-system-guid"] = params["unit_system_guid"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        response_type_map: Dict[int, Optional[str]] = {
            200: "GrantaServerApiSchemaUnitsUnitSystem",
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/unit-systems/{unit-system-guid}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def get_unit_systems(
        self, *, database_key: "str"
    ) -> "Union[GrantaServerApiSchemaUnitsUnitSystemsInfo, None]":
        """Get all unit systems in the database

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str

        Returns
        -------
        Union[GrantaServerApiSchemaUnitsUnitSystemsInfo, None]
        """
        data = self._get_unit_systems_with_http_info(database_key, _return_http_data_only=True)
        return data  # type: ignore[no-any-return]

    def _get_unit_systems_with_http_info(self, database_key: "str", **kwargs: Any) -> Any:
        all_params = [
            "database_key",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method get_unit_systems"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'get_unit_systems'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        response_type_map: Dict[int, Optional[str]] = {
            200: "GrantaServerApiSchemaUnitsUnitSystemsInfo",
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/unit-systems",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def get_unit_usages(
        self, *, database_key: "str", unit_guid: "str"
    ) -> "Union[GrantaServerApiSchemaUnitsUnitUsage, None]":
        """Get all usages of unit

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
        unit_guid: str

        Returns
        -------
        Union[GrantaServerApiSchemaUnitsUnitUsage, None]
        """
        data = self._get_unit_usages_with_http_info(
            database_key, unit_guid, _return_http_data_only=True
        )
        return data  # type: ignore[no-any-return]

    def _get_unit_usages_with_http_info(
        self, database_key: "str", unit_guid: "str", **kwargs: Any
    ) -> Any:
        all_params = [
            "database_key",
            "unit_guid",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method get_unit_usages"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'get_unit_usages'"
            )
        # verify the required parameter "unit_guid" is set
        if "unit_guid" not in params or params["unit_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'unit_guid' when calling 'get_unit_usages'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]
        if "unit_guid" in params and unit_guid is not None:
            path_params["unit-guid"] = params["unit_guid"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        response_type_map: Dict[int, Optional[str]] = {
            200: "GrantaServerApiSchemaUnitsUnitUsage",
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/units/{unit-guid}:usages",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def get_units(
        self, *, database_key: "str"
    ) -> "Union[GrantaServerApiSchemaUnitsUnitsInfo, None]":
        """Get all units

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str

        Returns
        -------
        Union[GrantaServerApiSchemaUnitsUnitsInfo, None]
        """
        data = self._get_units_with_http_info(database_key, _return_http_data_only=True)
        return data  # type: ignore[no-any-return]

    def _get_units_with_http_info(self, database_key: "str", **kwargs: Any) -> Any:
        all_params = [
            "database_key",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(f"Got an unexpected keyword argument '{key}' to method get_units")
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'get_units'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        response_type_map: Dict[int, Optional[str]] = {
            200: "GrantaServerApiSchemaUnitsUnitsInfo",
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/units",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def set_unit_equivalent(
        self,
        *,
        database_key: "str",
        unit_guid: "str",
        unit_system_guid: "str",
        equivalent_unit_guid: "str",
    ) -> "None":
        """Set the equivalent unit for a given unit system

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
        unit_guid: str
        unit_system_guid: str
        equivalent_unit_guid: str

        Returns
        -------
        None
        """
        data = self._set_unit_equivalent_with_http_info(
            database_key,
            unit_guid,
            unit_system_guid,
            equivalent_unit_guid,
            _return_http_data_only=True,
        )
        return data  # type: ignore[no-any-return]

    def _set_unit_equivalent_with_http_info(
        self,
        database_key: "str",
        unit_guid: "str",
        unit_system_guid: "str",
        equivalent_unit_guid: "str",
        **kwargs: Any,
    ) -> Any:
        all_params = [
            "database_key",
            "unit_guid",
            "unit_system_guid",
            "equivalent_unit_guid",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method set_unit_equivalent"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'set_unit_equivalent'"
            )
        # verify the required parameter "unit_guid" is set
        if "unit_guid" not in params or params["unit_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'unit_guid' when calling 'set_unit_equivalent'"
            )
        # verify the required parameter "unit_system_guid" is set
        if "unit_system_guid" not in params or params["unit_system_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'unit_system_guid' when calling 'set_unit_equivalent'"
            )
        # verify the required parameter "equivalent_unit_guid" is set
        if "equivalent_unit_guid" not in params or params["equivalent_unit_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'equivalent_unit_guid' when calling 'set_unit_equivalent'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]
        if "unit_guid" in params and unit_guid is not None:
            path_params["unit-guid"] = params["unit_guid"]
        if "unit_system_guid" in params and unit_system_guid is not None:
            path_params["unit-system-guid"] = params["unit_system_guid"]
        if "equivalent_unit_guid" in params and equivalent_unit_guid is not None:
            path_params["equivalent-unit-guid"] = params["equivalent_unit_guid"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None

        response_type_map: Dict[int, Optional[str]] = {
            200: None,
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/units/{unit-guid}/equivalent-units/unit-system/{unit-system-guid}/equivalent-unit/{equivalent-unit-guid}:set-equivalent-unit",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def update_unit(
        self,
        *,
        database_key: "str",
        unit_guid: "str",
        body: "Optional[GrantaServerApiSchemaUnitsUpdateUnit]" = None,
    ) -> "Union[GrantaServerApiSchemaUnitsUnit, None]":
        """Update unit.

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
        unit_guid: str
        body: GrantaServerApiSchemaUnitsUpdateUnit

        Returns
        -------
        Union[GrantaServerApiSchemaUnitsUnit, None]
        """
        data = self._update_unit_with_http_info(
            database_key, unit_guid, body, _return_http_data_only=True
        )
        return data  # type: ignore[no-any-return]

    def _update_unit_with_http_info(
        self,
        database_key: "str",
        unit_guid: "str",
        body: "Optional[GrantaServerApiSchemaUnitsUpdateUnit]" = None,
        **kwargs: Any,
    ) -> Any:
        all_params = [
            "database_key",
            "unit_guid",
            "body",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(f"Got an unexpected keyword argument '{key}' to method update_unit")
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'update_unit'"
            )
        # verify the required parameter "unit_guid" is set
        if "unit_guid" not in params or params["unit_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'unit_guid' when calling 'update_unit'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]
        if "unit_guid" in params and unit_guid is not None:
            path_params["unit-guid"] = params["unit_guid"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        if "body" in params and body is not None:
            body_params = params["body"]
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # HTTP header 'Content-Type'
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json-patch+json", "application/json", "text/json", "application/*+json"]
        )

        response_type_map: Dict[int, Optional[str]] = {
            200: "GrantaServerApiSchemaUnitsUnit",
            400: None,
            403: None,
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/units/{unit-guid}",
            "PATCH",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def update_unit_system(
        self,
        *,
        database_key: "str",
        unit_system_guid: "str",
        body: "Optional[GrantaServerApiSchemaUnitsUpdateUnitSystem]" = None,
    ) -> "Union[GrantaServerApiSchemaUnitsUnitSystem, None]":
        """Update a unit system.

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        database_key: str
        unit_system_guid: str
        body: GrantaServerApiSchemaUnitsUpdateUnitSystem

        Returns
        -------
        Union[GrantaServerApiSchemaUnitsUnitSystem, None]
        """
        data = self._update_unit_system_with_http_info(
            database_key, unit_system_guid, body, _return_http_data_only=True
        )
        return data  # type: ignore[no-any-return]

    def _update_unit_system_with_http_info(
        self,
        database_key: "str",
        unit_system_guid: "str",
        body: "Optional[GrantaServerApiSchemaUnitsUpdateUnitSystem]" = None,
        **kwargs: Any,
    ) -> Any:
        all_params = [
            "database_key",
            "unit_system_guid",
            "body",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method update_unit_system"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "database_key" is set
        if "database_key" not in params or params["database_key"] is None:
            raise ValueError(
                "Missing the required parameter 'database_key' when calling 'update_unit_system'"
            )
        # verify the required parameter "unit_system_guid" is set
        if "unit_system_guid" not in params or params["unit_system_guid"] is None:
            raise ValueError(
                "Missing the required parameter 'unit_system_guid' when calling 'update_unit_system'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "database_key" in params and database_key is not None:
            path_params["database-key"] = params["database_key"]
        if "unit_system_guid" in params and unit_system_guid is not None:
            path_params["unit-system-guid"] = params["unit_system_guid"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        if "body" in params and body is not None:
            body_params = params["body"]
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(["application/json"])

        # HTTP header 'Content-Type'
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json-patch+json", "application/json", "text/json", "application/*+json"]
        )

        response_type_map: Dict[int, Optional[str]] = {
            200: "GrantaServerApiSchemaUnitsUnitSystem",
            400: None,
            403: None,
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/databases/{database-key}/unit-systems/{unit-system-guid}",
            "PATCH",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )
