# Copyright (C) 2023 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""
    MI Server API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: v1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import re  # noqa: F401
from typing import TYPE_CHECKING, Any, BinaryIO, Dict, List, Optional, Union  # noqa: F401

from . import ApiBase

if TYPE_CHECKING:
    import pathlib

    from ..models import *


class SelectionSearchesApi(ApiBase):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def create_search(
        self, *, body: "Optional[GrantaServerApiSelectionSearchesCreateSearchRequest]" = None
    ) -> "Union[GrantaServerApiSelectionSearchesSelectionSearch, None]":
        """Creates a new search with the specified properties.

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        body: GrantaServerApiSelectionSearchesCreateSearchRequest

        Returns
        -------
        Union[GrantaServerApiSelectionSearchesSelectionSearch, None]
        """
        data = self._create_search_with_http_info(body, _return_http_data_only=True)
        return data  # type: ignore[no-any-return]

    def _create_search_with_http_info(
        self,
        body: "Optional[GrantaServerApiSelectionSearchesCreateSearchRequest]" = None,
        **kwargs: Any,
    ) -> Any:
        all_params = ["body", "_return_http_data_only", "_preload_content", "_request_timeout"]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method create_search"
                )
            params[key] = val
        del params["kwargs"]

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        if "body" in params and body is not None:
            body_params = params["body"]
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(
            ["text/plain", "application/json", "text/json"]
        )

        # HTTP header 'Content-Type'
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json-patch+json", "application/json", "text/json", "application/*+json"]
        )

        response_type_map: Dict[int, Optional[str]] = {
            201: "GrantaServerApiSelectionSearchesSelectionSearch",
            400: None,
            403: None,
        }

        return self.api_client.call_api(
            "/v1alpha/selection-searches",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def delete_search(self, *, search_identifier: "str") -> "None":
        """Delete an existing selection search.

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        search_identifier: str

        Returns
        -------
        None
        """
        data = self._delete_search_with_http_info(search_identifier, _return_http_data_only=True)
        return data  # type: ignore[no-any-return]

    def _delete_search_with_http_info(self, search_identifier: "str", **kwargs: Any) -> Any:
        all_params = [
            "search_identifier",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(
                    f"Got an unexpected keyword argument '{key}' to method delete_search"
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "search_identifier" is set
        if "search_identifier" not in params or params["search_identifier"] is None:
            raise ValueError(
                "Missing the required parameter 'search_identifier' when calling 'delete_search'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "search_identifier" in params and search_identifier is not None:
            path_params["searchIdentifier"] = params["search_identifier"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None

        response_type_map: Dict[int, Optional[str]] = {
            200: None,
            403: None,
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/selection-searches/search/{searchIdentifier}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def get_all(self) -> "Union[List[GrantaServerApiSelectionSearchesSelectionSearch], None]":
        """Returns all searches visible to the calling user.

        This method makes a synchronous HTTP request.

        Returns
        -------
        Union[List[GrantaServerApiSelectionSearchesSelectionSearch], None]
        """
        data = self._get_all_with_http_info(_return_http_data_only=True)
        return data  # type: ignore[no-any-return]

    def _get_all_with_http_info(self, **kwargs: Any) -> Any:
        all_params = ["_return_http_data_only", "_preload_content", "_request_timeout"]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(f"Got an unexpected keyword argument '{key}' to method get_all")
            params[key] = val
        del params["kwargs"]

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(
            ["text/plain", "application/json", "text/json"]
        )

        response_type_map: Dict[int, Optional[str]] = {
            200: "list[GrantaServerApiSelectionSearchesSelectionSearch]",
            403: None,
        }

        return self.api_client.call_api(
            "/v1alpha/selection-searches",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def get_search(
        self, *, search_identifier: "str"
    ) -> "Union[GrantaServerApiSelectionSearchesSelectionSearch, None]":
        """Returns the given search if it exists and the calling user has access to it

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        search_identifier: str

        Returns
        -------
        Union[GrantaServerApiSelectionSearchesSelectionSearch, None]
        """
        data = self._get_search_with_http_info(search_identifier, _return_http_data_only=True)
        return data  # type: ignore[no-any-return]

    def _get_search_with_http_info(self, search_identifier: "str", **kwargs: Any) -> Any:
        all_params = [
            "search_identifier",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(f"Got an unexpected keyword argument '{key}' to method get_search")
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "search_identifier" is set
        if "search_identifier" not in params or params["search_identifier"] is None:
            raise ValueError(
                "Missing the required parameter 'search_identifier' when calling 'get_search'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "search_identifier" in params and search_identifier is not None:
            path_params["searchIdentifier"] = params["search_identifier"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(
            ["text/plain", "application/json", "text/json"]
        )

        response_type_map: Dict[int, Optional[str]] = {
            200: "GrantaServerApiSelectionSearchesSelectionSearch",
            403: None,
            404: None,
            410: None,
        }

        return self.api_client.call_api(
            "/v1alpha/selection-searches/search/{searchIdentifier}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def save_search(
        self,
        *,
        search_identifier: "str",
        body: "Optional[GrantaServerApiSelectionSearchesSaveSearchRequest]" = None,
    ) -> "None":
        """If the search exists, updates the properties of the search. This will overwrite all current properties.  If the search does not exist or the calling user does not have access to it, returns '404 not found' response.

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        search_identifier: str
        body: GrantaServerApiSelectionSearchesSaveSearchRequest

        Returns
        -------
        None
        """
        data = self._save_search_with_http_info(
            search_identifier, body, _return_http_data_only=True
        )
        return data  # type: ignore[no-any-return]

    def _save_search_with_http_info(
        self,
        search_identifier: "str",
        body: "Optional[GrantaServerApiSelectionSearchesSaveSearchRequest]" = None,
        **kwargs: Any,
    ) -> Any:
        all_params = [
            "search_identifier",
            "body",
            "_return_http_data_only",
            "_preload_content",
            "_request_timeout",
        ]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(f"Got an unexpected keyword argument '{key}' to method save_search")
            params[key] = val
        del params["kwargs"]
        # verify the required parameter "search_identifier" is set
        if "search_identifier" not in params or params["search_identifier"] is None:
            raise ValueError(
                "Missing the required parameter 'search_identifier' when calling 'save_search'"
            )

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}
        if "search_identifier" in params and search_identifier is not None:
            path_params["searchIdentifier"] = params["search_identifier"]

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        if "body" in params and body is not None:
            body_params = params["body"]
        # HTTP header 'Content-Type'
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json-patch+json", "application/json", "text/json", "application/*+json"]
        )

        response_type_map: Dict[int, Optional[str]] = {
            200: None,
            400: None,
            403: None,
            404: None,
        }

        return self.api_client.call_api(
            "/v1alpha/selection-searches/search/{searchIdentifier}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )

    def search(
        self, *, body: "Optional[GrantaServerApiSelectionSearchesFindSearchRequest]" = None
    ) -> "Union[GrantaServerApiSelectionSearchesSelectionSearch, None]":
        """Retrieves a collection of searches that match the specified criteria.

        This method makes a synchronous HTTP request.

        Parameters
        ----------
        body: GrantaServerApiSelectionSearchesFindSearchRequest

        Returns
        -------
        Union[GrantaServerApiSelectionSearchesSelectionSearch, None]
        """
        data = self._search_with_http_info(body, _return_http_data_only=True)
        return data  # type: ignore[no-any-return]

    def _search_with_http_info(
        self,
        body: "Optional[GrantaServerApiSelectionSearchesFindSearchRequest]" = None,
        **kwargs: Any,
    ) -> Any:
        all_params = ["body", "_return_http_data_only", "_preload_content", "_request_timeout"]

        params = locals()
        for key, val in params["kwargs"].items():
            if key not in all_params:
                raise TypeError(f"Got an unexpected keyword argument '{key}' to method search")
            params[key] = val
        del params["kwargs"]

        collection_formats: Dict[str, Any] = {}

        path_params: Dict[str, Any] = {}

        query_params: List[Any] = []

        header_params: Dict[str, Any] = {}

        form_params: List[Any] = []
        local_var_files: Dict[str, Any] = {}

        body_params = None
        if "body" in params and body is not None:
            body_params = params["body"]
        # HTTP header 'Accept'
        header_params["Accept"] = self.api_client.select_header_accept(
            ["text/plain", "application/json", "text/json"]
        )

        # HTTP header 'Content-Type'
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json-patch+json", "application/json", "text/json", "application/*+json"]
        )

        response_type_map: Dict[int, Optional[str]] = {
            200: "GrantaServerApiSelectionSearchesSelectionSearch",
            400: None,
            403: None,
        }

        return self.api_client.call_api(
            "/v1alpha/selection-searches/search",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
            response_type_map=response_type_map,
        )
