# Copyright (C) 2023 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""
    MI Server API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: v1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import re  # noqa: F401
from typing import TYPE_CHECKING, Any, BinaryIO, Dict, List, Optional, Union  # noqa: F401

from . import ModelBase, Unset, Unset_Type

if TYPE_CHECKING:
    from datetime import datetime
    import pathlib

    from . import *


class GrantaServerApiAsyncJobsCurrentUser(ModelBase):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes
    ----------
    swagger_types: Dict[str, str]
        The key is attribute name and the value is attribute type.
    attribute_map: Dict[str, str]
        The key is attribute name and the value is json key in definition.
    subtype_mapping: Dict[str, str]
        The key is the unmangled property name and the value is the corresponding type.
    discriminator: Optional[str]
        Name of the property used as discriminator for subtypes.
    """
    swagger_types: Dict[str, str] = {
        "has_write_access": "bool",
        "is_admin": "bool",
        "username": "str",
    }

    attribute_map: Dict[str, str] = {
        "has_write_access": "hasWriteAccess",
        "is_admin": "isAdmin",
        "username": "username",
    }

    subtype_mapping: Dict[str, str] = {}

    discriminator: Optional[str] = None

    def __init__(
        self,
        *,
        has_write_access: "Union[bool, Unset_Type]" = Unset,
        is_admin: "Union[bool, Unset_Type]" = Unset,
        username: "Union[str, None, Unset_Type]" = Unset,
    ) -> None:
        """GrantaServerApiAsyncJobsCurrentUser - a model defined in Swagger

        Parameters
        ----------
        has_write_access: bool, optional
        is_admin: bool, optional
        username: str, optional
        """
        self._is_admin: Union[bool, Unset_Type] = Unset
        self._username: Union[str, None, Unset_Type] = Unset
        self._has_write_access: Union[bool, Unset_Type] = Unset

        if is_admin is not Unset:
            self.is_admin = is_admin
        if username is not Unset:
            self.username = username
        if has_write_access is not Unset:
            self.has_write_access = has_write_access

    @property
    def is_admin(self) -> "Union[bool, Unset_Type]":
        """Gets the is_admin of this GrantaServerApiAsyncJobsCurrentUser.

        Returns
        -------
        Union[bool, Unset_Type]
            The is_admin of this GrantaServerApiAsyncJobsCurrentUser.
        """
        return self._is_admin

    @is_admin.setter
    def is_admin(self, is_admin: "Union[bool, Unset_Type]") -> None:
        """Sets the is_admin of this GrantaServerApiAsyncJobsCurrentUser.

        Parameters
        ----------
        is_admin: Union[bool, Unset_Type]
            The is_admin of this GrantaServerApiAsyncJobsCurrentUser.
        """
        # Field is not nullable
        if is_admin is None:
            raise ValueError("Invalid value for 'is_admin', must not be 'None'")
        self._is_admin = is_admin

    @property
    def username(self) -> "Union[str, None, Unset_Type]":
        """Gets the username of this GrantaServerApiAsyncJobsCurrentUser.

        Returns
        -------
        Union[str, None, Unset_Type]
            The username of this GrantaServerApiAsyncJobsCurrentUser.
        """
        return self._username

    @username.setter
    def username(self, username: "Union[str, None, Unset_Type]") -> None:
        """Sets the username of this GrantaServerApiAsyncJobsCurrentUser.

        Parameters
        ----------
        username: Union[str, None, Unset_Type]
            The username of this GrantaServerApiAsyncJobsCurrentUser.
        """
        self._username = username

    @property
    def has_write_access(self) -> "Union[bool, Unset_Type]":
        """Gets the has_write_access of this GrantaServerApiAsyncJobsCurrentUser.

        Returns
        -------
        Union[bool, Unset_Type]
            The has_write_access of this GrantaServerApiAsyncJobsCurrentUser.
        """
        return self._has_write_access

    @has_write_access.setter
    def has_write_access(self, has_write_access: "Union[bool, Unset_Type]") -> None:
        """Sets the has_write_access of this GrantaServerApiAsyncJobsCurrentUser.

        Parameters
        ----------
        has_write_access: Union[bool, Unset_Type]
            The has_write_access of this GrantaServerApiAsyncJobsCurrentUser.
        """
        # Field is not nullable
        if has_write_access is None:
            raise ValueError("Invalid value for 'has_write_access', must not be 'None'")
        self._has_write_access = has_write_access

    @classmethod
    def get_real_child_model(cls, data: Dict[str, str]) -> str:
        """Raises a NotImplementedError for a type without a discriminator defined.

        Parameters
        ----------
        data: ModelBase
            Object representing a subclass of this class

        Raises
        ------
        NotImplementedError
            This class has no discriminator, and hence no subclasses
        """
        raise NotImplementedError()

    def __repr__(self) -> str:
        """For 'print' and 'pprint'"""
        return self.to_str()

    def __eq__(self, other: Any) -> bool:
        """Returns true if both objects are equal"""
        if not isinstance(other, GrantaServerApiAsyncJobsCurrentUser):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other: Any) -> bool:
        """Returns true if both objects are not equal"""
        return not self == other
