# Copyright (C) 2023 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""
    MI Server API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: v1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import re  # noqa: F401
from typing import TYPE_CHECKING, Any, BinaryIO, Dict, List, Optional, Union  # noqa: F401

from . import ModelBase, Unset, Unset_Type

if TYPE_CHECKING:
    from datetime import datetime
    import pathlib

    from . import *


class GrantaServerApiAsyncJobsProcessingConfig(ModelBase):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes
    ----------
    swagger_types: Dict[str, str]
        The key is attribute name and the value is attribute type.
    attribute_map: Dict[str, str]
        The key is attribute name and the value is json key in definition.
    subtype_mapping: Dict[str, str]
        The key is the unmangled property name and the value is the corresponding type.
    discriminator: Optional[str]
        Name of the property used as discriminator for subtypes.
    """
    swagger_types: Dict[str, str] = {
        "concurrency": "int",
        "polling_interval_in_milliseconds": "int",
        "purge_interval_in_milliseconds": "int",
        "purge_job_age_in_milliseconds": "int",
    }

    attribute_map: Dict[str, str] = {
        "concurrency": "concurrency",
        "polling_interval_in_milliseconds": "pollingIntervalInMilliseconds",
        "purge_interval_in_milliseconds": "purgeIntervalInMilliseconds",
        "purge_job_age_in_milliseconds": "purgeJobAgeInMilliseconds",
    }

    subtype_mapping: Dict[str, str] = {}

    discriminator: Optional[str] = None

    def __init__(
        self,
        *,
        concurrency: "Union[int, Unset_Type]" = Unset,
        polling_interval_in_milliseconds: "Union[int, Unset_Type]" = Unset,
        purge_interval_in_milliseconds: "Union[int, Unset_Type]" = Unset,
        purge_job_age_in_milliseconds: "Union[int, Unset_Type]" = Unset,
    ) -> None:
        """GrantaServerApiAsyncJobsProcessingConfig - a model defined in Swagger

        Parameters
        ----------
        concurrency: int, optional
        polling_interval_in_milliseconds: int, optional
        purge_interval_in_milliseconds: int, optional
        purge_job_age_in_milliseconds: int, optional
        """
        self._purge_job_age_in_milliseconds: Union[int, Unset_Type] = Unset
        self._purge_interval_in_milliseconds: Union[int, Unset_Type] = Unset
        self._polling_interval_in_milliseconds: Union[int, Unset_Type] = Unset
        self._concurrency: Union[int, Unset_Type] = Unset

        if purge_job_age_in_milliseconds is not Unset:
            self.purge_job_age_in_milliseconds = purge_job_age_in_milliseconds
        if purge_interval_in_milliseconds is not Unset:
            self.purge_interval_in_milliseconds = purge_interval_in_milliseconds
        if polling_interval_in_milliseconds is not Unset:
            self.polling_interval_in_milliseconds = polling_interval_in_milliseconds
        if concurrency is not Unset:
            self.concurrency = concurrency

    @property
    def purge_job_age_in_milliseconds(self) -> "Union[int, Unset_Type]":
        """Gets the purge_job_age_in_milliseconds of this GrantaServerApiAsyncJobsProcessingConfig.

        Returns
        -------
        Union[int, Unset_Type]
            The purge_job_age_in_milliseconds of this GrantaServerApiAsyncJobsProcessingConfig.
        """
        return self._purge_job_age_in_milliseconds

    @purge_job_age_in_milliseconds.setter
    def purge_job_age_in_milliseconds(
        self, purge_job_age_in_milliseconds: "Union[int, Unset_Type]"
    ) -> None:
        """Sets the purge_job_age_in_milliseconds of this GrantaServerApiAsyncJobsProcessingConfig.

        Parameters
        ----------
        purge_job_age_in_milliseconds: Union[int, Unset_Type]
            The purge_job_age_in_milliseconds of this GrantaServerApiAsyncJobsProcessingConfig.
        """
        # Field is not nullable
        if purge_job_age_in_milliseconds is None:
            raise ValueError(
                "Invalid value for 'purge_job_age_in_milliseconds', must not be 'None'"
            )
        self._purge_job_age_in_milliseconds = purge_job_age_in_milliseconds

    @property
    def purge_interval_in_milliseconds(self) -> "Union[int, Unset_Type]":
        """Gets the purge_interval_in_milliseconds of this GrantaServerApiAsyncJobsProcessingConfig.

        Returns
        -------
        Union[int, Unset_Type]
            The purge_interval_in_milliseconds of this GrantaServerApiAsyncJobsProcessingConfig.
        """
        return self._purge_interval_in_milliseconds

    @purge_interval_in_milliseconds.setter
    def purge_interval_in_milliseconds(
        self, purge_interval_in_milliseconds: "Union[int, Unset_Type]"
    ) -> None:
        """Sets the purge_interval_in_milliseconds of this GrantaServerApiAsyncJobsProcessingConfig.

        Parameters
        ----------
        purge_interval_in_milliseconds: Union[int, Unset_Type]
            The purge_interval_in_milliseconds of this GrantaServerApiAsyncJobsProcessingConfig.
        """
        # Field is not nullable
        if purge_interval_in_milliseconds is None:
            raise ValueError(
                "Invalid value for 'purge_interval_in_milliseconds', must not be 'None'"
            )
        self._purge_interval_in_milliseconds = purge_interval_in_milliseconds

    @property
    def polling_interval_in_milliseconds(self) -> "Union[int, Unset_Type]":
        """Gets the polling_interval_in_milliseconds of this GrantaServerApiAsyncJobsProcessingConfig.

        Returns
        -------
        Union[int, Unset_Type]
            The polling_interval_in_milliseconds of this GrantaServerApiAsyncJobsProcessingConfig.
        """
        return self._polling_interval_in_milliseconds

    @polling_interval_in_milliseconds.setter
    def polling_interval_in_milliseconds(
        self, polling_interval_in_milliseconds: "Union[int, Unset_Type]"
    ) -> None:
        """Sets the polling_interval_in_milliseconds of this GrantaServerApiAsyncJobsProcessingConfig.

        Parameters
        ----------
        polling_interval_in_milliseconds: Union[int, Unset_Type]
            The polling_interval_in_milliseconds of this GrantaServerApiAsyncJobsProcessingConfig.
        """
        # Field is not nullable
        if polling_interval_in_milliseconds is None:
            raise ValueError(
                "Invalid value for 'polling_interval_in_milliseconds', must not be 'None'"
            )
        self._polling_interval_in_milliseconds = polling_interval_in_milliseconds

    @property
    def concurrency(self) -> "Union[int, Unset_Type]":
        """Gets the concurrency of this GrantaServerApiAsyncJobsProcessingConfig.

        Returns
        -------
        Union[int, Unset_Type]
            The concurrency of this GrantaServerApiAsyncJobsProcessingConfig.
        """
        return self._concurrency

    @concurrency.setter
    def concurrency(self, concurrency: "Union[int, Unset_Type]") -> None:
        """Sets the concurrency of this GrantaServerApiAsyncJobsProcessingConfig.

        Parameters
        ----------
        concurrency: Union[int, Unset_Type]
            The concurrency of this GrantaServerApiAsyncJobsProcessingConfig.
        """
        # Field is not nullable
        if concurrency is None:
            raise ValueError("Invalid value for 'concurrency', must not be 'None'")
        self._concurrency = concurrency

    @classmethod
    def get_real_child_model(cls, data: Dict[str, str]) -> str:
        """Raises a NotImplementedError for a type without a discriminator defined.

        Parameters
        ----------
        data: ModelBase
            Object representing a subclass of this class

        Raises
        ------
        NotImplementedError
            This class has no discriminator, and hence no subclasses
        """
        raise NotImplementedError()

    def __repr__(self) -> str:
        """For 'print' and 'pprint'"""
        return self.to_str()

    def __eq__(self, other: Any) -> bool:
        """Returns true if both objects are equal"""
        if not isinstance(other, GrantaServerApiAsyncJobsProcessingConfig):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other: Any) -> bool:
        """Returns true if both objects are not equal"""
        return not self == other
