# Copyright (C) 2023 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""
    MI Server API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: v1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import re  # noqa: F401
from typing import TYPE_CHECKING, Any, BinaryIO, Dict, List, Optional, Union  # noqa: F401

from . import ModelBase, Unset, Unset_Type

if TYPE_CHECKING:
    from datetime import datetime
    import pathlib

    from . import *


class GrantaServerApiDataExportDatumsHyperlink(ModelBase):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes
    ----------
    swagger_types: Dict[str, str]
        The key is attribute name and the value is attribute type.
    attribute_map: Dict[str, str]
        The key is attribute name and the value is json key in definition.
    subtype_mapping: Dict[str, str]
        The key is the unmangled property name and the value is the corresponding type.
    discriminator: Optional[str]
        Name of the property used as discriminator for subtypes.
    """
    swagger_types: Dict[str, str] = {
        "address": "str",
        "description": "str",
        "formatted_address": "str",
    }

    attribute_map: Dict[str, str] = {
        "address": "address",
        "description": "description",
        "formatted_address": "formattedAddress",
    }

    subtype_mapping: Dict[str, str] = {}

    discriminator: Optional[str] = None

    def __init__(
        self,
        *,
        address: "Union[str, None, Unset_Type]" = Unset,
        description: "Union[str, None, Unset_Type]" = Unset,
        formatted_address: "Union[str, None, Unset_Type]" = Unset,
    ) -> None:
        """GrantaServerApiDataExportDatumsHyperlink - a model defined in Swagger

        Parameters
        ----------
        address: str, optional
        description: str, optional
        formatted_address: str, optional
        """
        self._address: Union[str, None, Unset_Type] = Unset
        self._formatted_address: Union[str, None, Unset_Type] = Unset
        self._description: Union[str, None, Unset_Type] = Unset

        if address is not Unset:
            self.address = address
        if formatted_address is not Unset:
            self.formatted_address = formatted_address
        if description is not Unset:
            self.description = description

    @property
    def address(self) -> "Union[str, None, Unset_Type]":
        """Gets the address of this GrantaServerApiDataExportDatumsHyperlink.

        Returns
        -------
        Union[str, None, Unset_Type]
            The address of this GrantaServerApiDataExportDatumsHyperlink.
        """
        return self._address

    @address.setter
    def address(self, address: "Union[str, None, Unset_Type]") -> None:
        """Sets the address of this GrantaServerApiDataExportDatumsHyperlink.

        Parameters
        ----------
        address: Union[str, None, Unset_Type]
            The address of this GrantaServerApiDataExportDatumsHyperlink.
        """
        self._address = address

    @property
    def formatted_address(self) -> "Union[str, None, Unset_Type]":
        """Gets the formatted_address of this GrantaServerApiDataExportDatumsHyperlink.

        Returns
        -------
        Union[str, None, Unset_Type]
            The formatted_address of this GrantaServerApiDataExportDatumsHyperlink.
        """
        return self._formatted_address

    @formatted_address.setter
    def formatted_address(self, formatted_address: "Union[str, None, Unset_Type]") -> None:
        """Sets the formatted_address of this GrantaServerApiDataExportDatumsHyperlink.

        Parameters
        ----------
        formatted_address: Union[str, None, Unset_Type]
            The formatted_address of this GrantaServerApiDataExportDatumsHyperlink.
        """
        self._formatted_address = formatted_address

    @property
    def description(self) -> "Union[str, None, Unset_Type]":
        """Gets the description of this GrantaServerApiDataExportDatumsHyperlink.

        Returns
        -------
        Union[str, None, Unset_Type]
            The description of this GrantaServerApiDataExportDatumsHyperlink.
        """
        return self._description

    @description.setter
    def description(self, description: "Union[str, None, Unset_Type]") -> None:
        """Sets the description of this GrantaServerApiDataExportDatumsHyperlink.

        Parameters
        ----------
        description: Union[str, None, Unset_Type]
            The description of this GrantaServerApiDataExportDatumsHyperlink.
        """
        self._description = description

    @classmethod
    def get_real_child_model(cls, data: Dict[str, str]) -> str:
        """Raises a NotImplementedError for a type without a discriminator defined.

        Parameters
        ----------
        data: ModelBase
            Object representing a subclass of this class

        Raises
        ------
        NotImplementedError
            This class has no discriminator, and hence no subclasses
        """
        raise NotImplementedError()

    def __repr__(self) -> str:
        """For 'print' and 'pprint'"""
        return self.to_str()

    def __eq__(self, other: Any) -> bool:
        """Returns true if both objects are equal"""
        if not isinstance(other, GrantaServerApiDataExportDatumsHyperlink):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other: Any) -> bool:
        """Returns true if both objects are not equal"""
        return not self == other
