# Copyright (C) 2023 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""
    MI Server API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: v1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import re  # noqa: F401
from typing import TYPE_CHECKING, Any, BinaryIO, Dict, List, Optional, Union  # noqa: F401

from . import ModelBase, Unset, Unset_Type

if TYPE_CHECKING:
    from datetime import datetime
    import pathlib

    from . import *


class GrantaServerApiDataExportDatumsParameterValue(ModelBase):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes
    ----------
    swagger_types: Dict[str, str]
        The key is attribute name and the value is attribute type.
    attribute_map: Dict[str, str]
        The key is attribute name and the value is json key in definition.
    subtype_mapping: Dict[str, str]
        The key is the unmangled property name and the value is the corresponding type.
    discriminator: Optional[str]
        Name of the property used as discriminator for subtypes.
    """
    swagger_types: Dict[str, str] = {
        "parameter": "GrantaServerApiParameterInfo",
        "value": "float",
        "value_name": "str",
    }

    attribute_map: Dict[str, str] = {
        "parameter": "parameter",
        "value": "value",
        "value_name": "valueName",
    }

    subtype_mapping: Dict[str, str] = {
        "parameter": "GrantaServerApiParameterInfo",
    }

    discriminator: Optional[str] = None

    def __init__(
        self,
        *,
        parameter: "Union[GrantaServerApiParameterInfo, Unset_Type]" = Unset,
        value: "Union[float, Unset_Type]" = Unset,
        value_name: "Union[str, None, Unset_Type]" = Unset,
    ) -> None:
        """GrantaServerApiDataExportDatumsParameterValue - a model defined in Swagger

        Parameters
        ----------
        parameter: GrantaServerApiParameterInfo, optional
        value: float, optional
        value_name: str, optional
        """
        self._parameter: Union[GrantaServerApiParameterInfo, Unset_Type] = Unset
        self._value_name: Union[str, None, Unset_Type] = Unset
        self._value: Union[float, Unset_Type] = Unset

        if parameter is not Unset:
            self.parameter = parameter
        if value_name is not Unset:
            self.value_name = value_name
        if value is not Unset:
            self.value = value

    @property
    def parameter(self) -> "Union[GrantaServerApiParameterInfo, Unset_Type]":
        """Gets the parameter of this GrantaServerApiDataExportDatumsParameterValue.

        Returns
        -------
        Union[GrantaServerApiParameterInfo, Unset_Type]
            The parameter of this GrantaServerApiDataExportDatumsParameterValue.
        """
        return self._parameter

    @parameter.setter
    def parameter(self, parameter: "Union[GrantaServerApiParameterInfo, Unset_Type]") -> None:
        """Sets the parameter of this GrantaServerApiDataExportDatumsParameterValue.

        Parameters
        ----------
        parameter: Union[GrantaServerApiParameterInfo, Unset_Type]
            The parameter of this GrantaServerApiDataExportDatumsParameterValue.
        """
        # Field is not nullable
        if parameter is None:
            raise ValueError("Invalid value for 'parameter', must not be 'None'")
        self._parameter = parameter

    @property
    def value_name(self) -> "Union[str, None, Unset_Type]":
        """Gets the value_name of this GrantaServerApiDataExportDatumsParameterValue.

        Returns
        -------
        Union[str, None, Unset_Type]
            The value_name of this GrantaServerApiDataExportDatumsParameterValue.
        """
        return self._value_name

    @value_name.setter
    def value_name(self, value_name: "Union[str, None, Unset_Type]") -> None:
        """Sets the value_name of this GrantaServerApiDataExportDatumsParameterValue.

        Parameters
        ----------
        value_name: Union[str, None, Unset_Type]
            The value_name of this GrantaServerApiDataExportDatumsParameterValue.
        """
        self._value_name = value_name

    @property
    def value(self) -> "Union[float, Unset_Type]":
        """Gets the value of this GrantaServerApiDataExportDatumsParameterValue.

        Returns
        -------
        Union[float, Unset_Type]
            The value of this GrantaServerApiDataExportDatumsParameterValue.
        """
        return self._value

    @value.setter
    def value(self, value: "Union[float, Unset_Type]") -> None:
        """Sets the value of this GrantaServerApiDataExportDatumsParameterValue.

        Parameters
        ----------
        value: Union[float, Unset_Type]
            The value of this GrantaServerApiDataExportDatumsParameterValue.
        """
        # Field is not nullable
        if value is None:
            raise ValueError("Invalid value for 'value', must not be 'None'")
        self._value = value

    @classmethod
    def get_real_child_model(cls, data: Dict[str, str]) -> str:
        """Raises a NotImplementedError for a type without a discriminator defined.

        Parameters
        ----------
        data: ModelBase
            Object representing a subclass of this class

        Raises
        ------
        NotImplementedError
            This class has no discriminator, and hence no subclasses
        """
        raise NotImplementedError()

    def __repr__(self) -> str:
        """For 'print' and 'pprint'"""
        return self.to_str()

    def __eq__(self, other: Any) -> bool:
        """Returns true if both objects are equal"""
        if not isinstance(other, GrantaServerApiDataExportDatumsParameterValue):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other: Any) -> bool:
        """Returns true if both objects are not equal"""
        return not self == other
