# Copyright (C) 2023 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""
    MI Server API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: v1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import re  # noqa: F401
from typing import TYPE_CHECKING, Any, BinaryIO, Dict, List, Optional, Union  # noqa: F401

from . import ModelBase, Unset, Unset_Type

if TYPE_CHECKING:
    from datetime import datetime
    import pathlib

    from . import *


class GrantaServerApiDataExportExportFailuresLinkReference(ModelBase):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes
    ----------
    swagger_types: Dict[str, str]
        The key is attribute name and the value is attribute type.
    attribute_map: Dict[str, str]
        The key is attribute name and the value is json key in definition.
    subtype_mapping: Dict[str, str]
        The key is the unmangled property name and the value is the corresponding type.
    discriminator: Optional[str]
        Name of the property used as discriminator for subtypes.
    """
    swagger_types: Dict[str, str] = {
        "link_type": "GrantaServerApiLinkAttributeType",
        "link_guid": "str",
        "link_identity": "int",
        "target_database_guid": "str",
    }

    attribute_map: Dict[str, str] = {
        "link_type": "linkType",
        "link_guid": "linkGuid",
        "link_identity": "linkIdentity",
        "target_database_guid": "targetDatabaseGuid",
    }

    subtype_mapping: Dict[str, str] = {
        "linkType": "GrantaServerApiLinkAttributeType",
    }

    discriminator: Optional[str] = None

    def __init__(
        self,
        *,
        link_type: "GrantaServerApiLinkAttributeType",
        link_guid: "Union[str, None, Unset_Type]" = Unset,
        link_identity: "Union[int, None, Unset_Type]" = Unset,
        target_database_guid: "Union[str, None, Unset_Type]" = Unset,
    ) -> None:
        """GrantaServerApiDataExportExportFailuresLinkReference - a model defined in Swagger

        Parameters
        ----------
        link_type: GrantaServerApiLinkAttributeType
        link_guid: str, optional
        link_identity: int, optional
        target_database_guid: str, optional
        """
        self._target_database_guid: Union[str, None, Unset_Type] = Unset
        self._link_identity: Union[int, None, Unset_Type] = Unset
        self._link_guid: Union[str, None, Unset_Type] = Unset
        self._link_type: GrantaServerApiLinkAttributeType

        if target_database_guid is not Unset:
            self.target_database_guid = target_database_guid
        if link_identity is not Unset:
            self.link_identity = link_identity
        if link_guid is not Unset:
            self.link_guid = link_guid
        self.link_type = link_type

    @property
    def target_database_guid(self) -> "Union[str, None, Unset_Type]":
        """Gets the target_database_guid of this GrantaServerApiDataExportExportFailuresLinkReference.

        Returns
        -------
        Union[str, None, Unset_Type]
            The target_database_guid of this GrantaServerApiDataExportExportFailuresLinkReference.
        """
        return self._target_database_guid

    @target_database_guid.setter
    def target_database_guid(self, target_database_guid: "Union[str, None, Unset_Type]") -> None:
        """Sets the target_database_guid of this GrantaServerApiDataExportExportFailuresLinkReference.

        Parameters
        ----------
        target_database_guid: Union[str, None, Unset_Type]
            The target_database_guid of this GrantaServerApiDataExportExportFailuresLinkReference.
        """
        self._target_database_guid = target_database_guid

    @property
    def link_identity(self) -> "Union[int, None, Unset_Type]":
        """Gets the link_identity of this GrantaServerApiDataExportExportFailuresLinkReference.

        Returns
        -------
        Union[int, None, Unset_Type]
            The link_identity of this GrantaServerApiDataExportExportFailuresLinkReference.
        """
        return self._link_identity

    @link_identity.setter
    def link_identity(self, link_identity: "Union[int, None, Unset_Type]") -> None:
        """Sets the link_identity of this GrantaServerApiDataExportExportFailuresLinkReference.

        Parameters
        ----------
        link_identity: Union[int, None, Unset_Type]
            The link_identity of this GrantaServerApiDataExportExportFailuresLinkReference.
        """
        self._link_identity = link_identity

    @property
    def link_guid(self) -> "Union[str, None, Unset_Type]":
        """Gets the link_guid of this GrantaServerApiDataExportExportFailuresLinkReference.

        Returns
        -------
        Union[str, None, Unset_Type]
            The link_guid of this GrantaServerApiDataExportExportFailuresLinkReference.
        """
        return self._link_guid

    @link_guid.setter
    def link_guid(self, link_guid: "Union[str, None, Unset_Type]") -> None:
        """Sets the link_guid of this GrantaServerApiDataExportExportFailuresLinkReference.

        Parameters
        ----------
        link_guid: Union[str, None, Unset_Type]
            The link_guid of this GrantaServerApiDataExportExportFailuresLinkReference.
        """
        self._link_guid = link_guid

    @property
    def link_type(self) -> "GrantaServerApiLinkAttributeType":
        """Gets the link_type of this GrantaServerApiDataExportExportFailuresLinkReference.

        Returns
        -------
        GrantaServerApiLinkAttributeType
            The link_type of this GrantaServerApiDataExportExportFailuresLinkReference.
        """
        return self._link_type

    @link_type.setter
    def link_type(self, link_type: "GrantaServerApiLinkAttributeType") -> None:
        """Sets the link_type of this GrantaServerApiDataExportExportFailuresLinkReference.

        Parameters
        ----------
        link_type: GrantaServerApiLinkAttributeType
            The link_type of this GrantaServerApiDataExportExportFailuresLinkReference.
        """
        # Field is not nullable
        if link_type is None:
            raise ValueError("Invalid value for 'link_type', must not be 'None'")
        # Field is required
        if link_type is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'link_type', must not be 'Unset'")
        self._link_type = link_type

    @classmethod
    def get_real_child_model(cls, data: Dict[str, str]) -> str:
        """Raises a NotImplementedError for a type without a discriminator defined.

        Parameters
        ----------
        data: ModelBase
            Object representing a subclass of this class

        Raises
        ------
        NotImplementedError
            This class has no discriminator, and hence no subclasses
        """
        raise NotImplementedError()

    def __repr__(self) -> str:
        """For 'print' and 'pprint'"""
        return self.to_str()

    def __eq__(self, other: Any) -> bool:
        """Returns true if both objects are equal"""
        if not isinstance(other, GrantaServerApiDataExportExportFailuresLinkReference):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other: Any) -> bool:
        """Returns true if both objects are not equal"""
        return not self == other
