# Copyright (C) 2023 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""
    MI Server API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: v1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import re  # noqa: F401
from typing import TYPE_CHECKING, Any, BinaryIO, Dict, List, Optional, Union  # noqa: F401

from . import ModelBase, Unset, Unset_Type

if TYPE_CHECKING:
    from datetime import datetime
    import pathlib

    from . import *


class GrantaServerApiDataExportRecordWithData(ModelBase):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes
    ----------
    swagger_types: Dict[str, str]
        The key is attribute name and the value is attribute type.
    attribute_map: Dict[str, str]
        The key is attribute name and the value is json key in definition.
    subtype_mapping: Dict[str, str]
        The key is the unmangled property name and the value is the corresponding type.
    discriminator: Optional[str]
        Name of the property used as discriminator for subtypes.
    """
    swagger_types: Dict[str, str] = {
        "data": "list[GrantaServerApiDataExportDatumsDatum]",
        "database_key": "str",
        "properties": "list[GrantaServerApiDataExportPropertiesProperty]",
        "record_history_identity": "int",
    }

    attribute_map: Dict[str, str] = {
        "data": "data",
        "database_key": "databaseKey",
        "properties": "properties",
        "record_history_identity": "recordHistoryIdentity",
    }

    subtype_mapping: Dict[str, str] = {
        "data": "GrantaServerApiDataExportDatumsDatum",
        "properties": "GrantaServerApiDataExportPropertiesProperty",
    }

    discriminator: Optional[str] = None

    def __init__(
        self,
        *,
        data: "Union[List[GrantaServerApiDataExportDatumsDatum], None, Unset_Type]" = Unset,
        database_key: "Union[str, None, Unset_Type]" = Unset,
        properties: "Union[List[GrantaServerApiDataExportPropertiesProperty], None, Unset_Type]" = Unset,
        record_history_identity: "Union[int, Unset_Type]" = Unset,
    ) -> None:
        """GrantaServerApiDataExportRecordWithData - a model defined in Swagger

        Parameters
        ----------
        data: List[GrantaServerApiDataExportDatumsDatum], optional
        database_key: str, optional
        properties: List[GrantaServerApiDataExportPropertiesProperty], optional
        record_history_identity: int, optional
        """
        self._database_key: Union[str, None, Unset_Type] = Unset
        self._record_history_identity: Union[int, Unset_Type] = Unset
        self._data: Union[List[GrantaServerApiDataExportDatumsDatum], None, Unset_Type] = Unset
        self._properties: Union[
            List[GrantaServerApiDataExportPropertiesProperty], None, Unset_Type
        ] = Unset

        if database_key is not Unset:
            self.database_key = database_key
        if record_history_identity is not Unset:
            self.record_history_identity = record_history_identity
        if data is not Unset:
            self.data = data
        if properties is not Unset:
            self.properties = properties

    @property
    def database_key(self) -> "Union[str, None, Unset_Type]":
        """Gets the database_key of this GrantaServerApiDataExportRecordWithData.

        Returns
        -------
        Union[str, None, Unset_Type]
            The database_key of this GrantaServerApiDataExportRecordWithData.
        """
        return self._database_key

    @database_key.setter
    def database_key(self, database_key: "Union[str, None, Unset_Type]") -> None:
        """Sets the database_key of this GrantaServerApiDataExportRecordWithData.

        Parameters
        ----------
        database_key: Union[str, None, Unset_Type]
            The database_key of this GrantaServerApiDataExportRecordWithData.
        """
        self._database_key = database_key

    @property
    def record_history_identity(self) -> "Union[int, Unset_Type]":
        """Gets the record_history_identity of this GrantaServerApiDataExportRecordWithData.

        Returns
        -------
        Union[int, Unset_Type]
            The record_history_identity of this GrantaServerApiDataExportRecordWithData.
        """
        return self._record_history_identity

    @record_history_identity.setter
    def record_history_identity(self, record_history_identity: "Union[int, Unset_Type]") -> None:
        """Sets the record_history_identity of this GrantaServerApiDataExportRecordWithData.

        Parameters
        ----------
        record_history_identity: Union[int, Unset_Type]
            The record_history_identity of this GrantaServerApiDataExportRecordWithData.
        """
        # Field is not nullable
        if record_history_identity is None:
            raise ValueError("Invalid value for 'record_history_identity', must not be 'None'")
        self._record_history_identity = record_history_identity

    @property
    def data(self) -> "Union[List[GrantaServerApiDataExportDatumsDatum], None, Unset_Type]":
        """Gets the data of this GrantaServerApiDataExportRecordWithData.

        Returns
        -------
        Union[List[GrantaServerApiDataExportDatumsDatum], None, Unset_Type]
            The data of this GrantaServerApiDataExportRecordWithData.
        """
        return self._data

    @data.setter
    def data(
        self, data: "Union[List[GrantaServerApiDataExportDatumsDatum], None, Unset_Type]"
    ) -> None:
        """Sets the data of this GrantaServerApiDataExportRecordWithData.

        Parameters
        ----------
        data: Union[List[GrantaServerApiDataExportDatumsDatum], None, Unset_Type]
            The data of this GrantaServerApiDataExportRecordWithData.
        """
        self._data = data

    @property
    def properties(
        self,
    ) -> "Union[List[GrantaServerApiDataExportPropertiesProperty], None, Unset_Type]":
        """Gets the properties of this GrantaServerApiDataExportRecordWithData.

        Returns
        -------
        Union[List[GrantaServerApiDataExportPropertiesProperty], None, Unset_Type]
            The properties of this GrantaServerApiDataExportRecordWithData.
        """
        return self._properties

    @properties.setter
    def properties(
        self,
        properties: "Union[List[GrantaServerApiDataExportPropertiesProperty], None, Unset_Type]",
    ) -> None:
        """Sets the properties of this GrantaServerApiDataExportRecordWithData.

        Parameters
        ----------
        properties: Union[List[GrantaServerApiDataExportPropertiesProperty], None, Unset_Type]
            The properties of this GrantaServerApiDataExportRecordWithData.
        """
        self._properties = properties

    @classmethod
    def get_real_child_model(cls, data: Dict[str, str]) -> str:
        """Raises a NotImplementedError for a type without a discriminator defined.

        Parameters
        ----------
        data: ModelBase
            Object representing a subclass of this class

        Raises
        ------
        NotImplementedError
            This class has no discriminator, and hence no subclasses
        """
        raise NotImplementedError()

    def __repr__(self) -> str:
        """For 'print' and 'pprint'"""
        return self.to_str()

    def __eq__(self, other: Any) -> bool:
        """Returns true if both objects are equal"""
        if not isinstance(other, GrantaServerApiDataExportRecordWithData):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other: Any) -> bool:
        """Returns true if both objects are not equal"""
        return not self == other
