# Copyright (C) 2023 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""
    MI Server API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: v1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import re  # noqa: F401
from typing import TYPE_CHECKING, Any, BinaryIO, Dict, List, Optional, Union  # noqa: F401

from ansys.grantami.serverapi_openapi.models.granta_server_api_data_applicable_datum import (  # noqa: F401
    GrantaServerApiDataApplicableDatum,
)

from . import ModelBase, Unset, Unset_Type

if TYPE_CHECKING:
    from datetime import datetime
    import pathlib

    from . import *


class GrantaServerApiDataFileDatum(GrantaServerApiDataApplicableDatum):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes
    ----------
    swagger_types: Dict[str, str]
        The key is attribute name and the value is attribute type.
    attribute_map: Dict[str, str]
        The key is attribute name and the value is json key in definition.
    subtype_mapping: Dict[str, str]
        The key is the unmangled property name and the value is the corresponding type.
    discriminator: Optional[str]
        Name of the property used as discriminator for subtypes.
    """
    swagger_types: Dict[str, str] = {
        "content_is_in_search_index": "bool",
        "content_type": "str",
        "description": "str",
        "file_name": "str",
        "target": "str",
        "datum_type": "str",
        "not_applicable": "str",
    }

    attribute_map: Dict[str, str] = {
        "content_is_in_search_index": "contentIsInSearchIndex",
        "content_type": "contentType",
        "description": "description",
        "file_name": "fileName",
        "target": "target",
        "datum_type": "datumType",
        "not_applicable": "notApplicable",
    }

    subtype_mapping: Dict[str, str] = {}

    discriminator: Optional[str] = None

    def __init__(
        self,
        *,
        content_is_in_search_index: "bool",
        content_type: "str",
        description: "str",
        file_name: "str",
        target: "str",
        datum_type: "str" = "file",
        not_applicable: "str" = "applicable",
    ) -> None:
        """GrantaServerApiDataFileDatum - a model defined in Swagger

        Parameters
        ----------
        content_is_in_search_index: bool
        content_type: str
        description: str
        file_name: str
        target: str
        datum_type: str
        not_applicable: str
        """
        super().__init__(not_applicable=not_applicable)
        self._datum_type: str
        self._file_name: str
        self._description: str
        self._content_type: str
        self._target: str
        self._content_is_in_search_index: bool

        self.datum_type = datum_type
        self.file_name = file_name
        self.description = description
        self.content_type = content_type
        self.target = target
        self.content_is_in_search_index = content_is_in_search_index

    @property
    def datum_type(self) -> "str":
        """Gets the datum_type of this GrantaServerApiDataFileDatum.

        Returns
        -------
        str
            The datum_type of this GrantaServerApiDataFileDatum.
        """
        return self._datum_type

    @datum_type.setter
    def datum_type(self, datum_type: "str") -> None:
        """Sets the datum_type of this GrantaServerApiDataFileDatum.

        Parameters
        ----------
        datum_type: str
            The datum_type of this GrantaServerApiDataFileDatum.
        """
        # Field is not nullable
        if datum_type is None:
            raise ValueError("Invalid value for 'datum_type', must not be 'None'")
        # Field is required
        if datum_type is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'datum_type', must not be 'Unset'")
        self._datum_type = datum_type

    @property
    def file_name(self) -> "str":
        """Gets the file_name of this GrantaServerApiDataFileDatum.

        Returns
        -------
        str
            The file_name of this GrantaServerApiDataFileDatum.
        """
        return self._file_name

    @file_name.setter
    def file_name(self, file_name: "str") -> None:
        """Sets the file_name of this GrantaServerApiDataFileDatum.

        Parameters
        ----------
        file_name: str
            The file_name of this GrantaServerApiDataFileDatum.
        """
        # Field is not nullable
        if file_name is None:
            raise ValueError("Invalid value for 'file_name', must not be 'None'")
        # Field is required
        if file_name is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'file_name', must not be 'Unset'")
        self._file_name = file_name

    @property
    def description(self) -> "str":
        """Gets the description of this GrantaServerApiDataFileDatum.

        Returns
        -------
        str
            The description of this GrantaServerApiDataFileDatum.
        """
        return self._description

    @description.setter
    def description(self, description: "str") -> None:
        """Sets the description of this GrantaServerApiDataFileDatum.

        Parameters
        ----------
        description: str
            The description of this GrantaServerApiDataFileDatum.
        """
        # Field is not nullable
        if description is None:
            raise ValueError("Invalid value for 'description', must not be 'None'")
        # Field is required
        if description is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'description', must not be 'Unset'")
        self._description = description

    @property
    def content_type(self) -> "str":
        """Gets the content_type of this GrantaServerApiDataFileDatum.

        Returns
        -------
        str
            The content_type of this GrantaServerApiDataFileDatum.
        """
        return self._content_type

    @content_type.setter
    def content_type(self, content_type: "str") -> None:
        """Sets the content_type of this GrantaServerApiDataFileDatum.

        Parameters
        ----------
        content_type: str
            The content_type of this GrantaServerApiDataFileDatum.
        """
        # Field is not nullable
        if content_type is None:
            raise ValueError("Invalid value for 'content_type', must not be 'None'")
        # Field is required
        if content_type is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'content_type', must not be 'Unset'")
        self._content_type = content_type

    @property
    def target(self) -> "str":
        """Gets the target of this GrantaServerApiDataFileDatum.

        Returns
        -------
        str
            The target of this GrantaServerApiDataFileDatum.
        """
        return self._target

    @target.setter
    def target(self, target: "str") -> None:
        """Sets the target of this GrantaServerApiDataFileDatum.

        Parameters
        ----------
        target: str
            The target of this GrantaServerApiDataFileDatum.
        """
        # Field is not nullable
        if target is None:
            raise ValueError("Invalid value for 'target', must not be 'None'")
        # Field is required
        if target is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'target', must not be 'Unset'")
        self._target = target

    @property
    def content_is_in_search_index(self) -> "bool":
        """Gets the content_is_in_search_index of this GrantaServerApiDataFileDatum.

        Returns
        -------
        bool
            The content_is_in_search_index of this GrantaServerApiDataFileDatum.
        """
        return self._content_is_in_search_index

    @content_is_in_search_index.setter
    def content_is_in_search_index(self, content_is_in_search_index: "bool") -> None:
        """Sets the content_is_in_search_index of this GrantaServerApiDataFileDatum.

        Parameters
        ----------
        content_is_in_search_index: bool
            The content_is_in_search_index of this GrantaServerApiDataFileDatum.
        """
        # Field is not nullable
        if content_is_in_search_index is None:
            raise ValueError("Invalid value for 'content_is_in_search_index', must not be 'None'")
        # Field is required
        if content_is_in_search_index is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'content_is_in_search_index', must not be 'Unset'")
        self._content_is_in_search_index = content_is_in_search_index

    @classmethod
    def get_real_child_model(cls, data: Dict[str, str]) -> str:
        """Raises a NotImplementedError for a type without a discriminator defined.

        Parameters
        ----------
        data: ModelBase
            Object representing a subclass of this class

        Raises
        ------
        NotImplementedError
            This class has no discriminator, and hence no subclasses
        """
        raise NotImplementedError()

    def __repr__(self) -> str:
        """For 'print' and 'pprint'"""
        return self.to_str()

    def __eq__(self, other: Any) -> bool:
        """Returns true if both objects are equal"""
        if not isinstance(other, GrantaServerApiDataFileDatum):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other: Any) -> bool:
        """Returns true if both objects are not equal"""
        return not self == other
