# Copyright (C) 2023 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""
    MI Server API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: v1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import re  # noqa: F401
from typing import TYPE_CHECKING, Any, BinaryIO, Dict, List, Optional, Union  # noqa: F401

from . import ModelBase, Unset, Unset_Type

if TYPE_CHECKING:
    from datetime import datetime
    import pathlib

    from . import *


class GrantaServerApiDataPointDataValue(ModelBase):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes
    ----------
    swagger_types: Dict[str, str]
        The key is attribute name and the value is attribute type.
    attribute_map: Dict[str, str]
        The key is attribute name and the value is json key in definition.
    subtype_mapping: Dict[str, str]
        The key is the unmangled property name and the value is the corresponding type.
    discriminator: Optional[str]
        Name of the property used as discriminator for subtypes.
    """
    swagger_types: Dict[str, str] = {
        "parameter_and_values": "list[GrantaServerApiDataParameterWithValue]",
        "point_value": "float",
        "significant_figures_info": "GrantaServerApiDataSignificantFiguresInfo",
        "unit": "GrantaServerApiSchemaSlimEntitiesSlimUnit",
    }

    attribute_map: Dict[str, str] = {
        "parameter_and_values": "parameterAndValues",
        "point_value": "pointValue",
        "significant_figures_info": "significantFiguresInfo",
        "unit": "unit",
    }

    subtype_mapping: Dict[str, str] = {
        "unit": "GrantaServerApiSchemaSlimEntitiesSlimUnit",
        "significantFiguresInfo": "GrantaServerApiDataSignificantFiguresInfo",
        "parameterAndValues": "GrantaServerApiDataParameterWithValue",
    }

    discriminator: Optional[str] = None

    def __init__(
        self,
        *,
        parameter_and_values: "List[GrantaServerApiDataParameterWithValue]",
        point_value: "float",
        significant_figures_info: "Union[GrantaServerApiDataSignificantFiguresInfo, Unset_Type]" = Unset,
        unit: "Union[GrantaServerApiSchemaSlimEntitiesSlimUnit, Unset_Type]" = Unset,
    ) -> None:
        """GrantaServerApiDataPointDataValue - a model defined in Swagger

        Parameters
        ----------
        parameter_and_values: List[GrantaServerApiDataParameterWithValue]
        point_value: float
        significant_figures_info: GrantaServerApiDataSignificantFiguresInfo, optional
        unit: GrantaServerApiSchemaSlimEntitiesSlimUnit, optional
        """
        self._point_value: float
        self._unit: Union[GrantaServerApiSchemaSlimEntitiesSlimUnit, Unset_Type] = Unset
        self._significant_figures_info: Union[
            GrantaServerApiDataSignificantFiguresInfo, Unset_Type
        ] = Unset
        self._parameter_and_values: List[GrantaServerApiDataParameterWithValue]

        self.point_value = point_value
        if unit is not Unset:
            self.unit = unit
        if significant_figures_info is not Unset:
            self.significant_figures_info = significant_figures_info
        self.parameter_and_values = parameter_and_values

    @property
    def point_value(self) -> "float":
        """Gets the point_value of this GrantaServerApiDataPointDataValue.

        Returns
        -------
        float
            The point_value of this GrantaServerApiDataPointDataValue.
        """
        return self._point_value

    @point_value.setter
    def point_value(self, point_value: "float") -> None:
        """Sets the point_value of this GrantaServerApiDataPointDataValue.

        Parameters
        ----------
        point_value: float
            The point_value of this GrantaServerApiDataPointDataValue.
        """
        # Field is not nullable
        if point_value is None:
            raise ValueError("Invalid value for 'point_value', must not be 'None'")
        # Field is required
        if point_value is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'point_value', must not be 'Unset'")
        self._point_value = point_value

    @property
    def unit(self) -> "Union[GrantaServerApiSchemaSlimEntitiesSlimUnit, Unset_Type]":
        """Gets the unit of this GrantaServerApiDataPointDataValue.

        Returns
        -------
        Union[GrantaServerApiSchemaSlimEntitiesSlimUnit, Unset_Type]
            The unit of this GrantaServerApiDataPointDataValue.
        """
        return self._unit

    @unit.setter
    def unit(self, unit: "Union[GrantaServerApiSchemaSlimEntitiesSlimUnit, Unset_Type]") -> None:
        """Sets the unit of this GrantaServerApiDataPointDataValue.

        Parameters
        ----------
        unit: Union[GrantaServerApiSchemaSlimEntitiesSlimUnit, Unset_Type]
            The unit of this GrantaServerApiDataPointDataValue.
        """
        # Field is not nullable
        if unit is None:
            raise ValueError("Invalid value for 'unit', must not be 'None'")
        self._unit = unit

    @property
    def significant_figures_info(
        self,
    ) -> "Union[GrantaServerApiDataSignificantFiguresInfo, Unset_Type]":
        """Gets the significant_figures_info of this GrantaServerApiDataPointDataValue.

        Returns
        -------
        Union[GrantaServerApiDataSignificantFiguresInfo, Unset_Type]
            The significant_figures_info of this GrantaServerApiDataPointDataValue.
        """
        return self._significant_figures_info

    @significant_figures_info.setter
    def significant_figures_info(
        self,
        significant_figures_info: "Union[GrantaServerApiDataSignificantFiguresInfo, Unset_Type]",
    ) -> None:
        """Sets the significant_figures_info of this GrantaServerApiDataPointDataValue.

        Parameters
        ----------
        significant_figures_info: Union[GrantaServerApiDataSignificantFiguresInfo, Unset_Type]
            The significant_figures_info of this GrantaServerApiDataPointDataValue.
        """
        # Field is not nullable
        if significant_figures_info is None:
            raise ValueError("Invalid value for 'significant_figures_info', must not be 'None'")
        self._significant_figures_info = significant_figures_info

    @property
    def parameter_and_values(self) -> "List[GrantaServerApiDataParameterWithValue]":
        """Gets the parameter_and_values of this GrantaServerApiDataPointDataValue.

        Returns
        -------
        List[GrantaServerApiDataParameterWithValue]
            The parameter_and_values of this GrantaServerApiDataPointDataValue.
        """
        return self._parameter_and_values

    @parameter_and_values.setter
    def parameter_and_values(
        self, parameter_and_values: "List[GrantaServerApiDataParameterWithValue]"
    ) -> None:
        """Sets the parameter_and_values of this GrantaServerApiDataPointDataValue.

        Parameters
        ----------
        parameter_and_values: List[GrantaServerApiDataParameterWithValue]
            The parameter_and_values of this GrantaServerApiDataPointDataValue.
        """
        # Field is not nullable
        if parameter_and_values is None:
            raise ValueError("Invalid value for 'parameter_and_values', must not be 'None'")
        # Field is required
        if parameter_and_values is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'parameter_and_values', must not be 'Unset'")
        self._parameter_and_values = parameter_and_values

    @classmethod
    def get_real_child_model(cls, data: Dict[str, str]) -> str:
        """Raises a NotImplementedError for a type without a discriminator defined.

        Parameters
        ----------
        data: ModelBase
            Object representing a subclass of this class

        Raises
        ------
        NotImplementedError
            This class has no discriminator, and hence no subclasses
        """
        raise NotImplementedError()

    def __repr__(self) -> str:
        """For 'print' and 'pprint'"""
        return self.to_str()

    def __eq__(self, other: Any) -> bool:
        """Returns true if both objects are equal"""
        if not isinstance(other, GrantaServerApiDataPointDataValue):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other: Any) -> bool:
        """Returns true if both objects are not equal"""
        return not self == other
