# Copyright (C) 2023 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""
    MI Server API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: v1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import re  # noqa: F401
from typing import TYPE_CHECKING, Any, BinaryIO, Dict, List, Optional, Union  # noqa: F401

from . import ModelBase, Unset, Unset_Type

if TYPE_CHECKING:
    from datetime import datetime
    import pathlib

    from . import *


class GrantaServerApiDatabaseStatusInformation(ModelBase):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes
    ----------
    swagger_types: Dict[str, str]
        The key is attribute name and the value is attribute type.
    attribute_map: Dict[str, str]
        The key is attribute name and the value is json key in definition.
    subtype_mapping: Dict[str, str]
        The key is the unmangled property name and the value is the corresponding type.
    discriminator: Optional[str]
        Name of the property used as discriminator for subtypes.
    """
    swagger_types: Dict[str, str] = {
        "database_is_read_only": "bool",
        "database_key": "str",
        "is_locked": "bool",
        "schema_version": "str",
        "search_index_in_sync": "bool",
        "state": "GrantaServerApiDatabaseStatus",
    }

    attribute_map: Dict[str, str] = {
        "database_is_read_only": "databaseIsReadOnly",
        "database_key": "databaseKey",
        "is_locked": "isLocked",
        "schema_version": "schemaVersion",
        "search_index_in_sync": "searchIndexInSync",
        "state": "state",
    }

    subtype_mapping: Dict[str, str] = {
        "state": "GrantaServerApiDatabaseStatus",
    }

    discriminator: Optional[str] = None

    def __init__(
        self,
        *,
        database_is_read_only: "Union[bool, Unset_Type]" = Unset,
        database_key: "Union[str, None, Unset_Type]" = Unset,
        is_locked: "Union[bool, Unset_Type]" = Unset,
        schema_version: "Union[str, None, Unset_Type]" = Unset,
        search_index_in_sync: "Union[bool, Unset_Type]" = Unset,
        state: "Union[GrantaServerApiDatabaseStatus, Unset_Type]" = Unset,
    ) -> None:
        """GrantaServerApiDatabaseStatusInformation - a model defined in Swagger

        Parameters
        ----------
        database_is_read_only: bool, optional
        database_key: str, optional
        is_locked: bool, optional
        schema_version: str, optional
        search_index_in_sync: bool, optional
        state: GrantaServerApiDatabaseStatus, optional
        """
        self._database_key: Union[str, None, Unset_Type] = Unset
        self._database_is_read_only: Union[bool, Unset_Type] = Unset
        self._is_locked: Union[bool, Unset_Type] = Unset
        self._state: Union[GrantaServerApiDatabaseStatus, Unset_Type] = Unset
        self._schema_version: Union[str, None, Unset_Type] = Unset
        self._search_index_in_sync: Union[bool, Unset_Type] = Unset

        if database_key is not Unset:
            self.database_key = database_key
        if database_is_read_only is not Unset:
            self.database_is_read_only = database_is_read_only
        if is_locked is not Unset:
            self.is_locked = is_locked
        if state is not Unset:
            self.state = state
        if schema_version is not Unset:
            self.schema_version = schema_version
        if search_index_in_sync is not Unset:
            self.search_index_in_sync = search_index_in_sync

    @property
    def database_key(self) -> "Union[str, None, Unset_Type]":
        """Gets the database_key of this GrantaServerApiDatabaseStatusInformation.
        Gets the database key for this database.

        Returns
        -------
        Union[str, None, Unset_Type]
            The database_key of this GrantaServerApiDatabaseStatusInformation.
        """
        return self._database_key

    @database_key.setter
    def database_key(self, database_key: "Union[str, None, Unset_Type]") -> None:
        """Sets the database_key of this GrantaServerApiDatabaseStatusInformation.
        Gets the database key for this database.

        Parameters
        ----------
        database_key: Union[str, None, Unset_Type]
            The database_key of this GrantaServerApiDatabaseStatusInformation.
        """
        self._database_key = database_key

    @property
    def database_is_read_only(self) -> "Union[bool, Unset_Type]":
        """Gets the database_is_read_only of this GrantaServerApiDatabaseStatusInformation.
        Gets a value indicating whether the database is read only.

        Returns
        -------
        Union[bool, Unset_Type]
            The database_is_read_only of this GrantaServerApiDatabaseStatusInformation.
        """
        return self._database_is_read_only

    @database_is_read_only.setter
    def database_is_read_only(self, database_is_read_only: "Union[bool, Unset_Type]") -> None:
        """Sets the database_is_read_only of this GrantaServerApiDatabaseStatusInformation.
        Gets a value indicating whether the database is read only.

        Parameters
        ----------
        database_is_read_only: Union[bool, Unset_Type]
            The database_is_read_only of this GrantaServerApiDatabaseStatusInformation.
        """
        # Field is not nullable
        if database_is_read_only is None:
            raise ValueError("Invalid value for 'database_is_read_only', must not be 'None'")
        self._database_is_read_only = database_is_read_only

    @property
    def is_locked(self) -> "Union[bool, Unset_Type]":
        """Gets the is_locked of this GrantaServerApiDatabaseStatusInformation.
        Gets a value indicating whether the database is locked for non-admin users.

        Returns
        -------
        Union[bool, Unset_Type]
            The is_locked of this GrantaServerApiDatabaseStatusInformation.
        """
        return self._is_locked

    @is_locked.setter
    def is_locked(self, is_locked: "Union[bool, Unset_Type]") -> None:
        """Sets the is_locked of this GrantaServerApiDatabaseStatusInformation.
        Gets a value indicating whether the database is locked for non-admin users.

        Parameters
        ----------
        is_locked: Union[bool, Unset_Type]
            The is_locked of this GrantaServerApiDatabaseStatusInformation.
        """
        # Field is not nullable
        if is_locked is None:
            raise ValueError("Invalid value for 'is_locked', must not be 'None'")
        self._is_locked = is_locked

    @property
    def state(self) -> "Union[GrantaServerApiDatabaseStatus, Unset_Type]":
        """Gets the state of this GrantaServerApiDatabaseStatusInformation.

        Returns
        -------
        Union[GrantaServerApiDatabaseStatus, Unset_Type]
            The state of this GrantaServerApiDatabaseStatusInformation.
        """
        return self._state

    @state.setter
    def state(self, state: "Union[GrantaServerApiDatabaseStatus, Unset_Type]") -> None:
        """Sets the state of this GrantaServerApiDatabaseStatusInformation.

        Parameters
        ----------
        state: Union[GrantaServerApiDatabaseStatus, Unset_Type]
            The state of this GrantaServerApiDatabaseStatusInformation.
        """
        # Field is not nullable
        if state is None:
            raise ValueError("Invalid value for 'state', must not be 'None'")
        self._state = state

    @property
    def schema_version(self) -> "Union[str, None, Unset_Type]":
        """Gets the schema_version of this GrantaServerApiDatabaseStatusInformation.
        Gets the schema version of the database.

        Returns
        -------
        Union[str, None, Unset_Type]
            The schema_version of this GrantaServerApiDatabaseStatusInformation.
        """
        return self._schema_version

    @schema_version.setter
    def schema_version(self, schema_version: "Union[str, None, Unset_Type]") -> None:
        """Sets the schema_version of this GrantaServerApiDatabaseStatusInformation.
        Gets the schema version of the database.

        Parameters
        ----------
        schema_version: Union[str, None, Unset_Type]
            The schema_version of this GrantaServerApiDatabaseStatusInformation.
        """
        self._schema_version = schema_version

    @property
    def search_index_in_sync(self) -> "Union[bool, Unset_Type]":
        """Gets the search_index_in_sync of this GrantaServerApiDatabaseStatusInformation.
        Whether the search indexes for this database are in sync with the database changes

        Returns
        -------
        Union[bool, Unset_Type]
            The search_index_in_sync of this GrantaServerApiDatabaseStatusInformation.
        """
        return self._search_index_in_sync

    @search_index_in_sync.setter
    def search_index_in_sync(self, search_index_in_sync: "Union[bool, Unset_Type]") -> None:
        """Sets the search_index_in_sync of this GrantaServerApiDatabaseStatusInformation.
        Whether the search indexes for this database are in sync with the database changes

        Parameters
        ----------
        search_index_in_sync: Union[bool, Unset_Type]
            The search_index_in_sync of this GrantaServerApiDatabaseStatusInformation.
        """
        # Field is not nullable
        if search_index_in_sync is None:
            raise ValueError("Invalid value for 'search_index_in_sync', must not be 'None'")
        self._search_index_in_sync = search_index_in_sync

    @classmethod
    def get_real_child_model(cls, data: Dict[str, str]) -> str:
        """Raises a NotImplementedError for a type without a discriminator defined.

        Parameters
        ----------
        data: ModelBase
            Object representing a subclass of this class

        Raises
        ------
        NotImplementedError
            This class has no discriminator, and hence no subclasses
        """
        raise NotImplementedError()

    def __repr__(self) -> str:
        """For 'print' and 'pprint'"""
        return self.to_str()

    def __eq__(self, other: Any) -> bool:
        """Returns true if both objects are equal"""
        if not isinstance(other, GrantaServerApiDatabaseStatusInformation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other: Any) -> bool:
        """Returns true if both objects are not equal"""
        return not self == other
