# Copyright (C) 2023 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""
    MI Server API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: v1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import re  # noqa: F401
from typing import TYPE_CHECKING, Any, BinaryIO, Dict, List, Optional, Union  # noqa: F401

from . import ModelBase, Unset, Unset_Type

if TYPE_CHECKING:
    from datetime import datetime
    import pathlib

    from . import *


class GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier(
    ModelBase
):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes
    ----------
    swagger_types: Dict[str, str]
        The key is attribute name and the value is attribute type.
    attribute_map: Dict[str, str]
        The key is attribute name and the value is json key in definition.
    subtype_mapping: Dict[str, str]
        The key is the unmangled property name and the value is the corresponding type.
    discriminator: Optional[str]
        Name of the property used as discriminator for subtypes.
    """
    swagger_types: Dict[str, str] = {
        "access_control_category_values": "dict(str, list[str])",
        "attributes": "list[GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyAttribute]",
        "discrete_types": "list[GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyDiscreteType]",
        "key": "str",
        "layouts": "list[GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyLayout]",
        "security_groups": "GrantaServerApiIntegrationSchemaSecurityGroups",
        "sources": "list[GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlySourceOfGrantaServerApiObjectIdentifier]",
        "unit_system": "str",
        "version": "int",
    }

    attribute_map: Dict[str, str] = {
        "access_control_category_values": "accessControlCategoryValues",
        "attributes": "attributes",
        "discrete_types": "discreteTypes",
        "key": "key",
        "layouts": "layouts",
        "security_groups": "securityGroups",
        "sources": "sources",
        "unit_system": "unitSystem",
        "version": "version",
    }

    subtype_mapping: Dict[str, str] = {
        "attributes": "GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyAttribute",
        "layouts": "GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyLayout",
        "discreteTypes": "GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyDiscreteType",
        "sources": "GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlySourceOfGrantaServerApiObjectIdentifier",
        "securityGroups": "GrantaServerApiIntegrationSchemaSecurityGroups",
    }

    discriminator: Optional[str] = None

    def __init__(
        self,
        *,
        access_control_category_values: "Union[Dict[str, List[str]], None, Unset_Type]" = Unset,
        attributes: "Union[List[GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyAttribute], None, Unset_Type]" = Unset,
        discrete_types: "Union[List[GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyDiscreteType], None, Unset_Type]" = Unset,
        key: "Union[str, None, Unset_Type]" = Unset,
        layouts: "Union[List[GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyLayout], None, Unset_Type]" = Unset,
        security_groups: "Union[GrantaServerApiIntegrationSchemaSecurityGroups, Unset_Type]" = Unset,
        sources: "Union[List[GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlySourceOfGrantaServerApiObjectIdentifier], None, Unset_Type]" = Unset,
        unit_system: "Union[str, None, Unset_Type]" = Unset,
        version: "Union[int, None, Unset_Type]" = Unset,
    ) -> None:
        """GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier - a model defined in Swagger

        Parameters
        ----------
        access_control_category_values: Dict[str, List[str]], optional
        attributes: List[GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyAttribute], optional
        discrete_types: List[GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyDiscreteType], optional
        key: str, optional
        layouts: List[GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyLayout], optional
        security_groups: GrantaServerApiIntegrationSchemaSecurityGroups, optional
        sources: List[GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlySourceOfGrantaServerApiObjectIdentifier], optional
        unit_system: str, optional
        version: int, optional
        """
        self._key: Union[str, None, Unset_Type] = Unset
        self._version: Union[int, None, Unset_Type] = Unset
        self._attributes: Union[
            List[GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyAttribute], None, Unset_Type
        ] = Unset
        self._layouts: Union[
            List[GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyLayout], None, Unset_Type
        ] = Unset
        self._unit_system: Union[str, None, Unset_Type] = Unset
        self._discrete_types: Union[
            List[GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyDiscreteType],
            None,
            Unset_Type,
        ] = Unset
        self._sources: Union[
            List[
                GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlySourceOfGrantaServerApiObjectIdentifier
            ],
            None,
            Unset_Type,
        ] = Unset
        self._access_control_category_values: Union[Dict[str, List[str]], None, Unset_Type] = Unset
        self._security_groups: Union[GrantaServerApiIntegrationSchemaSecurityGroups, Unset_Type] = (
            Unset
        )

        if key is not Unset:
            self.key = key
        if version is not Unset:
            self.version = version
        if attributes is not Unset:
            self.attributes = attributes
        if layouts is not Unset:
            self.layouts = layouts
        if unit_system is not Unset:
            self.unit_system = unit_system
        if discrete_types is not Unset:
            self.discrete_types = discrete_types
        if sources is not Unset:
            self.sources = sources
        if access_control_category_values is not Unset:
            self.access_control_category_values = access_control_category_values
        if security_groups is not Unset:
            self.security_groups = security_groups

    @property
    def key(self) -> "Union[str, None, Unset_Type]":
        """Gets the key of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.

        Returns
        -------
        Union[str, None, Unset_Type]
            The key of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.
        """
        return self._key

    @key.setter
    def key(self, key: "Union[str, None, Unset_Type]") -> None:
        """Sets the key of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.

        Parameters
        ----------
        key: Union[str, None, Unset_Type]
            The key of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.
        """
        self._key = key

    @property
    def version(self) -> "Union[int, None, Unset_Type]":
        """Gets the version of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.

        Returns
        -------
        Union[int, None, Unset_Type]
            The version of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.
        """
        return self._version

    @version.setter
    def version(self, version: "Union[int, None, Unset_Type]") -> None:
        """Sets the version of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.

        Parameters
        ----------
        version: Union[int, None, Unset_Type]
            The version of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.
        """
        self._version = version

    @property
    def attributes(
        self,
    ) -> "Union[List[GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyAttribute], None, Unset_Type]":
        """Gets the attributes of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.

        Returns
        -------
        Union[List[GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyAttribute], None, Unset_Type]
            The attributes of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.
        """
        return self._attributes

    @attributes.setter
    def attributes(
        self,
        attributes: "Union[List[GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyAttribute], None, Unset_Type]",
    ) -> None:
        """Sets the attributes of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.

        Parameters
        ----------
        attributes: Union[List[GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyAttribute], None, Unset_Type]
            The attributes of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.
        """
        self._attributes = attributes

    @property
    def layouts(
        self,
    ) -> "Union[List[GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyLayout], None, Unset_Type]":
        """Gets the layouts of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.

        Returns
        -------
        Union[List[GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyLayout], None, Unset_Type]
            The layouts of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.
        """
        return self._layouts

    @layouts.setter
    def layouts(
        self,
        layouts: "Union[List[GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyLayout], None, Unset_Type]",
    ) -> None:
        """Sets the layouts of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.

        Parameters
        ----------
        layouts: Union[List[GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyLayout], None, Unset_Type]
            The layouts of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.
        """
        self._layouts = layouts

    @property
    def unit_system(self) -> "Union[str, None, Unset_Type]":
        """Gets the unit_system of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.

        Returns
        -------
        Union[str, None, Unset_Type]
            The unit_system of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.
        """
        return self._unit_system

    @unit_system.setter
    def unit_system(self, unit_system: "Union[str, None, Unset_Type]") -> None:
        """Sets the unit_system of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.

        Parameters
        ----------
        unit_system: Union[str, None, Unset_Type]
            The unit_system of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.
        """
        self._unit_system = unit_system

    @property
    def discrete_types(
        self,
    ) -> "Union[List[GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyDiscreteType], None, Unset_Type]":
        """Gets the discrete_types of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.

        Returns
        -------
        Union[List[GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyDiscreteType], None, Unset_Type]
            The discrete_types of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.
        """
        return self._discrete_types

    @discrete_types.setter
    def discrete_types(
        self,
        discrete_types: "Union[List[GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyDiscreteType], None, Unset_Type]",
    ) -> None:
        """Sets the discrete_types of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.

        Parameters
        ----------
        discrete_types: Union[List[GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyDiscreteType], None, Unset_Type]
            The discrete_types of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.
        """
        self._discrete_types = discrete_types

    @property
    def sources(
        self,
    ) -> "Union[List[GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlySourceOfGrantaServerApiObjectIdentifier], None, Unset_Type]":
        """Gets the sources of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.

        Returns
        -------
        Union[List[GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlySourceOfGrantaServerApiObjectIdentifier], None, Unset_Type]
            The sources of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.
        """
        return self._sources

    @sources.setter
    def sources(
        self,
        sources: "Union[List[GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlySourceOfGrantaServerApiObjectIdentifier], None, Unset_Type]",
    ) -> None:
        """Sets the sources of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.

        Parameters
        ----------
        sources: Union[List[GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlySourceOfGrantaServerApiObjectIdentifier], None, Unset_Type]
            The sources of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.
        """
        self._sources = sources

    @property
    def access_control_category_values(self) -> "Union[Dict[str, List[str]], None, Unset_Type]":
        """Gets the access_control_category_values of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.

        Returns
        -------
        Union[Dict[str, List[str]], None, Unset_Type]
            The access_control_category_values of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.
        """
        return self._access_control_category_values

    @access_control_category_values.setter
    def access_control_category_values(
        self, access_control_category_values: "Union[Dict[str, List[str]], None, Unset_Type]"
    ) -> None:
        """Sets the access_control_category_values of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.

        Parameters
        ----------
        access_control_category_values: Union[Dict[str, List[str]], None, Unset_Type]
            The access_control_category_values of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.
        """
        self._access_control_category_values = access_control_category_values

    @property
    def security_groups(
        self,
    ) -> "Union[GrantaServerApiIntegrationSchemaSecurityGroups, Unset_Type]":
        """Gets the security_groups of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.

        Returns
        -------
        Union[GrantaServerApiIntegrationSchemaSecurityGroups, Unset_Type]
            The security_groups of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.
        """
        return self._security_groups

    @security_groups.setter
    def security_groups(
        self, security_groups: "Union[GrantaServerApiIntegrationSchemaSecurityGroups, Unset_Type]"
    ) -> None:
        """Sets the security_groups of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.

        Parameters
        ----------
        security_groups: Union[GrantaServerApiIntegrationSchemaSecurityGroups, Unset_Type]
            The security_groups of this GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier.
        """
        # Field is not nullable
        if security_groups is None:
            raise ValueError("Invalid value for 'security_groups', must not be 'None'")
        self._security_groups = security_groups

    @classmethod
    def get_real_child_model(cls, data: Dict[str, str]) -> str:
        """Raises a NotImplementedError for a type without a discriminator defined.

        Parameters
        ----------
        data: ModelBase
            Object representing a subclass of this class

        Raises
        ------
        NotImplementedError
            This class has no discriminator, and hence no subclasses
        """
        raise NotImplementedError()

    def __repr__(self) -> str:
        """For 'print' and 'pprint'"""
        return self.to_str()

    def __eq__(self, other: Any) -> bool:
        """Returns true if both objects are equal"""
        if not isinstance(
            other,
            GrantaServerApiIntegrationSchemaGuidOnlySchemaGuidOnlyIntegrationSchemaOfGrantaServerApiObjectIdentifier,
        ):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other: Any) -> bool:
        """Returns true if both objects are not equal"""
        return not self == other
