# Copyright (C) 2023 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""
    MI Server API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: v1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import re  # noqa: F401
from typing import TYPE_CHECKING, Any, BinaryIO, Dict, List, Optional, Union  # noqa: F401

from . import ModelBase, Unset, Unset_Type

if TYPE_CHECKING:
    from datetime import datetime
    import pathlib

    from . import *


class GrantaServerApiListsDtoRecordListSearchRequest(ModelBase):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes
    ----------
    swagger_types: Dict[str, str]
        The key is attribute name and the value is attribute type.
    attribute_map: Dict[str, str]
        The key is attribute name and the value is json key in definition.
    subtype_mapping: Dict[str, str]
        The key is the unmangled property name and the value is the corresponding type.
    discriminator: Optional[str]
        Name of the property used as discriminator for subtypes.
    """
    swagger_types: Dict[str, str] = {
        "search_criterion": "GrantaServerApiListsDtoListCriterion",
        "paging_options": "GrantaServerApiListsDtoPagingOptions",
        "response_options": "GrantaServerApiListsDtoResponseOptions",
    }

    attribute_map: Dict[str, str] = {
        "search_criterion": "searchCriterion",
        "paging_options": "pagingOptions",
        "response_options": "responseOptions",
    }

    subtype_mapping: Dict[str, str] = {
        "searchCriterion": "GrantaServerApiListsDtoListCriterion",
        "pagingOptions": "GrantaServerApiListsDtoPagingOptions",
        "responseOptions": "GrantaServerApiListsDtoResponseOptions",
    }

    discriminator: Optional[str] = None

    def __init__(
        self,
        *,
        search_criterion: "GrantaServerApiListsDtoListCriterion",
        paging_options: "Union[GrantaServerApiListsDtoPagingOptions, Unset_Type]" = Unset,
        response_options: "Union[GrantaServerApiListsDtoResponseOptions, Unset_Type]" = Unset,
    ) -> None:
        """GrantaServerApiListsDtoRecordListSearchRequest - a model defined in Swagger

        Parameters
        ----------
        search_criterion: GrantaServerApiListsDtoListCriterion
        paging_options: GrantaServerApiListsDtoPagingOptions, optional
        response_options: GrantaServerApiListsDtoResponseOptions, optional
        """
        self._search_criterion: GrantaServerApiListsDtoListCriterion
        self._paging_options: Union[GrantaServerApiListsDtoPagingOptions, Unset_Type] = Unset
        self._response_options: Union[GrantaServerApiListsDtoResponseOptions, Unset_Type] = Unset

        self.search_criterion = search_criterion
        if paging_options is not Unset:
            self.paging_options = paging_options
        if response_options is not Unset:
            self.response_options = response_options

    @property
    def search_criterion(self) -> "GrantaServerApiListsDtoListCriterion":
        """Gets the search_criterion of this GrantaServerApiListsDtoRecordListSearchRequest.

        Returns
        -------
        GrantaServerApiListsDtoListCriterion
            The search_criterion of this GrantaServerApiListsDtoRecordListSearchRequest.
        """
        return self._search_criterion

    @search_criterion.setter
    def search_criterion(self, search_criterion: "GrantaServerApiListsDtoListCriterion") -> None:
        """Sets the search_criterion of this GrantaServerApiListsDtoRecordListSearchRequest.

        Parameters
        ----------
        search_criterion: GrantaServerApiListsDtoListCriterion
            The search_criterion of this GrantaServerApiListsDtoRecordListSearchRequest.
        """
        # Field is not nullable
        if search_criterion is None:
            raise ValueError("Invalid value for 'search_criterion', must not be 'None'")
        # Field is required
        if search_criterion is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'search_criterion', must not be 'Unset'")
        self._search_criterion = search_criterion

    @property
    def paging_options(self) -> "Union[GrantaServerApiListsDtoPagingOptions, Unset_Type]":
        """Gets the paging_options of this GrantaServerApiListsDtoRecordListSearchRequest.

        Returns
        -------
        Union[GrantaServerApiListsDtoPagingOptions, Unset_Type]
            The paging_options of this GrantaServerApiListsDtoRecordListSearchRequest.
        """
        return self._paging_options

    @paging_options.setter
    def paging_options(
        self, paging_options: "Union[GrantaServerApiListsDtoPagingOptions, Unset_Type]"
    ) -> None:
        """Sets the paging_options of this GrantaServerApiListsDtoRecordListSearchRequest.

        Parameters
        ----------
        paging_options: Union[GrantaServerApiListsDtoPagingOptions, Unset_Type]
            The paging_options of this GrantaServerApiListsDtoRecordListSearchRequest.
        """
        # Field is not nullable
        if paging_options is None:
            raise ValueError("Invalid value for 'paging_options', must not be 'None'")
        self._paging_options = paging_options

    @property
    def response_options(self) -> "Union[GrantaServerApiListsDtoResponseOptions, Unset_Type]":
        """Gets the response_options of this GrantaServerApiListsDtoRecordListSearchRequest.

        Returns
        -------
        Union[GrantaServerApiListsDtoResponseOptions, Unset_Type]
            The response_options of this GrantaServerApiListsDtoRecordListSearchRequest.
        """
        return self._response_options

    @response_options.setter
    def response_options(
        self, response_options: "Union[GrantaServerApiListsDtoResponseOptions, Unset_Type]"
    ) -> None:
        """Sets the response_options of this GrantaServerApiListsDtoRecordListSearchRequest.

        Parameters
        ----------
        response_options: Union[GrantaServerApiListsDtoResponseOptions, Unset_Type]
            The response_options of this GrantaServerApiListsDtoRecordListSearchRequest.
        """
        # Field is not nullable
        if response_options is None:
            raise ValueError("Invalid value for 'response_options', must not be 'None'")
        self._response_options = response_options

    @classmethod
    def get_real_child_model(cls, data: Dict[str, str]) -> str:
        """Raises a NotImplementedError for a type without a discriminator defined.

        Parameters
        ----------
        data: ModelBase
            Object representing a subclass of this class

        Raises
        ------
        NotImplementedError
            This class has no discriminator, and hence no subclasses
        """
        raise NotImplementedError()

    def __repr__(self) -> str:
        """For 'print' and 'pprint'"""
        return self.to_str()

    def __eq__(self, other: Any) -> bool:
        """Returns true if both objects are equal"""
        if not isinstance(other, GrantaServerApiListsDtoRecordListSearchRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other: Any) -> bool:
        """Returns true if both objects are not equal"""
        return not self == other
