# Copyright (C) 2023 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""
    MI Server API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: v1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import re  # noqa: F401
from typing import TYPE_CHECKING, Any, BinaryIO, Dict, List, Optional, Union  # noqa: F401

from . import ModelBase, Unset, Unset_Type

if TYPE_CHECKING:
    from datetime import datetime
    import pathlib

    from . import *


class GrantaServerApiRecordsRecordHistoriesCopyRecordHistory(ModelBase):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes
    ----------
    swagger_types: Dict[str, str]
        The key is attribute name and the value is attribute type.
    attribute_map: Dict[str, str]
        The key is attribute name and the value is json key in definition.
    subtype_mapping: Dict[str, str]
        The key is the unmangled property name and the value is the corresponding type.
    discriminator: Optional[str]
        Name of the property used as discriminator for subtypes.
    """
    swagger_types: Dict[str, str] = {
        "subset_option": "GrantaServerApiRecordsRecordHistoriesRecordPropertyInheritanceType",
        "new_parent": "GrantaServerApiRecordsRecordHistoriesSlimRecordHistory",
        "new_short_name": "str",
    }

    attribute_map: Dict[str, str] = {
        "subset_option": "subsetOption",
        "new_parent": "newParent",
        "new_short_name": "newShortName",
    }

    subtype_mapping: Dict[str, str] = {
        "newParent": "GrantaServerApiRecordsRecordHistoriesSlimRecordHistory",
        "subsetOption": "GrantaServerApiRecordsRecordHistoriesRecordPropertyInheritanceType",
    }

    discriminator: Optional[str] = None

    def __init__(
        self,
        *,
        subset_option: "GrantaServerApiRecordsRecordHistoriesRecordPropertyInheritanceType",
        new_parent: "Union[GrantaServerApiRecordsRecordHistoriesSlimRecordHistory, Unset_Type]" = Unset,
        new_short_name: "Union[str, None, Unset_Type]" = Unset,
    ) -> None:
        """GrantaServerApiRecordsRecordHistoriesCopyRecordHistory - a model defined in Swagger

        Parameters
        ----------
        subset_option: GrantaServerApiRecordsRecordHistoriesRecordPropertyInheritanceType
        new_parent: GrantaServerApiRecordsRecordHistoriesSlimRecordHistory, optional
        new_short_name: str, optional
        """
        self._new_parent: Union[
            GrantaServerApiRecordsRecordHistoriesSlimRecordHistory, Unset_Type
        ] = Unset
        self._subset_option: GrantaServerApiRecordsRecordHistoriesRecordPropertyInheritanceType
        self._new_short_name: Union[str, None, Unset_Type] = Unset

        if new_parent is not Unset:
            self.new_parent = new_parent
        self.subset_option = subset_option
        if new_short_name is not Unset:
            self.new_short_name = new_short_name

    @property
    def new_parent(
        self,
    ) -> "Union[GrantaServerApiRecordsRecordHistoriesSlimRecordHistory, Unset_Type]":
        """Gets the new_parent of this GrantaServerApiRecordsRecordHistoriesCopyRecordHistory.

        Returns
        -------
        Union[GrantaServerApiRecordsRecordHistoriesSlimRecordHistory, Unset_Type]
            The new_parent of this GrantaServerApiRecordsRecordHistoriesCopyRecordHistory.
        """
        return self._new_parent

    @new_parent.setter
    def new_parent(
        self,
        new_parent: "Union[GrantaServerApiRecordsRecordHistoriesSlimRecordHistory, Unset_Type]",
    ) -> None:
        """Sets the new_parent of this GrantaServerApiRecordsRecordHistoriesCopyRecordHistory.

        Parameters
        ----------
        new_parent: Union[GrantaServerApiRecordsRecordHistoriesSlimRecordHistory, Unset_Type]
            The new_parent of this GrantaServerApiRecordsRecordHistoriesCopyRecordHistory.
        """
        # Field is not nullable
        if new_parent is None:
            raise ValueError("Invalid value for 'new_parent', must not be 'None'")
        self._new_parent = new_parent

    @property
    def subset_option(self) -> "GrantaServerApiRecordsRecordHistoriesRecordPropertyInheritanceType":
        """Gets the subset_option of this GrantaServerApiRecordsRecordHistoriesCopyRecordHistory.

        Returns
        -------
        GrantaServerApiRecordsRecordHistoriesRecordPropertyInheritanceType
            The subset_option of this GrantaServerApiRecordsRecordHistoriesCopyRecordHistory.
        """
        return self._subset_option

    @subset_option.setter
    def subset_option(
        self, subset_option: "GrantaServerApiRecordsRecordHistoriesRecordPropertyInheritanceType"
    ) -> None:
        """Sets the subset_option of this GrantaServerApiRecordsRecordHistoriesCopyRecordHistory.

        Parameters
        ----------
        subset_option: GrantaServerApiRecordsRecordHistoriesRecordPropertyInheritanceType
            The subset_option of this GrantaServerApiRecordsRecordHistoriesCopyRecordHistory.
        """
        # Field is not nullable
        if subset_option is None:
            raise ValueError("Invalid value for 'subset_option', must not be 'None'")
        # Field is required
        if subset_option is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'subset_option', must not be 'Unset'")
        self._subset_option = subset_option

    @property
    def new_short_name(self) -> "Union[str, None, Unset_Type]":
        """Gets the new_short_name of this GrantaServerApiRecordsRecordHistoriesCopyRecordHistory.

        Returns
        -------
        Union[str, None, Unset_Type]
            The new_short_name of this GrantaServerApiRecordsRecordHistoriesCopyRecordHistory.
        """
        return self._new_short_name

    @new_short_name.setter
    def new_short_name(self, new_short_name: "Union[str, None, Unset_Type]") -> None:
        """Sets the new_short_name of this GrantaServerApiRecordsRecordHistoriesCopyRecordHistory.

        Parameters
        ----------
        new_short_name: Union[str, None, Unset_Type]
            The new_short_name of this GrantaServerApiRecordsRecordHistoriesCopyRecordHistory.
        """
        self._new_short_name = new_short_name

    @classmethod
    def get_real_child_model(cls, data: Dict[str, str]) -> str:
        """Raises a NotImplementedError for a type without a discriminator defined.

        Parameters
        ----------
        data: ModelBase
            Object representing a subclass of this class

        Raises
        ------
        NotImplementedError
            This class has no discriminator, and hence no subclasses
        """
        raise NotImplementedError()

    def __repr__(self) -> str:
        """For 'print' and 'pprint'"""
        return self.to_str()

    def __eq__(self, other: Any) -> bool:
        """Returns true if both objects are equal"""
        if not isinstance(other, GrantaServerApiRecordsRecordHistoriesCopyRecordHistory):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other: Any) -> bool:
        """Returns true if both objects are not equal"""
        return not self == other
