# Copyright (C) 2023 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""
    MI Server API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: v1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import re  # noqa: F401
from typing import TYPE_CHECKING, Any, BinaryIO, Dict, List, Optional, Union  # noqa: F401

from . import ModelBase, Unset, Unset_Type

if TYPE_CHECKING:
    from datetime import datetime
    import pathlib

    from . import *


class GrantaServerApiRecordsRecordVersionsRecordVersion(ModelBase):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes
    ----------
    swagger_types: Dict[str, str]
        The key is attribute name and the value is attribute type.
    attribute_map: Dict[str, str]
        The key is attribute name and the value is json key in definition.
    subtype_mapping: Dict[str, str]
        The key is the unmangled property name and the value is the corresponding type.
    discriminator: Optional[str]
        Name of the property used as discriminator for subtypes.
    """
    swagger_types: Dict[str, str] = {
        "created_by_user": "str",
        "created_date": "datetime",
        "database_key": "str",
        "guid": "str",
        "last_modified_by_user": "str",
        "last_modified_date": "datetime",
        "name": "str",
        "record_color": "GrantaServerApiRecordColor",
        "record_history": "GrantaServerApiRecordsRecordHistoriesSlimRecordHistory",
        "record_type": "GrantaServerApiRecordType",
        "short_name": "str",
        "table": "GrantaServerApiSchemaSlimEntitiesSlimTable",
        "version_number": "int",
        "version_state": "GrantaServerApiVersionState",
        "released_date": "datetime",
    }

    attribute_map: Dict[str, str] = {
        "created_by_user": "createdByUser",
        "created_date": "createdDate",
        "database_key": "databaseKey",
        "guid": "guid",
        "last_modified_by_user": "lastModifiedByUser",
        "last_modified_date": "lastModifiedDate",
        "name": "name",
        "record_color": "recordColor",
        "record_history": "recordHistory",
        "record_type": "recordType",
        "short_name": "shortName",
        "table": "table",
        "version_number": "versionNumber",
        "version_state": "versionState",
        "released_date": "releasedDate",
    }

    subtype_mapping: Dict[str, str] = {
        "recordHistory": "GrantaServerApiRecordsRecordHistoriesSlimRecordHistory",
        "table": "GrantaServerApiSchemaSlimEntitiesSlimTable",
        "recordType": "GrantaServerApiRecordType",
        "recordColor": "GrantaServerApiRecordColor",
        "versionState": "GrantaServerApiVersionState",
    }

    discriminator: Optional[str] = None

    def __init__(
        self,
        *,
        created_by_user: "str",
        created_date: "datetime",
        database_key: "str",
        guid: "str",
        last_modified_by_user: "str",
        last_modified_date: "datetime",
        name: "str",
        record_color: "GrantaServerApiRecordColor",
        record_history: "GrantaServerApiRecordsRecordHistoriesSlimRecordHistory",
        record_type: "GrantaServerApiRecordType",
        short_name: "str",
        table: "GrantaServerApiSchemaSlimEntitiesSlimTable",
        version_number: "int",
        version_state: "GrantaServerApiVersionState",
        released_date: "Union[datetime, None, Unset_Type]" = Unset,
    ) -> None:
        """GrantaServerApiRecordsRecordVersionsRecordVersion - a model defined in Swagger

        Parameters
        ----------
        created_by_user: str
        created_date: datetime
        database_key: str
        guid: str
        last_modified_by_user: str
        last_modified_date: datetime
        name: str
        record_color: GrantaServerApiRecordColor
        record_history: GrantaServerApiRecordsRecordHistoriesSlimRecordHistory
        record_type: GrantaServerApiRecordType
        short_name: str
        table: GrantaServerApiSchemaSlimEntitiesSlimTable
        version_number: int
        version_state: GrantaServerApiVersionState
        released_date: datetime, optional
        """
        self._record_history: GrantaServerApiRecordsRecordHistoriesSlimRecordHistory
        self._table: GrantaServerApiSchemaSlimEntitiesSlimTable
        self._database_key: str
        self._created_by_user: str
        self._created_date: datetime
        self._last_modified_by_user: str
        self._last_modified_date: datetime
        self._record_type: GrantaServerApiRecordType
        self._released_date: Union[datetime, None, Unset_Type] = Unset
        self._short_name: str
        self._record_color: GrantaServerApiRecordColor
        self._version_number: int
        self._version_state: GrantaServerApiVersionState
        self._name: str
        self._guid: str

        self.record_history = record_history
        self.table = table
        self.database_key = database_key
        self.created_by_user = created_by_user
        self.created_date = created_date
        self.last_modified_by_user = last_modified_by_user
        self.last_modified_date = last_modified_date
        self.record_type = record_type
        if released_date is not Unset:
            self.released_date = released_date
        self.short_name = short_name
        self.record_color = record_color
        self.version_number = version_number
        self.version_state = version_state
        self.name = name
        self.guid = guid

    @property
    def record_history(self) -> "GrantaServerApiRecordsRecordHistoriesSlimRecordHistory":
        """Gets the record_history of this GrantaServerApiRecordsRecordVersionsRecordVersion.

        Returns
        -------
        GrantaServerApiRecordsRecordHistoriesSlimRecordHistory
            The record_history of this GrantaServerApiRecordsRecordVersionsRecordVersion.
        """
        return self._record_history

    @record_history.setter
    def record_history(
        self, record_history: "GrantaServerApiRecordsRecordHistoriesSlimRecordHistory"
    ) -> None:
        """Sets the record_history of this GrantaServerApiRecordsRecordVersionsRecordVersion.

        Parameters
        ----------
        record_history: GrantaServerApiRecordsRecordHistoriesSlimRecordHistory
            The record_history of this GrantaServerApiRecordsRecordVersionsRecordVersion.
        """
        # Field is not nullable
        if record_history is None:
            raise ValueError("Invalid value for 'record_history', must not be 'None'")
        # Field is required
        if record_history is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'record_history', must not be 'Unset'")
        self._record_history = record_history

    @property
    def table(self) -> "GrantaServerApiSchemaSlimEntitiesSlimTable":
        """Gets the table of this GrantaServerApiRecordsRecordVersionsRecordVersion.

        Returns
        -------
        GrantaServerApiSchemaSlimEntitiesSlimTable
            The table of this GrantaServerApiRecordsRecordVersionsRecordVersion.
        """
        return self._table

    @table.setter
    def table(self, table: "GrantaServerApiSchemaSlimEntitiesSlimTable") -> None:
        """Sets the table of this GrantaServerApiRecordsRecordVersionsRecordVersion.

        Parameters
        ----------
        table: GrantaServerApiSchemaSlimEntitiesSlimTable
            The table of this GrantaServerApiRecordsRecordVersionsRecordVersion.
        """
        # Field is not nullable
        if table is None:
            raise ValueError("Invalid value for 'table', must not be 'None'")
        # Field is required
        if table is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'table', must not be 'Unset'")
        self._table = table

    @property
    def database_key(self) -> "str":
        """Gets the database_key of this GrantaServerApiRecordsRecordVersionsRecordVersion.

        Returns
        -------
        str
            The database_key of this GrantaServerApiRecordsRecordVersionsRecordVersion.
        """
        return self._database_key

    @database_key.setter
    def database_key(self, database_key: "str") -> None:
        """Sets the database_key of this GrantaServerApiRecordsRecordVersionsRecordVersion.

        Parameters
        ----------
        database_key: str
            The database_key of this GrantaServerApiRecordsRecordVersionsRecordVersion.
        """
        # Field is not nullable
        if database_key is None:
            raise ValueError("Invalid value for 'database_key', must not be 'None'")
        # Field is required
        if database_key is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'database_key', must not be 'Unset'")
        self._database_key = database_key

    @property
    def created_by_user(self) -> "str":
        """Gets the created_by_user of this GrantaServerApiRecordsRecordVersionsRecordVersion.

        Returns
        -------
        str
            The created_by_user of this GrantaServerApiRecordsRecordVersionsRecordVersion.
        """
        return self._created_by_user

    @created_by_user.setter
    def created_by_user(self, created_by_user: "str") -> None:
        """Sets the created_by_user of this GrantaServerApiRecordsRecordVersionsRecordVersion.

        Parameters
        ----------
        created_by_user: str
            The created_by_user of this GrantaServerApiRecordsRecordVersionsRecordVersion.
        """
        # Field is not nullable
        if created_by_user is None:
            raise ValueError("Invalid value for 'created_by_user', must not be 'None'")
        # Field is required
        if created_by_user is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'created_by_user', must not be 'Unset'")
        self._created_by_user = created_by_user

    @property
    def created_date(self) -> "datetime":
        """Gets the created_date of this GrantaServerApiRecordsRecordVersionsRecordVersion.

        Returns
        -------
        datetime
            The created_date of this GrantaServerApiRecordsRecordVersionsRecordVersion.
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date: "datetime") -> None:
        """Sets the created_date of this GrantaServerApiRecordsRecordVersionsRecordVersion.

        Parameters
        ----------
        created_date: datetime
            The created_date of this GrantaServerApiRecordsRecordVersionsRecordVersion.
        """
        # Field is not nullable
        if created_date is None:
            raise ValueError("Invalid value for 'created_date', must not be 'None'")
        # Field is required
        if created_date is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'created_date', must not be 'Unset'")
        self._created_date = created_date

    @property
    def last_modified_by_user(self) -> "str":
        """Gets the last_modified_by_user of this GrantaServerApiRecordsRecordVersionsRecordVersion.

        Returns
        -------
        str
            The last_modified_by_user of this GrantaServerApiRecordsRecordVersionsRecordVersion.
        """
        return self._last_modified_by_user

    @last_modified_by_user.setter
    def last_modified_by_user(self, last_modified_by_user: "str") -> None:
        """Sets the last_modified_by_user of this GrantaServerApiRecordsRecordVersionsRecordVersion.

        Parameters
        ----------
        last_modified_by_user: str
            The last_modified_by_user of this GrantaServerApiRecordsRecordVersionsRecordVersion.
        """
        # Field is not nullable
        if last_modified_by_user is None:
            raise ValueError("Invalid value for 'last_modified_by_user', must not be 'None'")
        # Field is required
        if last_modified_by_user is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'last_modified_by_user', must not be 'Unset'")
        self._last_modified_by_user = last_modified_by_user

    @property
    def last_modified_date(self) -> "datetime":
        """Gets the last_modified_date of this GrantaServerApiRecordsRecordVersionsRecordVersion.

        Returns
        -------
        datetime
            The last_modified_date of this GrantaServerApiRecordsRecordVersionsRecordVersion.
        """
        return self._last_modified_date

    @last_modified_date.setter
    def last_modified_date(self, last_modified_date: "datetime") -> None:
        """Sets the last_modified_date of this GrantaServerApiRecordsRecordVersionsRecordVersion.

        Parameters
        ----------
        last_modified_date: datetime
            The last_modified_date of this GrantaServerApiRecordsRecordVersionsRecordVersion.
        """
        # Field is not nullable
        if last_modified_date is None:
            raise ValueError("Invalid value for 'last_modified_date', must not be 'None'")
        # Field is required
        if last_modified_date is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'last_modified_date', must not be 'Unset'")
        self._last_modified_date = last_modified_date

    @property
    def record_type(self) -> "GrantaServerApiRecordType":
        """Gets the record_type of this GrantaServerApiRecordsRecordVersionsRecordVersion.

        Returns
        -------
        GrantaServerApiRecordType
            The record_type of this GrantaServerApiRecordsRecordVersionsRecordVersion.
        """
        return self._record_type

    @record_type.setter
    def record_type(self, record_type: "GrantaServerApiRecordType") -> None:
        """Sets the record_type of this GrantaServerApiRecordsRecordVersionsRecordVersion.

        Parameters
        ----------
        record_type: GrantaServerApiRecordType
            The record_type of this GrantaServerApiRecordsRecordVersionsRecordVersion.
        """
        # Field is not nullable
        if record_type is None:
            raise ValueError("Invalid value for 'record_type', must not be 'None'")
        # Field is required
        if record_type is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'record_type', must not be 'Unset'")
        self._record_type = record_type

    @property
    def released_date(self) -> "Union[datetime, None, Unset_Type]":
        """Gets the released_date of this GrantaServerApiRecordsRecordVersionsRecordVersion.

        Returns
        -------
        Union[datetime, None, Unset_Type]
            The released_date of this GrantaServerApiRecordsRecordVersionsRecordVersion.
        """
        return self._released_date

    @released_date.setter
    def released_date(self, released_date: "Union[datetime, None, Unset_Type]") -> None:
        """Sets the released_date of this GrantaServerApiRecordsRecordVersionsRecordVersion.

        Parameters
        ----------
        released_date: Union[datetime, None, Unset_Type]
            The released_date of this GrantaServerApiRecordsRecordVersionsRecordVersion.
        """
        self._released_date = released_date

    @property
    def short_name(self) -> "str":
        """Gets the short_name of this GrantaServerApiRecordsRecordVersionsRecordVersion.

        Returns
        -------
        str
            The short_name of this GrantaServerApiRecordsRecordVersionsRecordVersion.
        """
        return self._short_name

    @short_name.setter
    def short_name(self, short_name: "str") -> None:
        """Sets the short_name of this GrantaServerApiRecordsRecordVersionsRecordVersion.

        Parameters
        ----------
        short_name: str
            The short_name of this GrantaServerApiRecordsRecordVersionsRecordVersion.
        """
        # Field is not nullable
        if short_name is None:
            raise ValueError("Invalid value for 'short_name', must not be 'None'")
        # Field is required
        if short_name is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'short_name', must not be 'Unset'")
        self._short_name = short_name

    @property
    def record_color(self) -> "GrantaServerApiRecordColor":
        """Gets the record_color of this GrantaServerApiRecordsRecordVersionsRecordVersion.

        Returns
        -------
        GrantaServerApiRecordColor
            The record_color of this GrantaServerApiRecordsRecordVersionsRecordVersion.
        """
        return self._record_color

    @record_color.setter
    def record_color(self, record_color: "GrantaServerApiRecordColor") -> None:
        """Sets the record_color of this GrantaServerApiRecordsRecordVersionsRecordVersion.

        Parameters
        ----------
        record_color: GrantaServerApiRecordColor
            The record_color of this GrantaServerApiRecordsRecordVersionsRecordVersion.
        """
        # Field is not nullable
        if record_color is None:
            raise ValueError("Invalid value for 'record_color', must not be 'None'")
        # Field is required
        if record_color is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'record_color', must not be 'Unset'")
        self._record_color = record_color

    @property
    def version_number(self) -> "int":
        """Gets the version_number of this GrantaServerApiRecordsRecordVersionsRecordVersion.

        Returns
        -------
        int
            The version_number of this GrantaServerApiRecordsRecordVersionsRecordVersion.
        """
        return self._version_number

    @version_number.setter
    def version_number(self, version_number: "int") -> None:
        """Sets the version_number of this GrantaServerApiRecordsRecordVersionsRecordVersion.

        Parameters
        ----------
        version_number: int
            The version_number of this GrantaServerApiRecordsRecordVersionsRecordVersion.
        """
        # Field is not nullable
        if version_number is None:
            raise ValueError("Invalid value for 'version_number', must not be 'None'")
        # Field is required
        if version_number is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'version_number', must not be 'Unset'")
        self._version_number = version_number

    @property
    def version_state(self) -> "GrantaServerApiVersionState":
        """Gets the version_state of this GrantaServerApiRecordsRecordVersionsRecordVersion.

        Returns
        -------
        GrantaServerApiVersionState
            The version_state of this GrantaServerApiRecordsRecordVersionsRecordVersion.
        """
        return self._version_state

    @version_state.setter
    def version_state(self, version_state: "GrantaServerApiVersionState") -> None:
        """Sets the version_state of this GrantaServerApiRecordsRecordVersionsRecordVersion.

        Parameters
        ----------
        version_state: GrantaServerApiVersionState
            The version_state of this GrantaServerApiRecordsRecordVersionsRecordVersion.
        """
        # Field is not nullable
        if version_state is None:
            raise ValueError("Invalid value for 'version_state', must not be 'None'")
        # Field is required
        if version_state is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'version_state', must not be 'Unset'")
        self._version_state = version_state

    @property
    def name(self) -> "str":
        """Gets the name of this GrantaServerApiRecordsRecordVersionsRecordVersion.

        Returns
        -------
        str
            The name of this GrantaServerApiRecordsRecordVersionsRecordVersion.
        """
        return self._name

    @name.setter
    def name(self, name: "str") -> None:
        """Sets the name of this GrantaServerApiRecordsRecordVersionsRecordVersion.

        Parameters
        ----------
        name: str
            The name of this GrantaServerApiRecordsRecordVersionsRecordVersion.
        """
        # Field is not nullable
        if name is None:
            raise ValueError("Invalid value for 'name', must not be 'None'")
        # Field is required
        if name is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'name', must not be 'Unset'")
        self._name = name

    @property
    def guid(self) -> "str":
        """Gets the guid of this GrantaServerApiRecordsRecordVersionsRecordVersion.

        Returns
        -------
        str
            The guid of this GrantaServerApiRecordsRecordVersionsRecordVersion.
        """
        return self._guid

    @guid.setter
    def guid(self, guid: "str") -> None:
        """Sets the guid of this GrantaServerApiRecordsRecordVersionsRecordVersion.

        Parameters
        ----------
        guid: str
            The guid of this GrantaServerApiRecordsRecordVersionsRecordVersion.
        """
        # Field is not nullable
        if guid is None:
            raise ValueError("Invalid value for 'guid', must not be 'None'")
        # Field is required
        if guid is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'guid', must not be 'Unset'")
        self._guid = guid

    @classmethod
    def get_real_child_model(cls, data: Dict[str, str]) -> str:
        """Raises a NotImplementedError for a type without a discriminator defined.

        Parameters
        ----------
        data: ModelBase
            Object representing a subclass of this class

        Raises
        ------
        NotImplementedError
            This class has no discriminator, and hence no subclasses
        """
        raise NotImplementedError()

    def __repr__(self) -> str:
        """For 'print' and 'pprint'"""
        return self.to_str()

    def __eq__(self, other: Any) -> bool:
        """Returns true if both objects are equal"""
        if not isinstance(other, GrantaServerApiRecordsRecordVersionsRecordVersion):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other: Any) -> bool:
        """Returns true if both objects are not equal"""
        return not self == other
