# Copyright (C) 2023 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""
    MI Server API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: v1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import re  # noqa: F401
from typing import TYPE_CHECKING, Any, BinaryIO, Dict, List, Optional, Union  # noqa: F401

from . import ModelBase, Unset, Unset_Type

if TYPE_CHECKING:
    from datetime import datetime
    import pathlib

    from . import *


class GrantaServerApiRecordsRecordVersionsSlimRecordVersion(ModelBase):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes
    ----------
    swagger_types: Dict[str, str]
        The key is attribute name and the value is attribute type.
    attribute_map: Dict[str, str]
        The key is attribute name and the value is json key in definition.
    subtype_mapping: Dict[str, str]
        The key is the unmangled property name and the value is the corresponding type.
    discriminator: Optional[str]
        Name of the property used as discriminator for subtypes.
    """
    swagger_types: Dict[str, str] = {
        "guid": "str",
        "name": "str",
        "version_number": "int",
        "version_state": "GrantaServerApiVersionState",
    }

    attribute_map: Dict[str, str] = {
        "guid": "guid",
        "name": "name",
        "version_number": "versionNumber",
        "version_state": "versionState",
    }

    subtype_mapping: Dict[str, str] = {
        "versionState": "GrantaServerApiVersionState",
    }

    discriminator: Optional[str] = None

    def __init__(
        self,
        *,
        guid: "str",
        name: "str",
        version_number: "int",
        version_state: "GrantaServerApiVersionState",
    ) -> None:
        """GrantaServerApiRecordsRecordVersionsSlimRecordVersion - a model defined in Swagger

        Parameters
        ----------
        guid: str
        name: str
        version_number: int
        version_state: GrantaServerApiVersionState
        """
        self._version_number: int
        self._version_state: GrantaServerApiVersionState
        self._name: str
        self._guid: str

        self.version_number = version_number
        self.version_state = version_state
        self.name = name
        self.guid = guid

    @property
    def version_number(self) -> "int":
        """Gets the version_number of this GrantaServerApiRecordsRecordVersionsSlimRecordVersion.

        Returns
        -------
        int
            The version_number of this GrantaServerApiRecordsRecordVersionsSlimRecordVersion.
        """
        return self._version_number

    @version_number.setter
    def version_number(self, version_number: "int") -> None:
        """Sets the version_number of this GrantaServerApiRecordsRecordVersionsSlimRecordVersion.

        Parameters
        ----------
        version_number: int
            The version_number of this GrantaServerApiRecordsRecordVersionsSlimRecordVersion.
        """
        # Field is not nullable
        if version_number is None:
            raise ValueError("Invalid value for 'version_number', must not be 'None'")
        # Field is required
        if version_number is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'version_number', must not be 'Unset'")
        self._version_number = version_number

    @property
    def version_state(self) -> "GrantaServerApiVersionState":
        """Gets the version_state of this GrantaServerApiRecordsRecordVersionsSlimRecordVersion.

        Returns
        -------
        GrantaServerApiVersionState
            The version_state of this GrantaServerApiRecordsRecordVersionsSlimRecordVersion.
        """
        return self._version_state

    @version_state.setter
    def version_state(self, version_state: "GrantaServerApiVersionState") -> None:
        """Sets the version_state of this GrantaServerApiRecordsRecordVersionsSlimRecordVersion.

        Parameters
        ----------
        version_state: GrantaServerApiVersionState
            The version_state of this GrantaServerApiRecordsRecordVersionsSlimRecordVersion.
        """
        # Field is not nullable
        if version_state is None:
            raise ValueError("Invalid value for 'version_state', must not be 'None'")
        # Field is required
        if version_state is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'version_state', must not be 'Unset'")
        self._version_state = version_state

    @property
    def name(self) -> "str":
        """Gets the name of this GrantaServerApiRecordsRecordVersionsSlimRecordVersion.

        Returns
        -------
        str
            The name of this GrantaServerApiRecordsRecordVersionsSlimRecordVersion.
        """
        return self._name

    @name.setter
    def name(self, name: "str") -> None:
        """Sets the name of this GrantaServerApiRecordsRecordVersionsSlimRecordVersion.

        Parameters
        ----------
        name: str
            The name of this GrantaServerApiRecordsRecordVersionsSlimRecordVersion.
        """
        # Field is not nullable
        if name is None:
            raise ValueError("Invalid value for 'name', must not be 'None'")
        # Field is required
        if name is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'name', must not be 'Unset'")
        self._name = name

    @property
    def guid(self) -> "str":
        """Gets the guid of this GrantaServerApiRecordsRecordVersionsSlimRecordVersion.

        Returns
        -------
        str
            The guid of this GrantaServerApiRecordsRecordVersionsSlimRecordVersion.
        """
        return self._guid

    @guid.setter
    def guid(self, guid: "str") -> None:
        """Sets the guid of this GrantaServerApiRecordsRecordVersionsSlimRecordVersion.

        Parameters
        ----------
        guid: str
            The guid of this GrantaServerApiRecordsRecordVersionsSlimRecordVersion.
        """
        # Field is not nullable
        if guid is None:
            raise ValueError("Invalid value for 'guid', must not be 'None'")
        # Field is required
        if guid is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'guid', must not be 'Unset'")
        self._guid = guid

    @classmethod
    def get_real_child_model(cls, data: Dict[str, str]) -> str:
        """Raises a NotImplementedError for a type without a discriminator defined.

        Parameters
        ----------
        data: ModelBase
            Object representing a subclass of this class

        Raises
        ------
        NotImplementedError
            This class has no discriminator, and hence no subclasses
        """
        raise NotImplementedError()

    def __repr__(self) -> str:
        """For 'print' and 'pprint'"""
        return self.to_str()

    def __eq__(self, other: Any) -> bool:
        """Returns true if both objects are equal"""
        if not isinstance(other, GrantaServerApiRecordsRecordVersionsSlimRecordVersion):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other: Any) -> bool:
        """Returns true if both objects are not equal"""
        return not self == other
