# Copyright (C) 2023 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""
    MI Server API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: v1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import re  # noqa: F401
from typing import TYPE_CHECKING, Any, BinaryIO, Dict, List, Optional, Union  # noqa: F401

from . import ModelBase, Unset, Unset_Type

if TYPE_CHECKING:
    from datetime import datetime
    import pathlib

    from . import *


class GrantaServerApiSchemaAttributesUpdateAttributesUpdateAttribute(ModelBase):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes
    ----------
    swagger_types: Dict[str, str]
        The key is attribute name and the value is attribute type.
    attribute_map: Dict[str, str]
        The key is attribute name and the value is json key in definition.
    subtype_mapping: Dict[str, str]
        The key is the unmangled property name and the value is the corresponding type.
    discriminator_class_map: Dict[str, str]
        They key is discriminator value and the value is associated subtype.
    discriminator: Optional[str]
        Name of the property used as discriminator for subtypes.
    """
    swagger_types: Dict[str, str] = {
        "about_attribute": "GrantaServerApiSchemaSlimEntitiesSlimEntity",
        "axis_name": "str",
        "default_threshold_type": "GrantaServerApiSchemaAttributesAttributeThresholdType",
        "guid": "str",
        "help_path": "str",
        "name": "str",
    }

    attribute_map: Dict[str, str] = {
        "about_attribute": "aboutAttribute",
        "axis_name": "axisName",
        "default_threshold_type": "defaultThresholdType",
        "guid": "guid",
        "help_path": "helpPath",
        "name": "name",
    }

    subtype_mapping: Dict[str, str] = {
        "defaultThresholdType": "GrantaServerApiSchemaAttributesAttributeThresholdType",
        "aboutAttribute": "GrantaServerApiSchemaSlimEntitiesSlimEntity",
    }

    discriminator_value_class_map = {
        "point".lower(): "#/components/schemas/GrantaServerApiSchemaAttributesUpdateAttributesUpdatePointAttribute",
        "integer".lower(): "#/components/schemas/GrantaServerApiSchemaAttributesUpdateAttributesUpdateIntegerAttribute",
        "range".lower(): "#/components/schemas/GrantaServerApiSchemaAttributesUpdateAttributesUpdateRangeAttribute",
        "logical".lower(): "#/components/schemas/GrantaServerApiSchemaAttributesUpdateAttributesUpdateLogicalAttribute",
        "shortText".lower(): "#/components/schemas/GrantaServerApiSchemaAttributesUpdateAttributesUpdateShortTextAttribute",
        "longText".lower(): "#/components/schemas/GrantaServerApiSchemaAttributesUpdateAttributesUpdateLongTextAttribute",
        "dateTime".lower(): "#/components/schemas/GrantaServerApiSchemaAttributesUpdateAttributesUpdateDateTimeAttribute",
        "discrete".lower(): "#/components/schemas/GrantaServerApiSchemaAttributesUpdateAttributesUpdateDiscreteAttribute",
        "hyperlink".lower(): "#/components/schemas/GrantaServerApiSchemaAttributesUpdateAttributesUpdateHyperlinkAttribute",
        "file".lower(): "#/components/schemas/GrantaServerApiSchemaAttributesUpdateAttributesUpdateFileAttribute",
        "picture".lower(): "#/components/schemas/GrantaServerApiSchemaAttributesUpdateAttributesUpdatePictureAttribute",
        "link".lower(): "#/components/schemas/GrantaServerApiSchemaAttributesUpdateAttributesUpdateTabularAttribute",
        "floatFunctional".lower(): "#/components/schemas/GrantaServerApiSchemaAttributesUpdateAttributesUpdateFloatFunctionalAttribute",
        "discreteFunctional".lower(): "#/components/schemas/GrantaServerApiSchemaAttributesUpdateAttributesUpdateDiscreteFunctionalAttribute",
        "mathsFunctional".lower(): "#/components/schemas/GrantaServerApiSchemaAttributesUpdateAttributesUpdateMathsFunctionalAttribute",
    }

    discriminator: Optional[str] = "type"

    def __init__(
        self,
        *,
        about_attribute: "Union[GrantaServerApiSchemaSlimEntitiesSlimEntity, Unset_Type]" = Unset,
        axis_name: "Union[str, None, Unset_Type]" = Unset,
        default_threshold_type: "Union[GrantaServerApiSchemaAttributesAttributeThresholdType, Unset_Type]" = Unset,
        guid: "Union[str, Unset_Type]" = Unset,
        help_path: "Union[str, None, Unset_Type]" = Unset,
        name: "Union[str, Unset_Type]" = Unset,
    ) -> None:
        """GrantaServerApiSchemaAttributesUpdateAttributesUpdateAttribute - a model defined in Swagger

        Parameters
        ----------
        about_attribute: GrantaServerApiSchemaSlimEntitiesSlimEntity, optional
        axis_name: str, optional
        default_threshold_type: GrantaServerApiSchemaAttributesAttributeThresholdType, optional
        guid: str, optional
        help_path: str, optional
        name: str, optional
        """
        self._default_threshold_type: Union[
            GrantaServerApiSchemaAttributesAttributeThresholdType, Unset_Type
        ] = Unset
        self._axis_name: Union[str, None, Unset_Type] = Unset
        self._help_path: Union[str, None, Unset_Type] = Unset
        self._about_attribute: Union[GrantaServerApiSchemaSlimEntitiesSlimEntity, Unset_Type] = (
            Unset
        )
        self._name: Union[str, Unset_Type] = Unset
        self._guid: Union[str, Unset_Type] = Unset

        if default_threshold_type is not Unset:
            self.default_threshold_type = default_threshold_type
        if axis_name is not Unset:
            self.axis_name = axis_name
        if help_path is not Unset:
            self.help_path = help_path
        if about_attribute is not Unset:
            self.about_attribute = about_attribute
        if name is not Unset:
            self.name = name
        if guid is not Unset:
            self.guid = guid

    @property
    def default_threshold_type(
        self,
    ) -> "Union[GrantaServerApiSchemaAttributesAttributeThresholdType, Unset_Type]":
        """Gets the default_threshold_type of this GrantaServerApiSchemaAttributesUpdateAttributesUpdateAttribute.

        Returns
        -------
        Union[GrantaServerApiSchemaAttributesAttributeThresholdType, Unset_Type]
            The default_threshold_type of this GrantaServerApiSchemaAttributesUpdateAttributesUpdateAttribute.
        """
        return self._default_threshold_type

    @default_threshold_type.setter
    def default_threshold_type(
        self,
        default_threshold_type: "Union[GrantaServerApiSchemaAttributesAttributeThresholdType, Unset_Type]",
    ) -> None:
        """Sets the default_threshold_type of this GrantaServerApiSchemaAttributesUpdateAttributesUpdateAttribute.

        Parameters
        ----------
        default_threshold_type: Union[GrantaServerApiSchemaAttributesAttributeThresholdType, Unset_Type]
            The default_threshold_type of this GrantaServerApiSchemaAttributesUpdateAttributesUpdateAttribute.
        """
        # Field is not nullable
        if default_threshold_type is None:
            raise ValueError("Invalid value for 'default_threshold_type', must not be 'None'")
        self._default_threshold_type = default_threshold_type

    @property
    def axis_name(self) -> "Union[str, None, Unset_Type]":
        """Gets the axis_name of this GrantaServerApiSchemaAttributesUpdateAttributesUpdateAttribute.

        Returns
        -------
        Union[str, None, Unset_Type]
            The axis_name of this GrantaServerApiSchemaAttributesUpdateAttributesUpdateAttribute.
        """
        return self._axis_name

    @axis_name.setter
    def axis_name(self, axis_name: "Union[str, None, Unset_Type]") -> None:
        """Sets the axis_name of this GrantaServerApiSchemaAttributesUpdateAttributesUpdateAttribute.

        Parameters
        ----------
        axis_name: Union[str, None, Unset_Type]
            The axis_name of this GrantaServerApiSchemaAttributesUpdateAttributesUpdateAttribute.
        """
        self._axis_name = axis_name

    @property
    def help_path(self) -> "Union[str, None, Unset_Type]":
        """Gets the help_path of this GrantaServerApiSchemaAttributesUpdateAttributesUpdateAttribute.

        Returns
        -------
        Union[str, None, Unset_Type]
            The help_path of this GrantaServerApiSchemaAttributesUpdateAttributesUpdateAttribute.
        """
        return self._help_path

    @help_path.setter
    def help_path(self, help_path: "Union[str, None, Unset_Type]") -> None:
        """Sets the help_path of this GrantaServerApiSchemaAttributesUpdateAttributesUpdateAttribute.

        Parameters
        ----------
        help_path: Union[str, None, Unset_Type]
            The help_path of this GrantaServerApiSchemaAttributesUpdateAttributesUpdateAttribute.
        """
        self._help_path = help_path

    @property
    def about_attribute(self) -> "Union[GrantaServerApiSchemaSlimEntitiesSlimEntity, Unset_Type]":
        """Gets the about_attribute of this GrantaServerApiSchemaAttributesUpdateAttributesUpdateAttribute.

        Returns
        -------
        Union[GrantaServerApiSchemaSlimEntitiesSlimEntity, Unset_Type]
            The about_attribute of this GrantaServerApiSchemaAttributesUpdateAttributesUpdateAttribute.
        """
        return self._about_attribute

    @about_attribute.setter
    def about_attribute(
        self, about_attribute: "Union[GrantaServerApiSchemaSlimEntitiesSlimEntity, Unset_Type]"
    ) -> None:
        """Sets the about_attribute of this GrantaServerApiSchemaAttributesUpdateAttributesUpdateAttribute.

        Parameters
        ----------
        about_attribute: Union[GrantaServerApiSchemaSlimEntitiesSlimEntity, Unset_Type]
            The about_attribute of this GrantaServerApiSchemaAttributesUpdateAttributesUpdateAttribute.
        """
        # Field is not nullable
        if about_attribute is None:
            raise ValueError("Invalid value for 'about_attribute', must not be 'None'")
        self._about_attribute = about_attribute

    @property
    def name(self) -> "Union[str, Unset_Type]":
        """Gets the name of this GrantaServerApiSchemaAttributesUpdateAttributesUpdateAttribute.

        Returns
        -------
        Union[str, Unset_Type]
            The name of this GrantaServerApiSchemaAttributesUpdateAttributesUpdateAttribute.
        """
        return self._name

    @name.setter
    def name(self, name: "Union[str, Unset_Type]") -> None:
        """Sets the name of this GrantaServerApiSchemaAttributesUpdateAttributesUpdateAttribute.

        Parameters
        ----------
        name: Union[str, Unset_Type]
            The name of this GrantaServerApiSchemaAttributesUpdateAttributesUpdateAttribute.
        """
        # Field is not nullable
        if name is None:
            raise ValueError("Invalid value for 'name', must not be 'None'")
        self._name = name

    @property
    def guid(self) -> "Union[str, Unset_Type]":
        """Gets the guid of this GrantaServerApiSchemaAttributesUpdateAttributesUpdateAttribute.

        Returns
        -------
        Union[str, Unset_Type]
            The guid of this GrantaServerApiSchemaAttributesUpdateAttributesUpdateAttribute.
        """
        return self._guid

    @guid.setter
    def guid(self, guid: "Union[str, Unset_Type]") -> None:
        """Sets the guid of this GrantaServerApiSchemaAttributesUpdateAttributesUpdateAttribute.

        Parameters
        ----------
        guid: Union[str, Unset_Type]
            The guid of this GrantaServerApiSchemaAttributesUpdateAttributesUpdateAttribute.
        """
        # Field is not nullable
        if guid is None:
            raise ValueError("Invalid value for 'guid', must not be 'None'")
        self._guid = guid

    @classmethod
    def get_real_child_model(cls, data: Dict[str, str]) -> str:
        """Returns the real base class as determined by the discriminator

        Parameters
        ----------
        data: ModelBase
            Object representing a subclass of this class
        """
        discriminator_value = str(data[cls._get_discriminator_field_name()]).lower()
        # The actual class name is not available in swagger-codegen,
        # so we have to extract it from the JSON reference
        return cls.discriminator_value_class_map[discriminator_value].rsplit("/", 1)[-1]

    @classmethod
    def _get_discriminator_field_name(cls) -> str:
        assert cls.discriminator
        name_tokens = cls.discriminator.split("_")
        later_tokens = [element.capitalize() for element in name_tokens[1:]]
        return "".join([name_tokens[0], *later_tokens])

    def __repr__(self) -> str:
        """For 'print' and 'pprint'"""
        return self.to_str()

    def __eq__(self, other: Any) -> bool:
        """Returns true if both objects are equal"""
        if not isinstance(other, GrantaServerApiSchemaAttributesUpdateAttributesUpdateAttribute):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other: Any) -> bool:
        """Returns true if both objects are not equal"""
        return not self == other
