# Copyright (C) 2023 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""
    MI Server API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: v1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import re  # noqa: F401
from typing import TYPE_CHECKING, Any, BinaryIO, Dict, List, Optional, Union  # noqa: F401

from ansys.grantami.serverapi_openapi.models.granta_server_api_schema_layouts_new_layout_item import (  # noqa: F401
    GrantaServerApiSchemaLayoutsNewLayoutItem,
)

from . import ModelBase, Unset, Unset_Type

if TYPE_CHECKING:
    from datetime import datetime
    import pathlib

    from . import *


class GrantaServerApiSchemaLayoutsNewLayoutAssociationChainItem(
    GrantaServerApiSchemaLayoutsNewLayoutItem
):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes
    ----------
    swagger_types: Dict[str, str]
        The key is attribute name and the value is attribute type.
    attribute_map: Dict[str, str]
        The key is attribute name and the value is json key in definition.
    subtype_mapping: Dict[str, str]
        The key is the unmangled property name and the value is the corresponding type.
    discriminator: Optional[str]
        Name of the property used as discriminator for subtypes.
    """
    swagger_types: Dict[str, str] = {
        "association_chain_links": "list[GrantaServerApiSchemaLayoutsNewLayoutAssociationChainLink]",
        "association_chain_name": "str",
        "guid": "str",
        "item_type": "str",
    }

    attribute_map: Dict[str, str] = {
        "association_chain_links": "associationChainLinks",
        "association_chain_name": "associationChainName",
        "guid": "guid",
        "item_type": "itemType",
    }

    subtype_mapping: Dict[str, str] = {
        "associationChainLinks": "GrantaServerApiSchemaLayoutsNewLayoutAssociationChainLink",
    }

    discriminator: Optional[str] = None

    def __init__(
        self,
        *,
        association_chain_links: "List[GrantaServerApiSchemaLayoutsNewLayoutAssociationChainLink]",
        association_chain_name: "str",
        guid: "Union[str, Unset_Type]" = Unset,
        item_type: "str" = "associationChain",
    ) -> None:
        """GrantaServerApiSchemaLayoutsNewLayoutAssociationChainItem - a model defined in Swagger

        Parameters
        ----------
        association_chain_links: List[GrantaServerApiSchemaLayoutsNewLayoutAssociationChainLink]
        association_chain_name: str
        guid: str, optional
        item_type: str
        """
        super().__init__(guid=guid)
        self._item_type: str
        self._association_chain_name: str
        self._association_chain_links: List[
            GrantaServerApiSchemaLayoutsNewLayoutAssociationChainLink
        ]

        self.item_type = item_type
        self.association_chain_name = association_chain_name
        self.association_chain_links = association_chain_links

    @property
    def item_type(self) -> "str":
        """Gets the item_type of this GrantaServerApiSchemaLayoutsNewLayoutAssociationChainItem.

        Returns
        -------
        str
            The item_type of this GrantaServerApiSchemaLayoutsNewLayoutAssociationChainItem.
        """
        return self._item_type

    @item_type.setter
    def item_type(self, item_type: "str") -> None:
        """Sets the item_type of this GrantaServerApiSchemaLayoutsNewLayoutAssociationChainItem.

        Parameters
        ----------
        item_type: str
            The item_type of this GrantaServerApiSchemaLayoutsNewLayoutAssociationChainItem.
        """
        # Field is not nullable
        if item_type is None:
            raise ValueError("Invalid value for 'item_type', must not be 'None'")
        # Field is required
        if item_type is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'item_type', must not be 'Unset'")
        self._item_type = item_type

    @property
    def association_chain_name(self) -> "str":
        """Gets the association_chain_name of this GrantaServerApiSchemaLayoutsNewLayoutAssociationChainItem.

        Returns
        -------
        str
            The association_chain_name of this GrantaServerApiSchemaLayoutsNewLayoutAssociationChainItem.
        """
        return self._association_chain_name

    @association_chain_name.setter
    def association_chain_name(self, association_chain_name: "str") -> None:
        """Sets the association_chain_name of this GrantaServerApiSchemaLayoutsNewLayoutAssociationChainItem.

        Parameters
        ----------
        association_chain_name: str
            The association_chain_name of this GrantaServerApiSchemaLayoutsNewLayoutAssociationChainItem.
        """
        # Field is not nullable
        if association_chain_name is None:
            raise ValueError("Invalid value for 'association_chain_name', must not be 'None'")
        # Field is required
        if association_chain_name is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'association_chain_name', must not be 'Unset'")
        self._association_chain_name = association_chain_name

    @property
    def association_chain_links(
        self,
    ) -> "List[GrantaServerApiSchemaLayoutsNewLayoutAssociationChainLink]":
        """Gets the association_chain_links of this GrantaServerApiSchemaLayoutsNewLayoutAssociationChainItem.

        Returns
        -------
        List[GrantaServerApiSchemaLayoutsNewLayoutAssociationChainLink]
            The association_chain_links of this GrantaServerApiSchemaLayoutsNewLayoutAssociationChainItem.
        """
        return self._association_chain_links

    @association_chain_links.setter
    def association_chain_links(
        self,
        association_chain_links: "List[GrantaServerApiSchemaLayoutsNewLayoutAssociationChainLink]",
    ) -> None:
        """Sets the association_chain_links of this GrantaServerApiSchemaLayoutsNewLayoutAssociationChainItem.

        Parameters
        ----------
        association_chain_links: List[GrantaServerApiSchemaLayoutsNewLayoutAssociationChainLink]
            The association_chain_links of this GrantaServerApiSchemaLayoutsNewLayoutAssociationChainItem.
        """
        # Field is not nullable
        if association_chain_links is None:
            raise ValueError("Invalid value for 'association_chain_links', must not be 'None'")
        # Field is required
        if association_chain_links is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'association_chain_links', must not be 'Unset'")
        self._association_chain_links = association_chain_links

    @classmethod
    def get_real_child_model(cls, data: Dict[str, str]) -> str:
        """Raises a NotImplementedError for a type without a discriminator defined.

        Parameters
        ----------
        data: ModelBase
            Object representing a subclass of this class

        Raises
        ------
        NotImplementedError
            This class has no discriminator, and hence no subclasses
        """
        raise NotImplementedError()

    def __repr__(self) -> str:
        """For 'print' and 'pprint'"""
        return self.to_str()

    def __eq__(self, other: Any) -> bool:
        """Returns true if both objects are equal"""
        if not isinstance(other, GrantaServerApiSchemaLayoutsNewLayoutAssociationChainItem):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other: Any) -> bool:
        """Returns true if both objects are not equal"""
        return not self == other
