# Copyright (C) 2023 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""
    MI Server API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: v1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import re  # noqa: F401
from typing import TYPE_CHECKING, Any, BinaryIO, Dict, List, Optional, Union  # noqa: F401

from . import ModelBase, Unset, Unset_Type

if TYPE_CHECKING:
    from datetime import datetime
    import pathlib

    from . import *


class GrantaServerApiSchemaLayoutsNewLayoutAssociationChainLink(ModelBase):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes
    ----------
    swagger_types: Dict[str, str]
        The key is attribute name and the value is attribute type.
    attribute_map: Dict[str, str]
        The key is attribute name and the value is json key in definition.
    subtype_mapping: Dict[str, str]
        The key is the unmangled property name and the value is the corresponding type.
    discriminator: Optional[str]
        Name of the property used as discriminator for subtypes.
    """
    swagger_types: Dict[str, str] = {
        "source_database_version_guid": "str",
        "tabular_attribute_guid": "str",
        "forwards": "bool",
    }

    attribute_map: Dict[str, str] = {
        "source_database_version_guid": "sourceDatabaseVersionGuid",
        "tabular_attribute_guid": "tabularAttributeGuid",
        "forwards": "forwards",
    }

    subtype_mapping: Dict[str, str] = {}

    discriminator: Optional[str] = None

    def __init__(
        self,
        *,
        source_database_version_guid: "str",
        tabular_attribute_guid: "str",
        forwards: "Union[bool, Unset_Type]" = Unset,
    ) -> None:
        """GrantaServerApiSchemaLayoutsNewLayoutAssociationChainLink - a model defined in Swagger

        Parameters
        ----------
        source_database_version_guid: str
        tabular_attribute_guid: str
        forwards: bool, optional
        """
        self._forwards: Union[bool, Unset_Type] = Unset
        self._source_database_version_guid: str
        self._tabular_attribute_guid: str

        if forwards is not Unset:
            self.forwards = forwards
        self.source_database_version_guid = source_database_version_guid
        self.tabular_attribute_guid = tabular_attribute_guid

    @property
    def forwards(self) -> "Union[bool, Unset_Type]":
        """Gets the forwards of this GrantaServerApiSchemaLayoutsNewLayoutAssociationChainLink.

        Returns
        -------
        Union[bool, Unset_Type]
            The forwards of this GrantaServerApiSchemaLayoutsNewLayoutAssociationChainLink.
        """
        return self._forwards

    @forwards.setter
    def forwards(self, forwards: "Union[bool, Unset_Type]") -> None:
        """Sets the forwards of this GrantaServerApiSchemaLayoutsNewLayoutAssociationChainLink.

        Parameters
        ----------
        forwards: Union[bool, Unset_Type]
            The forwards of this GrantaServerApiSchemaLayoutsNewLayoutAssociationChainLink.
        """
        # Field is not nullable
        if forwards is None:
            raise ValueError("Invalid value for 'forwards', must not be 'None'")
        self._forwards = forwards

    @property
    def source_database_version_guid(self) -> "str":
        """Gets the source_database_version_guid of this GrantaServerApiSchemaLayoutsNewLayoutAssociationChainLink.

        Returns
        -------
        str
            The source_database_version_guid of this GrantaServerApiSchemaLayoutsNewLayoutAssociationChainLink.
        """
        return self._source_database_version_guid

    @source_database_version_guid.setter
    def source_database_version_guid(self, source_database_version_guid: "str") -> None:
        """Sets the source_database_version_guid of this GrantaServerApiSchemaLayoutsNewLayoutAssociationChainLink.

        Parameters
        ----------
        source_database_version_guid: str
            The source_database_version_guid of this GrantaServerApiSchemaLayoutsNewLayoutAssociationChainLink.
        """
        # Field is not nullable
        if source_database_version_guid is None:
            raise ValueError("Invalid value for 'source_database_version_guid', must not be 'None'")
        # Field is required
        if source_database_version_guid is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError(
                "Invalid value for 'source_database_version_guid', must not be 'Unset'"
            )
        self._source_database_version_guid = source_database_version_guid

    @property
    def tabular_attribute_guid(self) -> "str":
        """Gets the tabular_attribute_guid of this GrantaServerApiSchemaLayoutsNewLayoutAssociationChainLink.

        Returns
        -------
        str
            The tabular_attribute_guid of this GrantaServerApiSchemaLayoutsNewLayoutAssociationChainLink.
        """
        return self._tabular_attribute_guid

    @tabular_attribute_guid.setter
    def tabular_attribute_guid(self, tabular_attribute_guid: "str") -> None:
        """Sets the tabular_attribute_guid of this GrantaServerApiSchemaLayoutsNewLayoutAssociationChainLink.

        Parameters
        ----------
        tabular_attribute_guid: str
            The tabular_attribute_guid of this GrantaServerApiSchemaLayoutsNewLayoutAssociationChainLink.
        """
        # Field is not nullable
        if tabular_attribute_guid is None:
            raise ValueError("Invalid value for 'tabular_attribute_guid', must not be 'None'")
        # Field is required
        if tabular_attribute_guid is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'tabular_attribute_guid', must not be 'Unset'")
        self._tabular_attribute_guid = tabular_attribute_guid

    @classmethod
    def get_real_child_model(cls, data: Dict[str, str]) -> str:
        """Raises a NotImplementedError for a type without a discriminator defined.

        Parameters
        ----------
        data: ModelBase
            Object representing a subclass of this class

        Raises
        ------
        NotImplementedError
            This class has no discriminator, and hence no subclasses
        """
        raise NotImplementedError()

    def __repr__(self) -> str:
        """For 'print' and 'pprint'"""
        return self.to_str()

    def __eq__(self, other: Any) -> bool:
        """Returns true if both objects are equal"""
        if not isinstance(other, GrantaServerApiSchemaLayoutsNewLayoutAssociationChainLink):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other: Any) -> bool:
        """Returns true if both objects are not equal"""
        return not self == other
