# Copyright (C) 2023 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""
    MI Server API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: v1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import re  # noqa: F401
from typing import TYPE_CHECKING, Any, BinaryIO, Dict, List, Optional, Union  # noqa: F401

from ansys.grantami.serverapi_openapi.models.granta_server_api_schema_parameters_update_parameter import (  # noqa: F401
    GrantaServerApiSchemaParametersUpdateParameter,
)

from . import ModelBase, Unset, Unset_Type

if TYPE_CHECKING:
    from datetime import datetime
    import pathlib

    from . import *


class GrantaServerApiSchemaParametersUpdateNumericParameter(
    GrantaServerApiSchemaParametersUpdateParameter
):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes
    ----------
    swagger_types: Dict[str, str]
        The key is attribute name and the value is attribute type.
    attribute_map: Dict[str, str]
        The key is attribute name and the value is json key in definition.
    subtype_mapping: Dict[str, str]
        The key is the unmangled property name and the value is the corresponding type.
    discriminator: Optional[str]
        Name of the property used as discriminator for subtypes.
    """
    swagger_types: Dict[str, str] = {
        "default_parameter_value_guid": "str",
        "guid": "str",
        "help_path": "str",
        "interpolation_type": "GrantaServerApiSchemaParametersParameterInterpolationType",
        "name": "str",
        "scale_type": "GrantaServerApiSchemaParametersParameterScaleType",
        "type": "str",
        "unit": "GrantaServerApiSchemaSlimEntitiesSlimEntity",
    }

    attribute_map: Dict[str, str] = {
        "default_parameter_value_guid": "defaultParameterValueGuid",
        "guid": "guid",
        "help_path": "helpPath",
        "interpolation_type": "interpolationType",
        "name": "name",
        "scale_type": "scaleType",
        "type": "type",
        "unit": "unit",
    }

    subtype_mapping: Dict[str, str] = {
        "unit": "GrantaServerApiSchemaSlimEntitiesSlimEntity",
        "interpolationType": "GrantaServerApiSchemaParametersParameterInterpolationType",
        "scaleType": "GrantaServerApiSchemaParametersParameterScaleType",
    }

    discriminator: Optional[str] = None

    def __init__(
        self,
        *,
        default_parameter_value_guid: "Union[str, Unset_Type]" = Unset,
        guid: "Union[str, Unset_Type]" = Unset,
        help_path: "Union[str, None, Unset_Type]" = Unset,
        interpolation_type: "Union[GrantaServerApiSchemaParametersParameterInterpolationType, Unset_Type]" = Unset,
        name: "Union[str, Unset_Type]" = Unset,
        scale_type: "Union[GrantaServerApiSchemaParametersParameterScaleType, Unset_Type]" = Unset,
        type: "str" = "numeric",
        unit: "Union[GrantaServerApiSchemaSlimEntitiesSlimEntity, Unset_Type]" = Unset,
    ) -> None:
        """GrantaServerApiSchemaParametersUpdateNumericParameter - a model defined in Swagger

        Parameters
        ----------
        default_parameter_value_guid: str, optional
        guid: str, optional
        help_path: str, optional
        interpolation_type: GrantaServerApiSchemaParametersParameterInterpolationType, optional
        name: str, optional
        scale_type: GrantaServerApiSchemaParametersParameterScaleType, optional
        type: str
        unit: GrantaServerApiSchemaSlimEntitiesSlimEntity, optional
        """
        super().__init__(
            default_parameter_value_guid=default_parameter_value_guid,
            guid=guid,
            help_path=help_path,
            name=name,
        )
        self._type: str
        self._unit: Union[GrantaServerApiSchemaSlimEntitiesSlimEntity, Unset_Type] = Unset
        self._interpolation_type: Union[
            GrantaServerApiSchemaParametersParameterInterpolationType, Unset_Type
        ] = Unset
        self._scale_type: Union[GrantaServerApiSchemaParametersParameterScaleType, Unset_Type] = (
            Unset
        )

        self.type = type
        if unit is not Unset:
            self.unit = unit
        if interpolation_type is not Unset:
            self.interpolation_type = interpolation_type
        if scale_type is not Unset:
            self.scale_type = scale_type

    @property
    def type(self) -> "str":
        """Gets the type of this GrantaServerApiSchemaParametersUpdateNumericParameter.

        Returns
        -------
        str
            The type of this GrantaServerApiSchemaParametersUpdateNumericParameter.
        """
        return self._type

    @type.setter
    def type(self, type: "str") -> None:
        """Sets the type of this GrantaServerApiSchemaParametersUpdateNumericParameter.

        Parameters
        ----------
        type: str
            The type of this GrantaServerApiSchemaParametersUpdateNumericParameter.
        """
        # Field is not nullable
        if type is None:
            raise ValueError("Invalid value for 'type', must not be 'None'")
        # Field is required
        if type is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'type', must not be 'Unset'")
        self._type = type

    @property
    def unit(self) -> "Union[GrantaServerApiSchemaSlimEntitiesSlimEntity, Unset_Type]":
        """Gets the unit of this GrantaServerApiSchemaParametersUpdateNumericParameter.

        Returns
        -------
        Union[GrantaServerApiSchemaSlimEntitiesSlimEntity, Unset_Type]
            The unit of this GrantaServerApiSchemaParametersUpdateNumericParameter.
        """
        return self._unit

    @unit.setter
    def unit(self, unit: "Union[GrantaServerApiSchemaSlimEntitiesSlimEntity, Unset_Type]") -> None:
        """Sets the unit of this GrantaServerApiSchemaParametersUpdateNumericParameter.

        Parameters
        ----------
        unit: Union[GrantaServerApiSchemaSlimEntitiesSlimEntity, Unset_Type]
            The unit of this GrantaServerApiSchemaParametersUpdateNumericParameter.
        """
        # Field is not nullable
        if unit is None:
            raise ValueError("Invalid value for 'unit', must not be 'None'")
        self._unit = unit

    @property
    def interpolation_type(
        self,
    ) -> "Union[GrantaServerApiSchemaParametersParameterInterpolationType, Unset_Type]":
        """Gets the interpolation_type of this GrantaServerApiSchemaParametersUpdateNumericParameter.

        Returns
        -------
        Union[GrantaServerApiSchemaParametersParameterInterpolationType, Unset_Type]
            The interpolation_type of this GrantaServerApiSchemaParametersUpdateNumericParameter.
        """
        return self._interpolation_type

    @interpolation_type.setter
    def interpolation_type(
        self,
        interpolation_type: "Union[GrantaServerApiSchemaParametersParameterInterpolationType, Unset_Type]",
    ) -> None:
        """Sets the interpolation_type of this GrantaServerApiSchemaParametersUpdateNumericParameter.

        Parameters
        ----------
        interpolation_type: Union[GrantaServerApiSchemaParametersParameterInterpolationType, Unset_Type]
            The interpolation_type of this GrantaServerApiSchemaParametersUpdateNumericParameter.
        """
        # Field is not nullable
        if interpolation_type is None:
            raise ValueError("Invalid value for 'interpolation_type', must not be 'None'")
        self._interpolation_type = interpolation_type

    @property
    def scale_type(self) -> "Union[GrantaServerApiSchemaParametersParameterScaleType, Unset_Type]":
        """Gets the scale_type of this GrantaServerApiSchemaParametersUpdateNumericParameter.

        Returns
        -------
        Union[GrantaServerApiSchemaParametersParameterScaleType, Unset_Type]
            The scale_type of this GrantaServerApiSchemaParametersUpdateNumericParameter.
        """
        return self._scale_type

    @scale_type.setter
    def scale_type(
        self, scale_type: "Union[GrantaServerApiSchemaParametersParameterScaleType, Unset_Type]"
    ) -> None:
        """Sets the scale_type of this GrantaServerApiSchemaParametersUpdateNumericParameter.

        Parameters
        ----------
        scale_type: Union[GrantaServerApiSchemaParametersParameterScaleType, Unset_Type]
            The scale_type of this GrantaServerApiSchemaParametersUpdateNumericParameter.
        """
        # Field is not nullable
        if scale_type is None:
            raise ValueError("Invalid value for 'scale_type', must not be 'None'")
        self._scale_type = scale_type

    @classmethod
    def get_real_child_model(cls, data: Dict[str, str]) -> str:
        """Raises a NotImplementedError for a type without a discriminator defined.

        Parameters
        ----------
        data: ModelBase
            Object representing a subclass of this class

        Raises
        ------
        NotImplementedError
            This class has no discriminator, and hence no subclasses
        """
        raise NotImplementedError()

    def __repr__(self) -> str:
        """For 'print' and 'pprint'"""
        return self.to_str()

    def __eq__(self, other: Any) -> bool:
        """Returns true if both objects are equal"""
        if not isinstance(other, GrantaServerApiSchemaParametersUpdateNumericParameter):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other: Any) -> bool:
        """Returns true if both objects are not equal"""
        return not self == other
