# Copyright (C) 2023 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""
    MI Server API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: v1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import re  # noqa: F401
from typing import TYPE_CHECKING, Any, BinaryIO, Dict, List, Optional, Union  # noqa: F401

from . import ModelBase, Unset, Unset_Type

if TYPE_CHECKING:
    from datetime import datetime
    import pathlib

    from . import *


class GrantaServerApiSchemaStandardNamesStandardName(ModelBase):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes
    ----------
    swagger_types: Dict[str, str]
        The key is attribute name and the value is attribute type.
    attribute_map: Dict[str, str]
        The key is attribute name and the value is json key in definition.
    subtype_mapping: Dict[str, str]
        The key is the unmangled property name and the value is the corresponding type.
    discriminator: Optional[str]
        Name of the property used as discriminator for subtypes.
    """
    swagger_types: Dict[str, str] = {
        "guid": "str",
        "mapped_attributes": "list[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]",
        "mapped_cross_database_record_link_groups": "list[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]",
        "mapped_parameters": "list[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]",
        "mapped_record_link_groups": "list[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]",
        "name": "str",
    }

    attribute_map: Dict[str, str] = {
        "guid": "guid",
        "mapped_attributes": "mappedAttributes",
        "mapped_cross_database_record_link_groups": "mappedCrossDatabaseRecordLinkGroups",
        "mapped_parameters": "mappedParameters",
        "mapped_record_link_groups": "mappedRecordLinkGroups",
        "name": "name",
    }

    subtype_mapping: Dict[str, str] = {
        "mappedAttributes": "GrantaServerApiSchemaSlimEntitiesSlimNamedEntity",
        "mappedParameters": "GrantaServerApiSchemaSlimEntitiesSlimNamedEntity",
        "mappedRecordLinkGroups": "GrantaServerApiSchemaSlimEntitiesSlimNamedEntity",
        "mappedCrossDatabaseRecordLinkGroups": "GrantaServerApiSchemaSlimEntitiesSlimNamedEntity",
    }

    discriminator: Optional[str] = None

    def __init__(
        self,
        *,
        guid: "str",
        mapped_attributes: "List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]",
        mapped_cross_database_record_link_groups: "List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]",
        mapped_parameters: "List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]",
        mapped_record_link_groups: "List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]",
        name: "str",
    ) -> None:
        """GrantaServerApiSchemaStandardNamesStandardName - a model defined in Swagger

        Parameters
        ----------
        guid: str
        mapped_attributes: List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]
        mapped_cross_database_record_link_groups: List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]
        mapped_parameters: List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]
        mapped_record_link_groups: List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]
        name: str
        """
        self._mapped_attributes: List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]
        self._mapped_parameters: List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]
        self._mapped_record_link_groups: List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]
        self._mapped_cross_database_record_link_groups: List[
            GrantaServerApiSchemaSlimEntitiesSlimNamedEntity
        ]
        self._name: str
        self._guid: str

        self.mapped_attributes = mapped_attributes
        self.mapped_parameters = mapped_parameters
        self.mapped_record_link_groups = mapped_record_link_groups
        self.mapped_cross_database_record_link_groups = mapped_cross_database_record_link_groups
        self.name = name
        self.guid = guid

    @property
    def mapped_attributes(self) -> "List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]":
        """Gets the mapped_attributes of this GrantaServerApiSchemaStandardNamesStandardName.

        Returns
        -------
        List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]
            The mapped_attributes of this GrantaServerApiSchemaStandardNamesStandardName.
        """
        return self._mapped_attributes

    @mapped_attributes.setter
    def mapped_attributes(
        self, mapped_attributes: "List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]"
    ) -> None:
        """Sets the mapped_attributes of this GrantaServerApiSchemaStandardNamesStandardName.

        Parameters
        ----------
        mapped_attributes: List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]
            The mapped_attributes of this GrantaServerApiSchemaStandardNamesStandardName.
        """
        # Field is not nullable
        if mapped_attributes is None:
            raise ValueError("Invalid value for 'mapped_attributes', must not be 'None'")
        # Field is required
        if mapped_attributes is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'mapped_attributes', must not be 'Unset'")
        self._mapped_attributes = mapped_attributes

    @property
    def mapped_parameters(self) -> "List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]":
        """Gets the mapped_parameters of this GrantaServerApiSchemaStandardNamesStandardName.

        Returns
        -------
        List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]
            The mapped_parameters of this GrantaServerApiSchemaStandardNamesStandardName.
        """
        return self._mapped_parameters

    @mapped_parameters.setter
    def mapped_parameters(
        self, mapped_parameters: "List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]"
    ) -> None:
        """Sets the mapped_parameters of this GrantaServerApiSchemaStandardNamesStandardName.

        Parameters
        ----------
        mapped_parameters: List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]
            The mapped_parameters of this GrantaServerApiSchemaStandardNamesStandardName.
        """
        # Field is not nullable
        if mapped_parameters is None:
            raise ValueError("Invalid value for 'mapped_parameters', must not be 'None'")
        # Field is required
        if mapped_parameters is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'mapped_parameters', must not be 'Unset'")
        self._mapped_parameters = mapped_parameters

    @property
    def mapped_record_link_groups(self) -> "List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]":
        """Gets the mapped_record_link_groups of this GrantaServerApiSchemaStandardNamesStandardName.

        Returns
        -------
        List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]
            The mapped_record_link_groups of this GrantaServerApiSchemaStandardNamesStandardName.
        """
        return self._mapped_record_link_groups

    @mapped_record_link_groups.setter
    def mapped_record_link_groups(
        self, mapped_record_link_groups: "List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]"
    ) -> None:
        """Sets the mapped_record_link_groups of this GrantaServerApiSchemaStandardNamesStandardName.

        Parameters
        ----------
        mapped_record_link_groups: List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]
            The mapped_record_link_groups of this GrantaServerApiSchemaStandardNamesStandardName.
        """
        # Field is not nullable
        if mapped_record_link_groups is None:
            raise ValueError("Invalid value for 'mapped_record_link_groups', must not be 'None'")
        # Field is required
        if mapped_record_link_groups is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'mapped_record_link_groups', must not be 'Unset'")
        self._mapped_record_link_groups = mapped_record_link_groups

    @property
    def mapped_cross_database_record_link_groups(
        self,
    ) -> "List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]":
        """Gets the mapped_cross_database_record_link_groups of this GrantaServerApiSchemaStandardNamesStandardName.

        Returns
        -------
        List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]
            The mapped_cross_database_record_link_groups of this GrantaServerApiSchemaStandardNamesStandardName.
        """
        return self._mapped_cross_database_record_link_groups

    @mapped_cross_database_record_link_groups.setter
    def mapped_cross_database_record_link_groups(
        self,
        mapped_cross_database_record_link_groups: "List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]",
    ) -> None:
        """Sets the mapped_cross_database_record_link_groups of this GrantaServerApiSchemaStandardNamesStandardName.

        Parameters
        ----------
        mapped_cross_database_record_link_groups: List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]
            The mapped_cross_database_record_link_groups of this GrantaServerApiSchemaStandardNamesStandardName.
        """
        # Field is not nullable
        if mapped_cross_database_record_link_groups is None:
            raise ValueError(
                "Invalid value for 'mapped_cross_database_record_link_groups', must not be 'None'"
            )
        # Field is required
        if mapped_cross_database_record_link_groups is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError(
                "Invalid value for 'mapped_cross_database_record_link_groups', must not be 'Unset'"
            )
        self._mapped_cross_database_record_link_groups = mapped_cross_database_record_link_groups

    @property
    def name(self) -> "str":
        """Gets the name of this GrantaServerApiSchemaStandardNamesStandardName.

        Returns
        -------
        str
            The name of this GrantaServerApiSchemaStandardNamesStandardName.
        """
        return self._name

    @name.setter
    def name(self, name: "str") -> None:
        """Sets the name of this GrantaServerApiSchemaStandardNamesStandardName.

        Parameters
        ----------
        name: str
            The name of this GrantaServerApiSchemaStandardNamesStandardName.
        """
        # Field is not nullable
        if name is None:
            raise ValueError("Invalid value for 'name', must not be 'None'")
        # Field is required
        if name is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'name', must not be 'Unset'")
        self._name = name

    @property
    def guid(self) -> "str":
        """Gets the guid of this GrantaServerApiSchemaStandardNamesStandardName.

        Returns
        -------
        str
            The guid of this GrantaServerApiSchemaStandardNamesStandardName.
        """
        return self._guid

    @guid.setter
    def guid(self, guid: "str") -> None:
        """Sets the guid of this GrantaServerApiSchemaStandardNamesStandardName.

        Parameters
        ----------
        guid: str
            The guid of this GrantaServerApiSchemaStandardNamesStandardName.
        """
        # Field is not nullable
        if guid is None:
            raise ValueError("Invalid value for 'guid', must not be 'None'")
        # Field is required
        if guid is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'guid', must not be 'Unset'")
        self._guid = guid

    @classmethod
    def get_real_child_model(cls, data: Dict[str, str]) -> str:
        """Raises a NotImplementedError for a type without a discriminator defined.

        Parameters
        ----------
        data: ModelBase
            Object representing a subclass of this class

        Raises
        ------
        NotImplementedError
            This class has no discriminator, and hence no subclasses
        """
        raise NotImplementedError()

    def __repr__(self) -> str:
        """For 'print' and 'pprint'"""
        return self.to_str()

    def __eq__(self, other: Any) -> bool:
        """Returns true if both objects are equal"""
        if not isinstance(other, GrantaServerApiSchemaStandardNamesStandardName):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other: Any) -> bool:
        """Returns true if both objects are not equal"""
        return not self == other
