# Copyright (C) 2023 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""
    MI Server API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: v1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import re  # noqa: F401
from typing import TYPE_CHECKING, Any, BinaryIO, Dict, List, Optional, Union  # noqa: F401

from . import ModelBase, Unset, Unset_Type

if TYPE_CHECKING:
    from datetime import datetime
    import pathlib

    from . import *


class GrantaServerApiSchemaStandardNamesUpdateStandardName(ModelBase):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes
    ----------
    swagger_types: Dict[str, str]
        The key is attribute name and the value is attribute type.
    attribute_map: Dict[str, str]
        The key is attribute name and the value is json key in definition.
    subtype_mapping: Dict[str, str]
        The key is the unmangled property name and the value is the corresponding type.
    discriminator: Optional[str]
        Name of the property used as discriminator for subtypes.
    """
    swagger_types: Dict[str, str] = {
        "guid": "str",
        "mapped_attributes": "list[GrantaServerApiSchemaSlimEntitiesSlimEntity]",
        "mapped_cross_database_record_link_groups": "list[GrantaServerApiSchemaSlimEntitiesSlimEntity]",
        "mapped_parameters": "list[GrantaServerApiSchemaSlimEntitiesSlimEntity]",
        "mapped_record_link_groups": "list[GrantaServerApiSchemaSlimEntitiesSlimEntity]",
        "name": "str",
    }

    attribute_map: Dict[str, str] = {
        "guid": "guid",
        "mapped_attributes": "mappedAttributes",
        "mapped_cross_database_record_link_groups": "mappedCrossDatabaseRecordLinkGroups",
        "mapped_parameters": "mappedParameters",
        "mapped_record_link_groups": "mappedRecordLinkGroups",
        "name": "name",
    }

    subtype_mapping: Dict[str, str] = {
        "mappedAttributes": "GrantaServerApiSchemaSlimEntitiesSlimEntity",
        "mappedParameters": "GrantaServerApiSchemaSlimEntitiesSlimEntity",
        "mappedRecordLinkGroups": "GrantaServerApiSchemaSlimEntitiesSlimEntity",
        "mappedCrossDatabaseRecordLinkGroups": "GrantaServerApiSchemaSlimEntitiesSlimEntity",
    }

    discriminator: Optional[str] = None

    def __init__(
        self,
        *,
        guid: "Union[str, Unset_Type]" = Unset,
        mapped_attributes: "Union[List[GrantaServerApiSchemaSlimEntitiesSlimEntity], None, Unset_Type]" = Unset,
        mapped_cross_database_record_link_groups: "Union[List[GrantaServerApiSchemaSlimEntitiesSlimEntity], None, Unset_Type]" = Unset,
        mapped_parameters: "Union[List[GrantaServerApiSchemaSlimEntitiesSlimEntity], None, Unset_Type]" = Unset,
        mapped_record_link_groups: "Union[List[GrantaServerApiSchemaSlimEntitiesSlimEntity], None, Unset_Type]" = Unset,
        name: "Union[str, Unset_Type]" = Unset,
    ) -> None:
        """GrantaServerApiSchemaStandardNamesUpdateStandardName - a model defined in Swagger

        Parameters
        ----------
        guid: str, optional
        mapped_attributes: List[GrantaServerApiSchemaSlimEntitiesSlimEntity], optional
        mapped_cross_database_record_link_groups: List[GrantaServerApiSchemaSlimEntitiesSlimEntity], optional
        mapped_parameters: List[GrantaServerApiSchemaSlimEntitiesSlimEntity], optional
        mapped_record_link_groups: List[GrantaServerApiSchemaSlimEntitiesSlimEntity], optional
        name: str, optional
        """
        self._mapped_attributes: Union[
            List[GrantaServerApiSchemaSlimEntitiesSlimEntity], None, Unset_Type
        ] = Unset
        self._mapped_parameters: Union[
            List[GrantaServerApiSchemaSlimEntitiesSlimEntity], None, Unset_Type
        ] = Unset
        self._mapped_record_link_groups: Union[
            List[GrantaServerApiSchemaSlimEntitiesSlimEntity], None, Unset_Type
        ] = Unset
        self._mapped_cross_database_record_link_groups: Union[
            List[GrantaServerApiSchemaSlimEntitiesSlimEntity], None, Unset_Type
        ] = Unset
        self._name: Union[str, Unset_Type] = Unset
        self._guid: Union[str, Unset_Type] = Unset

        if mapped_attributes is not Unset:
            self.mapped_attributes = mapped_attributes
        if mapped_parameters is not Unset:
            self.mapped_parameters = mapped_parameters
        if mapped_record_link_groups is not Unset:
            self.mapped_record_link_groups = mapped_record_link_groups
        if mapped_cross_database_record_link_groups is not Unset:
            self.mapped_cross_database_record_link_groups = mapped_cross_database_record_link_groups
        if name is not Unset:
            self.name = name
        if guid is not Unset:
            self.guid = guid

    @property
    def mapped_attributes(
        self,
    ) -> "Union[List[GrantaServerApiSchemaSlimEntitiesSlimEntity], None, Unset_Type]":
        """Gets the mapped_attributes of this GrantaServerApiSchemaStandardNamesUpdateStandardName.

        Returns
        -------
        Union[List[GrantaServerApiSchemaSlimEntitiesSlimEntity], None, Unset_Type]
            The mapped_attributes of this GrantaServerApiSchemaStandardNamesUpdateStandardName.
        """
        return self._mapped_attributes

    @mapped_attributes.setter
    def mapped_attributes(
        self,
        mapped_attributes: "Union[List[GrantaServerApiSchemaSlimEntitiesSlimEntity], None, Unset_Type]",
    ) -> None:
        """Sets the mapped_attributes of this GrantaServerApiSchemaStandardNamesUpdateStandardName.

        Parameters
        ----------
        mapped_attributes: Union[List[GrantaServerApiSchemaSlimEntitiesSlimEntity], None, Unset_Type]
            The mapped_attributes of this GrantaServerApiSchemaStandardNamesUpdateStandardName.
        """
        self._mapped_attributes = mapped_attributes

    @property
    def mapped_parameters(
        self,
    ) -> "Union[List[GrantaServerApiSchemaSlimEntitiesSlimEntity], None, Unset_Type]":
        """Gets the mapped_parameters of this GrantaServerApiSchemaStandardNamesUpdateStandardName.

        Returns
        -------
        Union[List[GrantaServerApiSchemaSlimEntitiesSlimEntity], None, Unset_Type]
            The mapped_parameters of this GrantaServerApiSchemaStandardNamesUpdateStandardName.
        """
        return self._mapped_parameters

    @mapped_parameters.setter
    def mapped_parameters(
        self,
        mapped_parameters: "Union[List[GrantaServerApiSchemaSlimEntitiesSlimEntity], None, Unset_Type]",
    ) -> None:
        """Sets the mapped_parameters of this GrantaServerApiSchemaStandardNamesUpdateStandardName.

        Parameters
        ----------
        mapped_parameters: Union[List[GrantaServerApiSchemaSlimEntitiesSlimEntity], None, Unset_Type]
            The mapped_parameters of this GrantaServerApiSchemaStandardNamesUpdateStandardName.
        """
        self._mapped_parameters = mapped_parameters

    @property
    def mapped_record_link_groups(
        self,
    ) -> "Union[List[GrantaServerApiSchemaSlimEntitiesSlimEntity], None, Unset_Type]":
        """Gets the mapped_record_link_groups of this GrantaServerApiSchemaStandardNamesUpdateStandardName.

        Returns
        -------
        Union[List[GrantaServerApiSchemaSlimEntitiesSlimEntity], None, Unset_Type]
            The mapped_record_link_groups of this GrantaServerApiSchemaStandardNamesUpdateStandardName.
        """
        return self._mapped_record_link_groups

    @mapped_record_link_groups.setter
    def mapped_record_link_groups(
        self,
        mapped_record_link_groups: "Union[List[GrantaServerApiSchemaSlimEntitiesSlimEntity], None, Unset_Type]",
    ) -> None:
        """Sets the mapped_record_link_groups of this GrantaServerApiSchemaStandardNamesUpdateStandardName.

        Parameters
        ----------
        mapped_record_link_groups: Union[List[GrantaServerApiSchemaSlimEntitiesSlimEntity], None, Unset_Type]
            The mapped_record_link_groups of this GrantaServerApiSchemaStandardNamesUpdateStandardName.
        """
        self._mapped_record_link_groups = mapped_record_link_groups

    @property
    def mapped_cross_database_record_link_groups(
        self,
    ) -> "Union[List[GrantaServerApiSchemaSlimEntitiesSlimEntity], None, Unset_Type]":
        """Gets the mapped_cross_database_record_link_groups of this GrantaServerApiSchemaStandardNamesUpdateStandardName.

        Returns
        -------
        Union[List[GrantaServerApiSchemaSlimEntitiesSlimEntity], None, Unset_Type]
            The mapped_cross_database_record_link_groups of this GrantaServerApiSchemaStandardNamesUpdateStandardName.
        """
        return self._mapped_cross_database_record_link_groups

    @mapped_cross_database_record_link_groups.setter
    def mapped_cross_database_record_link_groups(
        self,
        mapped_cross_database_record_link_groups: "Union[List[GrantaServerApiSchemaSlimEntitiesSlimEntity], None, Unset_Type]",
    ) -> None:
        """Sets the mapped_cross_database_record_link_groups of this GrantaServerApiSchemaStandardNamesUpdateStandardName.

        Parameters
        ----------
        mapped_cross_database_record_link_groups: Union[List[GrantaServerApiSchemaSlimEntitiesSlimEntity], None, Unset_Type]
            The mapped_cross_database_record_link_groups of this GrantaServerApiSchemaStandardNamesUpdateStandardName.
        """
        self._mapped_cross_database_record_link_groups = mapped_cross_database_record_link_groups

    @property
    def name(self) -> "Union[str, Unset_Type]":
        """Gets the name of this GrantaServerApiSchemaStandardNamesUpdateStandardName.

        Returns
        -------
        Union[str, Unset_Type]
            The name of this GrantaServerApiSchemaStandardNamesUpdateStandardName.
        """
        return self._name

    @name.setter
    def name(self, name: "Union[str, Unset_Type]") -> None:
        """Sets the name of this GrantaServerApiSchemaStandardNamesUpdateStandardName.

        Parameters
        ----------
        name: Union[str, Unset_Type]
            The name of this GrantaServerApiSchemaStandardNamesUpdateStandardName.
        """
        # Field is not nullable
        if name is None:
            raise ValueError("Invalid value for 'name', must not be 'None'")
        self._name = name

    @property
    def guid(self) -> "Union[str, Unset_Type]":
        """Gets the guid of this GrantaServerApiSchemaStandardNamesUpdateStandardName.

        Returns
        -------
        Union[str, Unset_Type]
            The guid of this GrantaServerApiSchemaStandardNamesUpdateStandardName.
        """
        return self._guid

    @guid.setter
    def guid(self, guid: "Union[str, Unset_Type]") -> None:
        """Sets the guid of this GrantaServerApiSchemaStandardNamesUpdateStandardName.

        Parameters
        ----------
        guid: Union[str, Unset_Type]
            The guid of this GrantaServerApiSchemaStandardNamesUpdateStandardName.
        """
        # Field is not nullable
        if guid is None:
            raise ValueError("Invalid value for 'guid', must not be 'None'")
        self._guid = guid

    @classmethod
    def get_real_child_model(cls, data: Dict[str, str]) -> str:
        """Raises a NotImplementedError for a type without a discriminator defined.

        Parameters
        ----------
        data: ModelBase
            Object representing a subclass of this class

        Raises
        ------
        NotImplementedError
            This class has no discriminator, and hence no subclasses
        """
        raise NotImplementedError()

    def __repr__(self) -> str:
        """For 'print' and 'pprint'"""
        return self.to_str()

    def __eq__(self, other: Any) -> bool:
        """Returns true if both objects are equal"""
        if not isinstance(other, GrantaServerApiSchemaStandardNamesUpdateStandardName):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other: Any) -> bool:
        """Returns true if both objects are not equal"""
        return not self == other
