# Copyright (C) 2023 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""
    MI Server API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: v1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import re  # noqa: F401
from typing import TYPE_CHECKING, Any, BinaryIO, Dict, List, Optional, Union  # noqa: F401

from . import ModelBase, Unset, Unset_Type

if TYPE_CHECKING:
    from datetime import datetime
    import pathlib

    from . import *


class GrantaServerApiSchemaUnitsUnitUsage(ModelBase):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes
    ----------
    swagger_types: Dict[str, str]
        The key is attribute name and the value is attribute type.
    attribute_map: Dict[str, str]
        The key is attribute name and the value is json key in definition.
    subtype_mapping: Dict[str, str]
        The key is the unmangled property name and the value is the corresponding type.
    discriminator: Optional[str]
        Name of the property used as discriminator for subtypes.
    """
    swagger_types: Dict[str, str] = {
        "attributes": "list[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]",
        "constants": "list[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]",
        "expressions": "list[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]",
        "parameters": "list[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]",
        "units": "list[GrantaServerApiSchemaSlimEntitiesSlimUnit]",
    }

    attribute_map: Dict[str, str] = {
        "attributes": "attributes",
        "constants": "constants",
        "expressions": "expressions",
        "parameters": "parameters",
        "units": "units",
    }

    subtype_mapping: Dict[str, str] = {
        "attributes": "GrantaServerApiSchemaSlimEntitiesSlimNamedEntity",
        "parameters": "GrantaServerApiSchemaSlimEntitiesSlimNamedEntity",
        "constants": "GrantaServerApiSchemaSlimEntitiesSlimNamedEntity",
        "expressions": "GrantaServerApiSchemaSlimEntitiesSlimNamedEntity",
        "units": "GrantaServerApiSchemaSlimEntitiesSlimUnit",
    }

    discriminator: Optional[str] = None

    def __init__(
        self,
        *,
        attributes: "List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]",
        constants: "List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]",
        expressions: "List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]",
        parameters: "List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]",
        units: "List[GrantaServerApiSchemaSlimEntitiesSlimUnit]",
    ) -> None:
        """GrantaServerApiSchemaUnitsUnitUsage - a model defined in Swagger

        Parameters
        ----------
        attributes: List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]
        constants: List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]
        expressions: List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]
        parameters: List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]
        units: List[GrantaServerApiSchemaSlimEntitiesSlimUnit]
        """
        self._attributes: List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]
        self._parameters: List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]
        self._constants: List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]
        self._expressions: List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]
        self._units: List[GrantaServerApiSchemaSlimEntitiesSlimUnit]

        self.attributes = attributes
        self.parameters = parameters
        self.constants = constants
        self.expressions = expressions
        self.units = units

    @property
    def attributes(self) -> "List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]":
        """Gets the attributes of this GrantaServerApiSchemaUnitsUnitUsage.

        Returns
        -------
        List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]
            The attributes of this GrantaServerApiSchemaUnitsUnitUsage.
        """
        return self._attributes

    @attributes.setter
    def attributes(
        self, attributes: "List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]"
    ) -> None:
        """Sets the attributes of this GrantaServerApiSchemaUnitsUnitUsage.

        Parameters
        ----------
        attributes: List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]
            The attributes of this GrantaServerApiSchemaUnitsUnitUsage.
        """
        # Field is not nullable
        if attributes is None:
            raise ValueError("Invalid value for 'attributes', must not be 'None'")
        # Field is required
        if attributes is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'attributes', must not be 'Unset'")
        self._attributes = attributes

    @property
    def parameters(self) -> "List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]":
        """Gets the parameters of this GrantaServerApiSchemaUnitsUnitUsage.

        Returns
        -------
        List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]
            The parameters of this GrantaServerApiSchemaUnitsUnitUsage.
        """
        return self._parameters

    @parameters.setter
    def parameters(
        self, parameters: "List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]"
    ) -> None:
        """Sets the parameters of this GrantaServerApiSchemaUnitsUnitUsage.

        Parameters
        ----------
        parameters: List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]
            The parameters of this GrantaServerApiSchemaUnitsUnitUsage.
        """
        # Field is not nullable
        if parameters is None:
            raise ValueError("Invalid value for 'parameters', must not be 'None'")
        # Field is required
        if parameters is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'parameters', must not be 'Unset'")
        self._parameters = parameters

    @property
    def constants(self) -> "List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]":
        """Gets the constants of this GrantaServerApiSchemaUnitsUnitUsage.

        Returns
        -------
        List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]
            The constants of this GrantaServerApiSchemaUnitsUnitUsage.
        """
        return self._constants

    @constants.setter
    def constants(
        self, constants: "List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]"
    ) -> None:
        """Sets the constants of this GrantaServerApiSchemaUnitsUnitUsage.

        Parameters
        ----------
        constants: List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]
            The constants of this GrantaServerApiSchemaUnitsUnitUsage.
        """
        # Field is not nullable
        if constants is None:
            raise ValueError("Invalid value for 'constants', must not be 'None'")
        # Field is required
        if constants is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'constants', must not be 'Unset'")
        self._constants = constants

    @property
    def expressions(self) -> "List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]":
        """Gets the expressions of this GrantaServerApiSchemaUnitsUnitUsage.

        Returns
        -------
        List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]
            The expressions of this GrantaServerApiSchemaUnitsUnitUsage.
        """
        return self._expressions

    @expressions.setter
    def expressions(
        self, expressions: "List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]"
    ) -> None:
        """Sets the expressions of this GrantaServerApiSchemaUnitsUnitUsage.

        Parameters
        ----------
        expressions: List[GrantaServerApiSchemaSlimEntitiesSlimNamedEntity]
            The expressions of this GrantaServerApiSchemaUnitsUnitUsage.
        """
        # Field is not nullable
        if expressions is None:
            raise ValueError("Invalid value for 'expressions', must not be 'None'")
        # Field is required
        if expressions is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'expressions', must not be 'Unset'")
        self._expressions = expressions

    @property
    def units(self) -> "List[GrantaServerApiSchemaSlimEntitiesSlimUnit]":
        """Gets the units of this GrantaServerApiSchemaUnitsUnitUsage.

        Returns
        -------
        List[GrantaServerApiSchemaSlimEntitiesSlimUnit]
            The units of this GrantaServerApiSchemaUnitsUnitUsage.
        """
        return self._units

    @units.setter
    def units(self, units: "List[GrantaServerApiSchemaSlimEntitiesSlimUnit]") -> None:
        """Sets the units of this GrantaServerApiSchemaUnitsUnitUsage.

        Parameters
        ----------
        units: List[GrantaServerApiSchemaSlimEntitiesSlimUnit]
            The units of this GrantaServerApiSchemaUnitsUnitUsage.
        """
        # Field is not nullable
        if units is None:
            raise ValueError("Invalid value for 'units', must not be 'None'")
        # Field is required
        if units is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'units', must not be 'Unset'")
        self._units = units

    @classmethod
    def get_real_child_model(cls, data: Dict[str, str]) -> str:
        """Raises a NotImplementedError for a type without a discriminator defined.

        Parameters
        ----------
        data: ModelBase
            Object representing a subclass of this class

        Raises
        ------
        NotImplementedError
            This class has no discriminator, and hence no subclasses
        """
        raise NotImplementedError()

    def __repr__(self) -> str:
        """For 'print' and 'pprint'"""
        return self.to_str()

    def __eq__(self, other: Any) -> bool:
        """Returns true if both objects are equal"""
        if not isinstance(other, GrantaServerApiSchemaUnitsUnitUsage):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other: Any) -> bool:
        """Returns true if both objects are not equal"""
        return not self == other
