# Copyright (C) 2023 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""
    MI Server API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: v1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import re  # noqa: F401
from typing import TYPE_CHECKING, Any, BinaryIO, Dict, List, Optional, Union  # noqa: F401

from ansys.grantami.serverapi_openapi.models.granta_server_api_search_datum_criterion import (  # noqa: F401
    GrantaServerApiSearchDatumCriterion,
)

from . import ModelBase, Unset, Unset_Type

if TYPE_CHECKING:
    from datetime import datetime
    import pathlib

    from . import *


class GrantaServerApiSearchDiscreteFunctionalValuesDatumCriterion(
    GrantaServerApiSearchDatumCriterion
):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes
    ----------
    swagger_types: Dict[str, str]
        The key is attribute name and the value is attribute type.
    attribute_map: Dict[str, str]
        The key is attribute name and the value is json key in definition.
    subtype_mapping: Dict[str, str]
        The key is the unmangled property name and the value is the corresponding type.
    discriminator: Optional[str]
        Name of the property used as discriminator for subtypes.
    """
    swagger_types: Dict[str, str] = {
        "any_guids": "list[str]",
        "any_identities": "list[int]",
        "constraints": "list[GrantaServerApiSearchParameterConstraint]",
        "type": "str",
    }

    attribute_map: Dict[str, str] = {
        "any_guids": "anyGuids",
        "any_identities": "anyIdentities",
        "constraints": "constraints",
        "type": "type",
    }

    subtype_mapping: Dict[str, str] = {
        "constraints": "GrantaServerApiSearchParameterConstraint",
    }

    discriminator: Optional[str] = None

    def __init__(
        self,
        *,
        any_guids: "Union[List[str], None, Unset_Type]" = Unset,
        any_identities: "Union[List[int], None, Unset_Type]" = Unset,
        constraints: "Union[List[GrantaServerApiSearchParameterConstraint], None, Unset_Type]" = Unset,
        type: "str" = "discreteFunctionalValues",
    ) -> None:
        """GrantaServerApiSearchDiscreteFunctionalValuesDatumCriterion - a model defined in Swagger

        Parameters
        ----------
        any_guids: List[str], optional
        any_identities: List[int], optional
        constraints: List[GrantaServerApiSearchParameterConstraint], optional
        type: str
        """
        super().__init__()
        self._any_identities: Union[List[int], None, Unset_Type] = Unset
        self._any_guids: Union[List[str], None, Unset_Type] = Unset
        self._type: str
        self._constraints: Union[
            List[GrantaServerApiSearchParameterConstraint], None, Unset_Type
        ] = Unset

        if any_identities is not Unset:
            self.any_identities = any_identities
        if any_guids is not Unset:
            self.any_guids = any_guids
        self.type = type
        if constraints is not Unset:
            self.constraints = constraints

    @property
    def any_identities(self) -> "Union[List[int], None, Unset_Type]":
        """Gets the any_identities of this GrantaServerApiSearchDiscreteFunctionalValuesDatumCriterion.
        Match any of these discrete type identities

        Returns
        -------
        Union[List[int], None, Unset_Type]
            The any_identities of this GrantaServerApiSearchDiscreteFunctionalValuesDatumCriterion.
        """
        return self._any_identities

    @any_identities.setter
    def any_identities(self, any_identities: "Union[List[int], None, Unset_Type]") -> None:
        """Sets the any_identities of this GrantaServerApiSearchDiscreteFunctionalValuesDatumCriterion.
        Match any of these discrete type identities

        Parameters
        ----------
        any_identities: Union[List[int], None, Unset_Type]
            The any_identities of this GrantaServerApiSearchDiscreteFunctionalValuesDatumCriterion.
        """
        self._any_identities = any_identities

    @property
    def any_guids(self) -> "Union[List[str], None, Unset_Type]":
        """Gets the any_guids of this GrantaServerApiSearchDiscreteFunctionalValuesDatumCriterion.
        Match any of these discrete type GUIDs

        Returns
        -------
        Union[List[str], None, Unset_Type]
            The any_guids of this GrantaServerApiSearchDiscreteFunctionalValuesDatumCriterion.
        """
        return self._any_guids

    @any_guids.setter
    def any_guids(self, any_guids: "Union[List[str], None, Unset_Type]") -> None:
        """Sets the any_guids of this GrantaServerApiSearchDiscreteFunctionalValuesDatumCriterion.
        Match any of these discrete type GUIDs

        Parameters
        ----------
        any_guids: Union[List[str], None, Unset_Type]
            The any_guids of this GrantaServerApiSearchDiscreteFunctionalValuesDatumCriterion.
        """
        self._any_guids = any_guids

    @property
    def type(self) -> "str":
        """Gets the type of this GrantaServerApiSearchDiscreteFunctionalValuesDatumCriterion.

        Returns
        -------
        str
            The type of this GrantaServerApiSearchDiscreteFunctionalValuesDatumCriterion.
        """
        return self._type

    @type.setter
    def type(self, type: "str") -> None:
        """Sets the type of this GrantaServerApiSearchDiscreteFunctionalValuesDatumCriterion.

        Parameters
        ----------
        type: str
            The type of this GrantaServerApiSearchDiscreteFunctionalValuesDatumCriterion.
        """
        # Field is not nullable
        if type is None:
            raise ValueError("Invalid value for 'type', must not be 'None'")
        # Field is required
        if type is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'type', must not be 'Unset'")
        self._type = type

    @property
    def constraints(
        self,
    ) -> "Union[List[GrantaServerApiSearchParameterConstraint], None, Unset_Type]":
        """Gets the constraints of this GrantaServerApiSearchDiscreteFunctionalValuesDatumCriterion.
        Constraints on the parameters of the attribute. Unspecified parameters will be assumed to be unconstrained.

        Returns
        -------
        Union[List[GrantaServerApiSearchParameterConstraint], None, Unset_Type]
            The constraints of this GrantaServerApiSearchDiscreteFunctionalValuesDatumCriterion.
        """
        return self._constraints

    @constraints.setter
    def constraints(
        self, constraints: "Union[List[GrantaServerApiSearchParameterConstraint], None, Unset_Type]"
    ) -> None:
        """Sets the constraints of this GrantaServerApiSearchDiscreteFunctionalValuesDatumCriterion.
        Constraints on the parameters of the attribute. Unspecified parameters will be assumed to be unconstrained.

        Parameters
        ----------
        constraints: Union[List[GrantaServerApiSearchParameterConstraint], None, Unset_Type]
            The constraints of this GrantaServerApiSearchDiscreteFunctionalValuesDatumCriterion.
        """
        self._constraints = constraints

    @classmethod
    def get_real_child_model(cls, data: Dict[str, str]) -> str:
        """Raises a NotImplementedError for a type without a discriminator defined.

        Parameters
        ----------
        data: ModelBase
            Object representing a subclass of this class

        Raises
        ------
        NotImplementedError
            This class has no discriminator, and hence no subclasses
        """
        raise NotImplementedError()

    def __repr__(self) -> str:
        """For 'print' and 'pprint'"""
        return self.to_str()

    def __eq__(self, other: Any) -> bool:
        """Returns true if both objects are equal"""
        if not isinstance(other, GrantaServerApiSearchDiscreteFunctionalValuesDatumCriterion):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other: Any) -> bool:
        """Returns true if both objects are not equal"""
        return not self == other
