# Copyright (C) 2023 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""
    MI Server API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: v1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import re  # noqa: F401
from typing import TYPE_CHECKING, Any, BinaryIO, Dict, List, Optional, Union  # noqa: F401

from . import ModelBase, Unset, Unset_Type

if TYPE_CHECKING:
    from datetime import datetime
    import pathlib

    from . import *


class GrantaServerApiSearchSearchRequest(ModelBase):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes
    ----------
    swagger_types: Dict[str, str]
        The key is attribute name and the value is attribute type.
    attribute_map: Dict[str, str]
        The key is attribute name and the value is json key in definition.
    subtype_mapping: Dict[str, str]
        The key is the unmangled property name and the value is the corresponding type.
    discriminator: Optional[str]
        Name of the property used as discriminator for subtypes.
    """
    swagger_types: Dict[str, str] = {
        "criterion": "GrantaServerApiSearchCriterion",
        "paging_options": "GrantaServerApiSearchPagingOptions",
        "sort_criteria": "list[GrantaServerApiSearchSortCriterion]",
    }

    attribute_map: Dict[str, str] = {
        "criterion": "criterion",
        "paging_options": "pagingOptions",
        "sort_criteria": "sortCriteria",
    }

    subtype_mapping: Dict[str, str] = {
        "criterion": "GrantaServerApiSearchCriterion",
        "sortCriteria": "GrantaServerApiSearchSortCriterion",
        "pagingOptions": "GrantaServerApiSearchPagingOptions",
    }

    discriminator: Optional[str] = None

    def __init__(
        self,
        *,
        criterion: "Union[GrantaServerApiSearchCriterion, Unset_Type]" = Unset,
        paging_options: "Union[GrantaServerApiSearchPagingOptions, Unset_Type]" = Unset,
        sort_criteria: "Union[List[GrantaServerApiSearchSortCriterion], None, Unset_Type]" = Unset,
    ) -> None:
        """GrantaServerApiSearchSearchRequest - a model defined in Swagger

        Parameters
        ----------
        criterion: GrantaServerApiSearchCriterion, optional
        paging_options: GrantaServerApiSearchPagingOptions, optional
        sort_criteria: List[GrantaServerApiSearchSortCriterion], optional
        """
        self._criterion: Union[GrantaServerApiSearchCriterion, Unset_Type] = Unset
        self._sort_criteria: Union[List[GrantaServerApiSearchSortCriterion], None, Unset_Type] = (
            Unset
        )
        self._paging_options: Union[GrantaServerApiSearchPagingOptions, Unset_Type] = Unset

        if criterion is not Unset:
            self.criterion = criterion
        if sort_criteria is not Unset:
            self.sort_criteria = sort_criteria
        if paging_options is not Unset:
            self.paging_options = paging_options

    @property
    def criterion(self) -> "Union[GrantaServerApiSearchCriterion, Unset_Type]":
        """Gets the criterion of this GrantaServerApiSearchSearchRequest.

        Returns
        -------
        Union[GrantaServerApiSearchCriterion, Unset_Type]
            The criterion of this GrantaServerApiSearchSearchRequest.
        """
        return self._criterion

    @criterion.setter
    def criterion(self, criterion: "Union[GrantaServerApiSearchCriterion, Unset_Type]") -> None:
        """Sets the criterion of this GrantaServerApiSearchSearchRequest.

        Parameters
        ----------
        criterion: Union[GrantaServerApiSearchCriterion, Unset_Type]
            The criterion of this GrantaServerApiSearchSearchRequest.
        """
        # Field is not nullable
        if criterion is None:
            raise ValueError("Invalid value for 'criterion', must not be 'None'")
        self._criterion = criterion

    @property
    def sort_criteria(self) -> "Union[List[GrantaServerApiSearchSortCriterion], None, Unset_Type]":
        """Gets the sort_criteria of this GrantaServerApiSearchSearchRequest.
        An optional set of attribute based sort criteria. If none are provided, the results will be sorted in descending relevance order.

        Returns
        -------
        Union[List[GrantaServerApiSearchSortCriterion], None, Unset_Type]
            The sort_criteria of this GrantaServerApiSearchSearchRequest.
        """
        return self._sort_criteria

    @sort_criteria.setter
    def sort_criteria(
        self, sort_criteria: "Union[List[GrantaServerApiSearchSortCriterion], None, Unset_Type]"
    ) -> None:
        """Sets the sort_criteria of this GrantaServerApiSearchSearchRequest.
        An optional set of attribute based sort criteria. If none are provided, the results will be sorted in descending relevance order.

        Parameters
        ----------
        sort_criteria: Union[List[GrantaServerApiSearchSortCriterion], None, Unset_Type]
            The sort_criteria of this GrantaServerApiSearchSearchRequest.
        """
        self._sort_criteria = sort_criteria

    @property
    def paging_options(self) -> "Union[GrantaServerApiSearchPagingOptions, Unset_Type]":
        """Gets the paging_options of this GrantaServerApiSearchSearchRequest.

        Returns
        -------
        Union[GrantaServerApiSearchPagingOptions, Unset_Type]
            The paging_options of this GrantaServerApiSearchSearchRequest.
        """
        return self._paging_options

    @paging_options.setter
    def paging_options(
        self, paging_options: "Union[GrantaServerApiSearchPagingOptions, Unset_Type]"
    ) -> None:
        """Sets the paging_options of this GrantaServerApiSearchSearchRequest.

        Parameters
        ----------
        paging_options: Union[GrantaServerApiSearchPagingOptions, Unset_Type]
            The paging_options of this GrantaServerApiSearchSearchRequest.
        """
        # Field is not nullable
        if paging_options is None:
            raise ValueError("Invalid value for 'paging_options', must not be 'None'")
        self._paging_options = paging_options

    @classmethod
    def get_real_child_model(cls, data: Dict[str, str]) -> str:
        """Raises a NotImplementedError for a type without a discriminator defined.

        Parameters
        ----------
        data: ModelBase
            Object representing a subclass of this class

        Raises
        ------
        NotImplementedError
            This class has no discriminator, and hence no subclasses
        """
        raise NotImplementedError()

    def __repr__(self) -> str:
        """For 'print' and 'pprint'"""
        return self.to_str()

    def __eq__(self, other: Any) -> bool:
        """Returns true if both objects are equal"""
        if not isinstance(other, GrantaServerApiSearchSearchRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other: Any) -> bool:
        """Returns true if both objects are not equal"""
        return not self == other
