# Copyright (C) 2023 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""
    MI Server API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: v1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import re  # noqa: F401
from typing import TYPE_CHECKING, Any, BinaryIO, Dict, List, Optional, Union  # noqa: F401

from ansys.grantami.serverapi_openapi.models.granta_server_api_value_specifier import (  # noqa: F401
    GrantaServerApiValueSpecifier,
)

from . import ModelBase, Unset, Unset_Type

if TYPE_CHECKING:
    from datetime import datetime
    import pathlib

    from . import *


class GrantaServerApiSpecificValuesSpecifier(GrantaServerApiValueSpecifier):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes
    ----------
    swagger_types: Dict[str, str]
        The key is attribute name and the value is attribute type.
    attribute_map: Dict[str, str]
        The key is attribute name and the value is json key in definition.
    subtype_mapping: Dict[str, str]
        The key is the unmangled property name and the value is the corresponding type.
    discriminator: Optional[str]
        Name of the property used as discriminator for subtypes.
    """
    swagger_types: Dict[str, str] = {
        "filter_on": "str",
        "guids": "list[str]",
        "identities": "list[int]",
    }

    attribute_map: Dict[str, str] = {
        "filter_on": "filterOn",
        "guids": "guids",
        "identities": "identities",
    }

    subtype_mapping: Dict[str, str] = {}

    discriminator: Optional[str] = None

    def __init__(
        self,
        *,
        filter_on: "str" = "specific",
        guids: "Union[List[str], None, Unset_Type]" = Unset,
        identities: "Union[List[int], None, Unset_Type]" = Unset,
    ) -> None:
        """GrantaServerApiSpecificValuesSpecifier - a model defined in Swagger

        Parameters
        ----------
        filter_on: str
        guids: List[str], optional
        identities: List[int], optional
        """
        super().__init__()
        self._identities: Union[List[int], None, Unset_Type] = Unset
        self._guids: Union[List[str], None, Unset_Type] = Unset
        self._filter_on: str

        if identities is not Unset:
            self.identities = identities
        if guids is not Unset:
            self.guids = guids
        self.filter_on = filter_on

    @property
    def identities(self) -> "Union[List[int], None, Unset_Type]":
        """Gets the identities of this GrantaServerApiSpecificValuesSpecifier.

        Returns
        -------
        Union[List[int], None, Unset_Type]
            The identities of this GrantaServerApiSpecificValuesSpecifier.
        """
        return self._identities

    @identities.setter
    def identities(self, identities: "Union[List[int], None, Unset_Type]") -> None:
        """Sets the identities of this GrantaServerApiSpecificValuesSpecifier.

        Parameters
        ----------
        identities: Union[List[int], None, Unset_Type]
            The identities of this GrantaServerApiSpecificValuesSpecifier.
        """
        self._identities = identities

    @property
    def guids(self) -> "Union[List[str], None, Unset_Type]":
        """Gets the guids of this GrantaServerApiSpecificValuesSpecifier.

        Returns
        -------
        Union[List[str], None, Unset_Type]
            The guids of this GrantaServerApiSpecificValuesSpecifier.
        """
        return self._guids

    @guids.setter
    def guids(self, guids: "Union[List[str], None, Unset_Type]") -> None:
        """Sets the guids of this GrantaServerApiSpecificValuesSpecifier.

        Parameters
        ----------
        guids: Union[List[str], None, Unset_Type]
            The guids of this GrantaServerApiSpecificValuesSpecifier.
        """
        self._guids = guids

    @property
    def filter_on(self) -> "str":
        """Gets the filter_on of this GrantaServerApiSpecificValuesSpecifier.

        Returns
        -------
        str
            The filter_on of this GrantaServerApiSpecificValuesSpecifier.
        """
        return self._filter_on

    @filter_on.setter
    def filter_on(self, filter_on: "str") -> None:
        """Sets the filter_on of this GrantaServerApiSpecificValuesSpecifier.

        Parameters
        ----------
        filter_on: str
            The filter_on of this GrantaServerApiSpecificValuesSpecifier.
        """
        # Field is not nullable
        if filter_on is None:
            raise ValueError("Invalid value for 'filter_on', must not be 'None'")
        # Field is required
        if filter_on is Unset:  # type: ignore[comparison-overlap, unused-ignore]
            raise ValueError("Invalid value for 'filter_on', must not be 'Unset'")
        self._filter_on = filter_on

    @classmethod
    def get_real_child_model(cls, data: Dict[str, str]) -> str:
        """Raises a NotImplementedError for a type without a discriminator defined.

        Parameters
        ----------
        data: ModelBase
            Object representing a subclass of this class

        Raises
        ------
        NotImplementedError
            This class has no discriminator, and hence no subclasses
        """
        raise NotImplementedError()

    def __repr__(self) -> str:
        """For 'print' and 'pprint'"""
        return self.to_str()

    def __eq__(self, other: Any) -> bool:
        """Returns true if both objects are equal"""
        if not isinstance(other, GrantaServerApiSpecificValuesSpecifier):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other: Any) -> bool:
        """Returns true if both objects are not equal"""
        return not self == other
