# Copyright (C) 2023 - 2024 ANSYS, Inc. and/or its affiliates.
# SPDX-License-Identifier: MIT
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""
    MI Server API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: v1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import re  # noqa: F401
from typing import TYPE_CHECKING, Any, BinaryIO, Dict, List, Optional, Union  # noqa: F401

from . import ModelBase, Unset, Unset_Type

if TYPE_CHECKING:
    from datetime import datetime
    import pathlib

    from . import *


class MicrosoftAspNetCoreMvcObjectResult(ModelBase):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes
    ----------
    swagger_types: Dict[str, str]
        The key is attribute name and the value is attribute type.
    attribute_map: Dict[str, str]
        The key is attribute name and the value is json key in definition.
    subtype_mapping: Dict[str, str]
        The key is the unmangled property name and the value is the corresponding type.
    discriminator: Optional[str]
        Name of the property used as discriminator for subtypes.
    """
    swagger_types: Dict[str, str] = {
        "content_types": "list[str]",
        "declared_type": "str",
        "formatters": "list[MicrosoftAspNetCoreMvcFormattersIOutputFormatter]",
        "status_code": "int",
        "value": "object",
    }

    attribute_map: Dict[str, str] = {
        "content_types": "contentTypes",
        "declared_type": "declaredType",
        "formatters": "formatters",
        "status_code": "statusCode",
        "value": "value",
    }

    subtype_mapping: Dict[str, str] = {
        "formatters": "MicrosoftAspNetCoreMvcFormattersIOutputFormatter",
    }

    discriminator: Optional[str] = None

    def __init__(
        self,
        *,
        content_types: "Union[List[str], None, Unset_Type]" = Unset,
        declared_type: "Union[str, None, Unset_Type]" = Unset,
        formatters: "Union[List[MicrosoftAspNetCoreMvcFormattersIOutputFormatter], None, Unset_Type]" = Unset,
        status_code: "Union[int, None, Unset_Type]" = Unset,
        value: "Union[object, None, Unset_Type]" = Unset,
    ) -> None:
        """MicrosoftAspNetCoreMvcObjectResult - a model defined in Swagger

        Parameters
        ----------
        content_types: List[str], optional
        declared_type: str, optional
        formatters: List[MicrosoftAspNetCoreMvcFormattersIOutputFormatter], optional
        status_code: int, optional
        value: object, optional
        """
        self._value: Union[object, None, Unset_Type] = Unset
        self._formatters: Union[
            List[MicrosoftAspNetCoreMvcFormattersIOutputFormatter], None, Unset_Type
        ] = Unset
        self._content_types: Union[List[str], None, Unset_Type] = Unset
        self._declared_type: Union[str, None, Unset_Type] = Unset
        self._status_code: Union[int, None, Unset_Type] = Unset

        if value is not Unset:
            self.value = value
        if formatters is not Unset:
            self.formatters = formatters
        if content_types is not Unset:
            self.content_types = content_types
        if declared_type is not Unset:
            self.declared_type = declared_type
        if status_code is not Unset:
            self.status_code = status_code

    @property
    def value(self) -> "Union[object, None, Unset_Type]":
        """Gets the value of this MicrosoftAspNetCoreMvcObjectResult.

        Returns
        -------
        Union[object, None, Unset_Type]
            The value of this MicrosoftAspNetCoreMvcObjectResult.
        """
        return self._value

    @value.setter
    def value(self, value: "Union[object, None, Unset_Type]") -> None:
        """Sets the value of this MicrosoftAspNetCoreMvcObjectResult.

        Parameters
        ----------
        value: Union[object, None, Unset_Type]
            The value of this MicrosoftAspNetCoreMvcObjectResult.
        """
        self._value = value

    @property
    def formatters(
        self,
    ) -> "Union[List[MicrosoftAspNetCoreMvcFormattersIOutputFormatter], None, Unset_Type]":
        """Gets the formatters of this MicrosoftAspNetCoreMvcObjectResult.

        Returns
        -------
        Union[List[MicrosoftAspNetCoreMvcFormattersIOutputFormatter], None, Unset_Type]
            The formatters of this MicrosoftAspNetCoreMvcObjectResult.
        """
        return self._formatters

    @formatters.setter
    def formatters(
        self,
        formatters: "Union[List[MicrosoftAspNetCoreMvcFormattersIOutputFormatter], None, Unset_Type]",
    ) -> None:
        """Sets the formatters of this MicrosoftAspNetCoreMvcObjectResult.

        Parameters
        ----------
        formatters: Union[List[MicrosoftAspNetCoreMvcFormattersIOutputFormatter], None, Unset_Type]
            The formatters of this MicrosoftAspNetCoreMvcObjectResult.
        """
        self._formatters = formatters

    @property
    def content_types(self) -> "Union[List[str], None, Unset_Type]":
        """Gets the content_types of this MicrosoftAspNetCoreMvcObjectResult.

        Returns
        -------
        Union[List[str], None, Unset_Type]
            The content_types of this MicrosoftAspNetCoreMvcObjectResult.
        """
        return self._content_types

    @content_types.setter
    def content_types(self, content_types: "Union[List[str], None, Unset_Type]") -> None:
        """Sets the content_types of this MicrosoftAspNetCoreMvcObjectResult.

        Parameters
        ----------
        content_types: Union[List[str], None, Unset_Type]
            The content_types of this MicrosoftAspNetCoreMvcObjectResult.
        """
        self._content_types = content_types

    @property
    def declared_type(self) -> "Union[str, None, Unset_Type]":
        """Gets the declared_type of this MicrosoftAspNetCoreMvcObjectResult.

        Returns
        -------
        Union[str, None, Unset_Type]
            The declared_type of this MicrosoftAspNetCoreMvcObjectResult.
        """
        return self._declared_type

    @declared_type.setter
    def declared_type(self, declared_type: "Union[str, None, Unset_Type]") -> None:
        """Sets the declared_type of this MicrosoftAspNetCoreMvcObjectResult.

        Parameters
        ----------
        declared_type: Union[str, None, Unset_Type]
            The declared_type of this MicrosoftAspNetCoreMvcObjectResult.
        """
        self._declared_type = declared_type

    @property
    def status_code(self) -> "Union[int, None, Unset_Type]":
        """Gets the status_code of this MicrosoftAspNetCoreMvcObjectResult.

        Returns
        -------
        Union[int, None, Unset_Type]
            The status_code of this MicrosoftAspNetCoreMvcObjectResult.
        """
        return self._status_code

    @status_code.setter
    def status_code(self, status_code: "Union[int, None, Unset_Type]") -> None:
        """Sets the status_code of this MicrosoftAspNetCoreMvcObjectResult.

        Parameters
        ----------
        status_code: Union[int, None, Unset_Type]
            The status_code of this MicrosoftAspNetCoreMvcObjectResult.
        """
        self._status_code = status_code

    @classmethod
    def get_real_child_model(cls, data: Dict[str, str]) -> str:
        """Raises a NotImplementedError for a type without a discriminator defined.

        Parameters
        ----------
        data: ModelBase
            Object representing a subclass of this class

        Raises
        ------
        NotImplementedError
            This class has no discriminator, and hence no subclasses
        """
        raise NotImplementedError()

    def __repr__(self) -> str:
        """For 'print' and 'pprint'"""
        return self.to_str()

    def __eq__(self, other: Any) -> bool:
        """Returns true if both objects are equal"""
        if not isinstance(other, MicrosoftAspNetCoreMvcObjectResult):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other: Any) -> bool:
        """Returns true if both objects are not equal"""
        return not self == other
