# ADB - UiAutomator XML dump to pandas DataFrame

## Tested against Windows / Python 3.11 / Anaconda

## pip install adbuiautolite

```python
#UiAutoDumpLite is a class for interacting with the UIAutomator tool to retrieve UI information
#from an Android device using ADB (Android Debug Bridge).
#
# Parameters:
#    adb (AdbCommands, optional): An instance of AdbCommands for executing ADB commands.
#    adb_path (str, optional): The path to the ADB executable. If not provided, it will use the
#        system's ADB if available.
#    serial_number (str, optional): The serial number of the Android device to target when using ADB.
#    **kwargs: Additional keyword arguments to pass to AdbCommands.
#
# Methods:
#    get_df(timeout=60, remove_old_file=True, with_fu=True, tmpfile="/sdcard/view.xml",
#           sleep_after_dump=0.05, t_long_touch=1, **kwargs):
#    - Retrieves UI information from the Android device and returns it as a DataFrame.
# Example usage

from adbuiautolite import UiAutoDumpLite
adbpath = r"C:\Android\android-sdk\platform-tools\adb.exe"
serial_number = "127.0.0.1:5555"

# alternative: 
from usefuladb import AdbCommands
uadb = AdbCommands(adbpath, serial_number, use_busybox=False)  #

dfg1 = UiAutoDumpLite(adb_path=adbpath, serial_number=serial_number) # either path and serial number

dfg2 = UiAutoDumpLite(adb=uadb) # or AdbCommands object


# Retrieve UI information from the Android device and return it as a DataFrame.
#
# Parameters:
#     timeout (int, optional): The maximum time to wait for UI information retrieval, in seconds.
#     remove_old_file (bool, optional): Whether to remove the old UI information file before dumping a new one.
#     with_fu (bool, optional): Whether to include Tap objects for interaction in the DataFrame.
#     tmpfile (str, optional): The path to the temporary UI information file on the Android device.
#     sleep_after_dump (float, optional): Time to sleep after dumping UI information.
#     t_long_touch (int, optional): Duration for long-touch actions.
#     **kwargs: Additional keyword arguments to pass to AdbCommands.
#
# Returns:
#     pandas.DataFrame: A DataFrame containing UI information.
df = dfg1.get_df(
    timeout=60,
    remove_old_file=True,
    with_fu=True,
    tmpfile="/sdcard/view.xml",
    sleep_after_dump=0.05,
    t_long_touch=1,
)
print(df.to_string())
df.loc[df.cc_content_desc=='searchbar'].ff_mouse_tap.iloc[0]()
df.loc[df.cc_content_desc=='searchbar'].ff_mouse_longtap.iloc[0](3) # seconds to click
#                                                                                                       cc_hierarchy  cc_index                     cc_text                                   cc_resource_id                                   cc_class               cc_package cc_content_desc  cc_checkable  cc_checked  cc_clickable  cc_enabled  cc_focusable  cc_focused  cc_scrollable  cc_long_clickable  cc_password  cc_selected cc_NAF  cc_start_x  cc_start_y  cc_end_x  cc_end_y  cc_width  cc_height  cc_center_x  cc_center_y  cc_area    ff_dpad_longtap    ff_dpad_tap ff_gamepad_longtap ff_gamepad_tap ff_joystick_longtap ff_joystick_tap ff_keyboard_longtap ff_keyboard_tap   ff_mouse_longtap   ff_mouse_tap  ff_stylus_longtap  ff_stylus_tap         ff_tap ff_touchnavigation_longtap ff_touchnavigation_tap ff_touchpad_longtap ff_touchpad_tap ff_touchscreen_longtap ff_touchscreen_tap ff_trackball_longtap ff_trackball_tap
# 0                                                                                                          (node,)         0                                                                                              android.widget.FrameLayout  com.bluestacks.launcher                         False       False         False        True         False       False          False              False        False        False    NaN           0           0      1600       900      1600        900          800          450  1440000  x: 800 y: 450 t:1  x: 800 y: 450  x: 800 y: 450 t:1  x: 800 y: 450   x: 800 y: 450 t:1   x: 800 y: 450   x: 800 y: 450 t:1   x: 800 y: 450  x: 800 y: 450 t:1  x: 800 y: 450  x: 800 y: 450 t:1  x: 800 y: 450  x: 800 y: 450          x: 800 y: 450 t:1          x: 800 y: 450   x: 800 y: 450 t:1   x: 800 y: 450      x: 800 y: 450 t:1      x: 800 y: 450    x: 800 y: 450 t:1    x: 800 y: 450
# 1                                                                                                     (node, node)         0                                                                                             android.widget.LinearLayout  com.bluestacks.launcher                         False       False         False        True         False       False          False              False        False        False    NaN           0           0      1600       900      1600        900          800          450  1440000  x: 800 y: 450 t:1  x: 800 y: 450  x: 800 y: 450 t:1  x: 800 y: 450   x: 800 y: 450 t:1   x: 800 y: 450   x: 800 y: 450 t:1   x: 800 y: 450  x: 800 y: 450 t:1  x: 800 y: 450  x: 800 y: 450 t:1  x: 800 y: 450  x: 800 y: 450          x: 800 y: 450 t:1          x: 800 y: 450   x: 800 y: 450 t:1   x: 800 y: 450      x: 800 y: 450 t:1      x: 800 y: 450    x: 800 y: 450 t:1    x: 800 y: 450
# 2                                                                                               (node, node, node)         0                                                           android:id/content                 android.widget.FrameLayout  com.bluestacks.launcher                         False       False         False        True         False       False          False              False        False        False    NaN           0           0      1600       900      1600        900          800          450  1440000  x: 800 y: 450 t:1  x: 800 y: 450  x: 800 y: 450 t:1  x: 800 y: 450   x: 800 y: 450 t:1   x: 800 y: 450   x: 800 y: 450 t:1   x: 800 y: 450  x: 800 y: 450 t:1  x: 800 y: 450  x: 800 y: 450 t:1  x: 800 y: 450  x: 800 y: 450          x: 800 y: 450 t:1          x: 800 y: 450   x: 800 y: 450 t:1   x: 800 y: 450      x: 800 y: 450 t:1      x: 800 y: 450    x: 800 y: 450 t:1    x: 800 y: 450
# 3                                                                                         (node, node, node, node)         0                                                                                              android.widget.FrameLayout  com.bluestacks.launcher                         False       False         False        True         False       False          False              False        False        False    NaN           0           0      1600       900      1600        900          800          450  1440000  x: 800 y: 450 t:1  x: 800 y: 450  x: 800 y: 450 t:1  x: 800 y: 450   x: 800 y: 450 t:1   x: 800 y: 450   x: 800 y: 450 t:1   x: 800 y: 450  x: 800 y: 450 t:1  x: 800 y: 450  x: 800 y: 450 t:1  x: 800 y: 450  x: 800 y: 450          x: 800 y: 450 t:1          x: 800 y: 450   x: 800 y: 450 t:1   x: 800 y: 450      x: 800 y: 450 t:1      x: 800 y: 450    x: 800 y: 450 t:1    x: 800 y: 450
# 4                                                                                   (node, node, node, node, node)         0                                     com.bluestacks.launcher:id/drawer_layout  androidx.drawerlayout.widget.DrawerLayout  com.bluestacks.launcher                         False       False         False        True         False       False          False              False        False        False    NaN           0          36      1600       900      1600        864          800          468  1382400  x: 800 y: 468 t:1  x: 800 y: 468  x: 800 y: 468 t:1  x: 800 y: 468   x: 800 y: 468 t:1   x: 800 y: 468   x: 800 y: 468 t:1   x: 800 y: 468  x: 800 y: 468 t:1  x: 800 y: 468  x: 800 y: 468 t:1  x: 800 y: 468  x: 800 y: 468          x: 800 y: 468 t:1          x: 800 y: 468   x: 800 y: 468 t:1   x: 800 y: 468      x: 800 y: 468 t:1      x: 800 y: 468    x: 800 y: 468 t:1    x: 800 y: 468
# 5                                                                             (node, node, node, node, node, node)         0                                       com.bluestacks.launcher:id/item_option                 android.widget.FrameLayout  com.bluestacks.launcher                         False       False         False        True          True        True          False              False        False        False    NaN           0          36      1600       900      1600        864          800          468  1382400  x: 800 y: 468 t:1  x: 800 y: 468  x: 800 y: 468 t:1  x: 800 y: 468   x: 800 y: 468 t:1   x: 800 y: 468   x: 800 y: 468 t:1   x: 800 y: 468  x: 800 y: 468 t:1  x: 800 y: 468  x: 800 y: 468 t:1  x: 800 y: 468  x: 800 y: 468          x: 800 y: 468 t:1          x: 800 y: 468   x: 800 y: 468 t:1   x: 800 y: 468      x: 800 y: 468 t:1      x: 800 y: 468    x: 800 y: 468 t:1    x: 800 y: 468
# 6                                                                  (node, node, node, node, node, node, node, 0.0)         0                                                                                                       android.view.View  com.bluestacks.launcher                         False       False         False        True         False       False          False              False        False        False    NaN           0          36      1600       900      1600        864          800          468  1382400  x: 800 y: 468 t:1  x: 800 y: 468  x: 800 y: 468 t:1  x: 800 y: 468   x: 800 y: 468 t:1   x: 800 y: 468   x: 800 y: 468 t:1   x: 800 y: 468  x: 800 y: 468 t:1  x: 800 y: 468  x: 800 y: 468 t:1  x: 800 y: 468  x: 800 y: 468          x: 800 y: 468 t:1          x: 800 y: 468   x: 800 y: 468 t:1   x: 800 y: 468      x: 800 y: 468 t:1      x: 800 y: 468    x: 800 y: 468 t:1    x: 800 y: 468
# 7                                                                  (node, node, node, node, node, node, node, 1.0)         1                                                                                                  android.view.ViewGroup  com.bluestacks.launcher                         False       False         False        True         False       False          False              False        False        False    NaN           0          36      1600       900      1600        864          800          468  1382400  x: 800 y: 468 t:1  x: 800 y: 468  x: 800 y: 468 t:1  x: 800 y: 468   x: 800 y: 468 t:1   x: 800 y: 468   x: 800 y: 468 t:1   x: 800 y: 468  x: 800 y: 468 t:1  x: 800 y: 468  x: 800 y: 468 t:1  x: 800 y: 468  x: 800 y: 468          x: 800 y: 468 t:1          x: 800 y: 468   x: 800 y: 468 t:1   x: 800 y: 468      x: 800 y: 468 t:1      x: 800 y: 468    x: 800 y: 468 t:1    x: 800 y: 468
# 8                                                       (node, node, node, node, node, node, node, 1.0, node, 0.0)         0                              com.bluestacks.launcher:id/searchRelativeLayout              android.widget.RelativeLayout  com.bluestacks.launcher                         False       False          True        True          True       False          False              False        False        False    NaN         501         117      1100       166       599         49          800          141    29351  x: 800 y: 141 t:1  x: 800 y: 141  x: 800 y: 141 t:1  x: 800 y: 141   x: 800 y: 141 t:1   x: 800 y: 141   x: 800 y: 141 t:1   x: 800 y: 141  x: 800 y: 141 t:1  x: 800 y: 141  x: 800 y: 141 t:1  x: 800 y: 141  x: 800 y: 141          x: 800 y: 141 t:1          x: 800 y: 141   x: 800 y: 141 t:1   x: 800 y: 141      x: 800 y: 141 t:1      x: 800 y: 141    x: 800 y: 141 t:1    x: 800 y: 141
# 9                                              (node, node, node, node, node, node, node, 1.0, node, 0.0, node, 0)         0                                    com.bluestacks.launcher:id/searchPlayIcon                   android.widget.ImageView  com.bluestacks.launcher       searchbar         False       False         False        True         False       False          False              False        False        False    NaN         520         131       539       150        19         19          529          140      361  x: 529 y: 140 t:1  x: 529 y: 140  x: 529 y: 140 t:1  x: 529 y: 140   x: 529 y: 140 t:1   x: 529 y: 140   x: 529 y: 140 t:1   x: 529 y: 140  x: 529 y: 140 t:1  x: 529 y: 140  x: 529 y: 140 t:1  x: 529 y: 140  x: 529 y: 140          x: 529 y: 140 t:1          x: 529 y: 140   x: 529 y: 140 t:1   x: 529 y: 140      x: 529 y: 140 t:1      x: 529 y: 140    x: 529 y: 140 t:1    x: 529 y: 140
# 10                                             (node, node, node, node, node, node, node, 1.0, node, 0.0, node, 1)         1                                    com.bluestacks.launcher:id/searchEditText                    android.widget.EditText  com.bluestacks.launcher                         False       False          True        True          True       False          False               True        False        False   true         538         117      1062       166       524         49          800          141    25676  x: 800 y: 141 t:1  x: 800 y: 141  x: 800 y: 141 t:1  x: 800 y: 141   x: 800 y: 141 t:1   x: 800 y: 141   x: 800 y: 141 t:1   x: 800 y: 141  x: 800 y: 141 t:1  x: 800 y: 141  x: 800 y: 141 t:1  x: 800 y: 141  x: 800 y: 141          x: 800 y: 141 t:1          x: 800 y: 141   x: 800 y: 141 t:1   x: 800 y: 141      x: 800 y: 141 t:1      x: 800 y: 141    x: 800 y: 141 t:1    x: 800 y: 141
# 11                                             (node, node, node, node, node, node, node, 1.0, node, 0.0, node, 2)         2                                        com.bluestacks.launcher:id/searchIcon                   android.widget.ImageView  com.bluestacks.launcher       searchbar         False       False          True        True          True       False          False              False        False        False    NaN        1062         131      1081       150        19         19         1071          140      361  x:1071 y: 140 t:1  x:1071 y: 140  x:1071 y: 140 t:1  x:1071 y: 140   x:1071 y: 140 t:1   x:1071 y: 140   x:1071 y: 140 t:1   x:1071 y: 140  x:1071 y: 140 t:1  x:1071 y: 140  x:1071 y: 140 t:1  x:1071 y: 140  x:1071 y: 140          x:1071 y: 140 t:1          x:1071 y: 140   x:1071 y: 140 t:1   x:1071 y: 140      x:1071 y: 140 t:1      x:1071 y: 140    x:1071 y: 140 t:1    x:1071 y: 140
# 12                                                      (node, node, node, node, node, node, node, 1.0, node, 1.0)         1                                           com.bluestacks.launcher:id/desktop                androidx.viewpager.widget.b  com.bluestacks.launcher                         False       False         False        True          True       False          False              False        False        False    NaN          44         202      1556       590      1512        388          800          396   586656  x: 800 y: 396 t:1  x: 800 y: 396  x: 800 y: 396 t:1  x: 800 y: 396   x: 800 y: 396 t:1   x: 800 y: 396   x: 800 y: 396 t:1   x: 800 y: 396  x: 800 y: 396 t:1  x: 800 y: 396  x: 800 y: 396 t:1  x: 800 y: 396  x: 800 y: 396          x: 800 y: 396 t:1          x: 800 y: 396   x: 800 y: 396 t:1   x: 800 y: 396      x: 800 y: 396 t:1      x: 800 y: 396    x: 800 y: 396 t:1    x: 800 y: 396
# 13                                                (node, node, node, node, node, node, node, 1.0, node, 1.0, node)         0                                                                                                  android.view.ViewGroup  com.bluestacks.launcher                         False       False         False        True         False       False          False              False        False        False    NaN          44         202      1556       590      1512        388          800          396   586656  x: 800 y: 396 t:1  x: 800 y: 396  x: 800 y: 396 t:1  x: 800 y: 396   x: 800 y: 396 t:1   x: 800 y: 396   x: 800 y: 396 t:1   x: 800 y: 396  x: 800 y: 396 t:1  x: 800 y: 396  x: 800 y: 396 t:1  x: 800 y: 396  x: 800 y: 396          x: 800 y: 396 t:1          x: 800 y: 396   x: 800 y: 396 t:1   x: 800 y: 396      x: 800 y: 396 t:1      x: 800 y: 396    x: 800 y: 396 t:1    x: 800 y: 396
# 14                                       (node, node, node, node, node, node, node, 1.0, node, 1.0, node, node, 0)         0                                                                                                       android.view.View  com.bluestacks.launcher                         False       False          True        True          True       False          False               True        False        False   true          44         202       296       396       252        194          170          299    48888  x: 170 y: 299 t:1  x: 170 y: 299  x: 170 y: 299 t:1  x: 170 y: 299   x: 170 y: 299 t:1   x: 170 y: 299   x: 170 y: 299 t:1   x: 170 y: 299  x: 170 y: 299 t:1  x: 170 y: 299  x: 170 y: 299 t:1  x: 170 y: 299  x: 170 y: 299          x: 170 y: 299 t:1          x: 170 y: 299   x: 170 y: 299 t:1   x: 170 y: 299      x: 170 y: 299 t:1      x: 170 y: 299    x: 170 y: 299 t:1    x: 170 y: 299
# 15                                       (node, node, node, node, node, node, node, 1.0, node, 1.0, node, node, 1)         1                                                                                                       android.view.View  com.bluestacks.launcher                         False       False          True        True          True       False          False               True        False        False   true         296         202       548       396       252        194          422          299    48888  x: 422 y: 299 t:1  x: 422 y: 299  x: 422 y: 299 t:1  x: 422 y: 299   x: 422 y: 299 t:1   x: 422 y: 299   x: 422 y: 299 t:1   x: 422 y: 299  x: 422 y: 299 t:1  x: 422 y: 299  x: 422 y: 299 t:1  x: 422 y: 299  x: 422 y: 299          x: 422 y: 299 t:1          x: 422 y: 299   x: 422 y: 299 t:1   x: 422 y: 299      x: 422 y: 299 t:1      x: 422 y: 299    x: 422 y: 299 t:1    x: 422 y: 299
# 16                                       (node, node, node, node, node, node, node, 1.0, node, 1.0, node, node, 2)         2                                                                                                       android.view.View  com.bluestacks.launcher                         False       False          True        True          True       False          False               True        False        False   true         548         202       800       396       252        194          674          299    48888  x: 674 y: 299 t:1  x: 674 y: 299  x: 674 y: 299 t:1  x: 674 y: 299   x: 674 y: 299 t:1   x: 674 y: 299   x: 674 y: 299 t:1   x: 674 y: 299  x: 674 y: 299 t:1  x: 674 y: 299  x: 674 y: 299 t:1  x: 674 y: 299  x: 674 y: 299          x: 674 y: 299 t:1          x: 674 y: 299   x: 674 y: 299 t:1   x: 674 y: 299      x: 674 y: 299 t:1      x: 674 y: 299    x: 674 y: 299 t:1    x: 674 y: 299
# 17                                       (node, node, node, node, node, node, node, 1.0, node, 1.0, node, node, 3)         3                                                                                                       android.view.View  com.bluestacks.launcher                         False       False          True        True          True       False          False               True        False        False   true         800         202      1052       396       252        194          926          299    48888  x: 926 y: 299 t:1  x: 926 y: 299  x: 926 y: 299 t:1  x: 926 y: 299   x: 926 y: 299 t:1   x: 926 y: 299   x: 926 y: 299 t:1   x: 926 y: 299  x: 926 y: 299 t:1  x: 926 y: 299  x: 926 y: 299 t:1  x: 926 y: 299  x: 926 y: 299          x: 926 y: 299 t:1          x: 926 y: 299   x: 926 y: 299 t:1   x: 926 y: 299      x: 926 y: 299 t:1      x: 926 y: 299    x: 926 y: 299 t:1    x: 926 y: 299
# 18                                       (node, node, node, node, node, node, node, 1.0, node, 1.0, node, node, 4)         4                                                                                                       android.view.View  com.bluestacks.launcher                         False       False          True        True          True       False          False               True        False        False   true        1052         202      1304       396       252        194         1178          299    48888  x:1178 y: 299 t:1  x:1178 y: 299  x:1178 y: 299 t:1  x:1178 y: 299   x:1178 y: 299 t:1   x:1178 y: 299   x:1178 y: 299 t:1   x:1178 y: 299  x:1178 y: 299 t:1  x:1178 y: 299  x:1178 y: 299 t:1  x:1178 y: 299  x:1178 y: 299          x:1178 y: 299 t:1          x:1178 y: 299   x:1178 y: 299 t:1   x:1178 y: 299      x:1178 y: 299 t:1      x:1178 y: 299    x:1178 y: 299 t:1    x:1178 y: 299
# 19                                       (node, node, node, node, node, node, node, 1.0, node, 1.0, node, node, 5)         5                                                                                                       android.view.View  com.bluestacks.launcher                         False       False          True        True          True       False          False               True        False        False   true        1304         202      1556       396       252        194         1430          299    48888  x:1430 y: 299 t:1  x:1430 y: 299  x:1430 y: 299 t:1  x:1430 y: 299   x:1430 y: 299 t:1   x:1430 y: 299   x:1430 y: 299 t:1   x:1430 y: 299  x:1430 y: 299 t:1  x:1430 y: 299  x:1430 y: 299 t:1  x:1430 y: 299  x:1430 y: 299          x:1430 y: 299 t:1          x:1430 y: 299   x:1430 y: 299 t:1   x:1430 y: 299      x:1430 y: 299 t:1      x:1430 y: 299    x:1430 y: 299 t:1    x:1430 y: 299
# 20                                                      (node, node, node, node, node, node, node, 1.0, node, 2.0)         4                                              com.bluestacks.launcher:id/dock                android.widget.LinearLayout  com.bluestacks.launcher                         False       False         False        True         False       False          False              False        False        False    NaN         196         667      1404       900      1208        233          800          783   281464  x: 800 y: 783 t:1  x: 800 y: 783  x: 800 y: 783 t:1  x: 800 y: 783   x: 800 y: 783 t:1   x: 800 y: 783   x: 800 y: 783 t:1   x: 800 y: 783  x: 800 y: 783 t:1  x: 800 y: 783  x: 800 y: 783 t:1  x: 800 y: 783  x: 800 y: 783          x: 800 y: 783 t:1          x: 800 y: 783   x: 800 y: 783 t:1   x: 800 y: 783      x: 800 y: 783 t:1      x: 800 y: 783    x: 800 y: 783 t:1    x: 800 y: 783
# 21                                             (node, node, node, node, node, node, node, 1.0, node, 2.0, node, 0)         0       POPULAR GAMES TO PLAY           com.bluestacks.launcher:id/popular_gam                    android.widget.TextView  com.bluestacks.launcher                         False       False         False        True         False       False          False              False        False        False    NaN         196         676      1404       694      1208         18          800          685    21744  x: 800 y: 685 t:1  x: 800 y: 685  x: 800 y: 685 t:1  x: 800 y: 685   x: 800 y: 685 t:1   x: 800 y: 685   x: 800 y: 685 t:1   x: 800 y: 685  x: 800 y: 685 t:1  x: 800 y: 685  x: 800 y: 685 t:1  x: 800 y: 685  x: 800 y: 685          x: 800 y: 685 t:1          x: 800 y: 685   x: 800 y: 685 t:1   x: 800 y: 685      x: 800 y: 685 t:1      x: 800 y: 685    x: 800 y: 685 t:1    x: 800 y: 685
# 22                                             (node, node, node, node, node, node, node, 1.0, node, 2.0, node, 1)         1                                       com.bluestacks.launcher:id/frameLayout                 android.widget.FrameLayout  com.bluestacks.launcher                         False       False         False        True         False       False          False              False        False        False    NaN         196         694      1404       900      1208        206          800          797   248848  x: 800 y: 797 t:1  x: 800 y: 797  x: 800 y: 797 t:1  x: 800 y: 797   x: 800 y: 797 t:1   x: 800 y: 797   x: 800 y: 797 t:1   x: 800 y: 797  x: 800 y: 797 t:1  x: 800 y: 797  x: 800 y: 797 t:1  x: 800 y: 797  x: 800 y: 797          x: 800 y: 797 t:1          x: 800 y: 797   x: 800 y: 797 t:1   x: 800 y: 797      x: 800 y: 797 t:1      x: 800 y: 797    x: 800 y: 797 t:1    x: 800 y: 797
# 23                                    (node, node, node, node, node, node, node, 1.0, node, 2.0, node, 1, node, 0)         0                                                                                              android.widget.FrameLayout  com.bluestacks.launcher                         False       False         False        True         False       False          False              False        False        False    NaN         196         694      1404       900      1208        206          800          797   248848  x: 800 y: 797 t:1  x: 800 y: 797  x: 800 y: 797 t:1  x: 800 y: 797   x: 800 y: 797 t:1   x: 800 y: 797   x: 800 y: 797 t:1   x: 800 y: 797  x: 800 y: 797 t:1  x: 800 y: 797  x: 800 y: 797 t:1  x: 800 y: 797  x: 800 y: 797          x: 800 y: 797 t:1          x: 800 y: 797   x: 800 y: 797 t:1   x: 800 y: 797      x: 800 y: 797 t:1      x: 800 y: 797    x: 800 y: 797 t:1    x: 800 y: 797
# 24                              (node, node, node, node, node, node, node, 1.0, node, 2.0, node, 1, node, 0, node)         0                               com.bluestacks.launcher:id/allappsLinearLayout                android.widget.LinearLayout  com.bluestacks.launcher                         False       False         False        True         False       False          False              False        False        False    NaN         258         694      1342       876      1084        182          800          785   197288  x: 800 y: 785 t:1  x: 800 y: 785  x: 800 y: 785 t:1  x: 800 y: 785   x: 800 y: 785 t:1   x: 800 y: 785   x: 800 y: 785 t:1   x: 800 y: 785  x: 800 y: 785 t:1  x: 800 y: 785  x: 800 y: 785 t:1  x: 800 y: 785  x: 800 y: 785          x: 800 y: 785 t:1          x: 800 y: 785   x: 800 y: 785 t:1   x: 800 y: 785      x: 800 y: 785 t:1      x: 800 y: 785    x: 800 y: 785 t:1    x: 800 y: 785
# 25                   (node, node, node, node, node, node, node, 1.0, node, 2.0, node, 1, node, 0, node, node, 0.0)         0                                com.bluestacks.launcher:id/appOneLinearLayout                android.widget.LinearLayout  com.bluestacks.launcher                         False       False          True        True          True       False          False              False        False        False    NaN         324         694       483       876       159        182          403          785    28938  x: 403 y: 785 t:1  x: 403 y: 785  x: 403 y: 785 t:1  x: 403 y: 785   x: 403 y: 785 t:1   x: 403 y: 785   x: 403 y: 785 t:1   x: 403 y: 785  x: 403 y: 785 t:1  x: 403 y: 785  x: 403 y: 785 t:1  x: 403 y: 785  x: 403 y: 785          x: 403 y: 785 t:1          x: 403 y: 785   x: 403 y: 785 t:1   x: 403 y: 785      x: 403 y: 785 t:1      x: 403 y: 785    x: 403 y: 785 t:1    x: 403 y: 785
# 26        (node, node, node, node, node, node, node, 1.0, node, 2.0, node, 1, node, 0, node, node, 0.0, node, 0.0)         0                                     com.bluestacks.launcher:id/app_image_one                 android.widget.FrameLayout  com.bluestacks.launcher                         False       False         False        True         False       False          False              False        False        False    NaN         353         720       453       820       100        100          403          770    10000  x: 403 y: 770 t:1  x: 403 y: 770  x: 403 y: 770 t:1  x: 403 y: 770   x: 403 y: 770 t:1   x: 403 y: 770   x: 403 y: 770 t:1   x: 403 y: 770  x: 403 y: 770 t:1  x: 403 y: 770  x: 403 y: 770 t:1  x: 403 y: 770  x: 403 y: 770          x: 403 y: 770 t:1          x: 403 y: 770   x: 403 y: 770 t:1   x: 403 y: 770      x: 403 y: 770 t:1      x: 403 y: 770    x: 403 y: 770 t:1    x: 403 y: 770
# 27  (node, node, node, node, node, node, node, 1.0, node, 2.0, node, 1, node, 0, node, node, 0.0, node, 0.0, node)         0                                   com.bluestacks.launcher:id/popup_image_one                   android.widget.ImageView  com.bluestacks.launcher                         False       False         False        True         False       False          False              False        False        False    NaN         427         723       450       746        23         23          438          734      529  x: 438 y: 734 t:1  x: 438 y: 734  x: 438 y: 734 t:1  x: 438 y: 734   x: 438 y: 734 t:1   x: 438 y: 734   x: 438 y: 734 t:1   x: 438 y: 734  x: 438 y: 734 t:1  x: 438 y: 734  x: 438 y: 734 t:1  x: 438 y: 734  x: 438 y: 734          x: 438 y: 734 t:1          x: 438 y: 734   x: 438 y: 734 t:1   x: 438 y: 734      x: 438 y: 734 t:1      x: 438 y: 734    x: 438 y: 734 t:1    x: 438 y: 734
# 28        (node, node, node, node, node, node, node, 1.0, node, 2.0, node, 1, node, 0, node, node, 0.0, node, 1.0)         1     Dragonheir: Silent Gods          com.bluestacks.launcher:id/app_name_one                    android.widget.TextView  com.bluestacks.launcher                         False       False         False        True         False       False          False              False        False        False    NaN         324         828       483       876       159         48          403          852     7632  x: 403 y: 852 t:1  x: 403 y: 852  x: 403 y: 852 t:1  x: 403 y: 852   x: 403 y: 852 t:1   x: 403 y: 852   x: 403 y: 852 t:1   x: 403 y: 852  x: 403 y: 852 t:1  x: 403 y: 852  x: 403 y: 852 t:1  x: 403 y: 852  x: 403 y: 852          x: 403 y: 852 t:1          x: 403 y: 852   x: 403 y: 852 t:1   x: 403 y: 852      x: 403 y: 852 t:1      x: 403 y: 852    x: 403 y: 852 t:1    x: 403 y: 852
# 29                   (node, node, node, node, node, node, node, 1.0, node, 2.0, node, 1, node, 0, node, node, 1.0)         1                                com.bluestacks.launcher:id/appTwoLinearLayout                android.widget.LinearLayout  com.bluestacks.launcher                         False       False          True        True          True       False          False              False        False        False    NaN         483         694       642       876       159        182          562          785    28938  x: 562 y: 785 t:1  x: 562 y: 785  x: 562 y: 785 t:1  x: 562 y: 785   x: 562 y: 785 t:1   x: 562 y: 785   x: 562 y: 785 t:1   x: 562 y: 785  x: 562 y: 785 t:1  x: 562 y: 785  x: 562 y: 785 t:1  x: 562 y: 785  x: 562 y: 785          x: 562 y: 785 t:1          x: 562 y: 785   x: 562 y: 785 t:1   x: 562 y: 785      x: 562 y: 785 t:1      x: 562 y: 785    x: 562 y: 785 t:1    x: 562 y: 785
# 30        (node, node, node, node, node, node, node, 1.0, node, 2.0, node, 1, node, 0, node, node, 1.0, node, 0.0)         0                                     com.bluestacks.launcher:id/app_image_two                 android.widget.FrameLayout  com.bluestacks.launcher                         False       False         False        True         False       False          False              False        False        False    NaN         512         720       612       820       100        100          562          770    10000  x: 562 y: 770 t:1  x: 562 y: 770  x: 562 y: 770 t:1  x: 562 y: 770   x: 562 y: 770 t:1   x: 562 y: 770   x: 562 y: 770 t:1   x: 562 y: 770  x: 562 y: 770 t:1  x: 562 y: 770  x: 562 y: 770 t:1  x: 562 y: 770  x: 562 y: 770          x: 562 y: 770 t:1          x: 562 y: 770   x: 562 y: 770 t:1   x: 562 y: 770      x: 562 y: 770 t:1      x: 562 y: 770    x: 562 y: 770 t:1    x: 562 y: 770
# 31        (node, node, node, node, node, node, node, 1.0, node, 2.0, node, 1, node, 0, node, node, 1.0, node, 1.0)         1  The Lord of the Rings: War          com.bluestacks.launcher:id/app_name_two                    android.widget.TextView  com.bluestacks.launcher                         False       False         False        True         False       False          False              False        False        False    NaN         483         828       642       876       159         48          562          852     7632  x: 562 y: 852 t:1  x: 562 y: 852  x: 562 y: 852 t:1  x: 562 y: 852   x: 562 y: 852 t:1   x: 562 y: 852   x: 562 y: 852 t:1   x: 562 y: 852  x: 562 y: 852 t:1  x: 562 y: 852  x: 562 y: 852 t:1  x: 562 y: 852  x: 562 y: 852          x: 562 y: 852 t:1          x: 562 y: 852   x: 562 y: 852 t:1   x: 562 y: 852      x: 562 y: 852 t:1      x: 562 y: 852    x: 562 y: 852 t:1    x: 562 y: 852
# 32                   (node, node, node, node, node, node, node, 1.0, node, 2.0, node, 1, node, 0, node, node, 2.0)         2                              com.bluestacks.launcher:id/appThreeLinearLayout                android.widget.LinearLayout  com.bluestacks.launcher                         False       False          True        True          True       False          False              False        False        False    NaN         642         694       801       876       159        182          721          785    28938  x: 721 y: 785 t:1  x: 721 y: 785  x: 721 y: 785 t:1  x: 721 y: 785   x: 721 y: 785 t:1   x: 721 y: 785   x: 721 y: 785 t:1   x: 721 y: 785  x: 721 y: 785 t:1  x: 721 y: 785  x: 721 y: 785 t:1  x: 721 y: 785  x: 721 y: 785          x: 721 y: 785 t:1          x: 721 y: 785   x: 721 y: 785 t:1   x: 721 y: 785      x: 721 y: 785 t:1      x: 721 y: 785    x: 721 y: 785 t:1    x: 721 y: 785
# 33        (node, node, node, node, node, node, node, 1.0, node, 2.0, node, 1, node, 0, node, node, 2.0, node, 0.0)         0                                   com.bluestacks.launcher:id/app_image_three                 android.widget.FrameLayout  com.bluestacks.launcher                         False       False         False        True         False       False          False              False        False        False    NaN         671         720       771       820       100        100          721          770    10000  x: 721 y: 770 t:1  x: 721 y: 770  x: 721 y: 770 t:1  x: 721 y: 770   x: 721 y: 770 t:1   x: 721 y: 770   x: 721 y: 770 t:1   x: 721 y: 770  x: 721 y: 770 t:1  x: 721 y: 770  x: 721 y: 770 t:1  x: 721 y: 770  x: 721 y: 770          x: 721 y: 770 t:1          x: 721 y: 770   x: 721 y: 770 t:1   x: 721 y: 770      x: 721 y: 770 t:1      x: 721 y: 770    x: 721 y: 770 t:1    x: 721 y: 770
# 34  (node, node, node, node, node, node, node, 1.0, node, 2.0, node, 1, node, 0, node, node, 2.0, node, 0.0, node)         0                                 com.bluestacks.launcher:id/popup_image_three                   android.widget.ImageView  com.bluestacks.launcher                         False       False         False        True         False       False          False              False        False        False    NaN         745         723       768       746        23         23          756          734      529  x: 756 y: 734 t:1  x: 756 y: 734  x: 756 y: 734 t:1  x: 756 y: 734   x: 756 y: 734 t:1   x: 756 y: 734   x: 756 y: 734 t:1   x: 756 y: 734  x: 756 y: 734 t:1  x: 756 y: 734  x: 756 y: 734 t:1  x: 756 y: 734  x: 756 y: 734          x: 756 y: 734 t:1          x: 756 y: 734   x: 756 y: 734 t:1   x: 756 y: 734      x: 756 y: 734 t:1      x: 756 y: 734    x: 756 y: 734 t:1    x: 756 y: 734
# 35        (node, node, node, node, node, node, node, 1.0, node, 2.0, node, 1, node, 0, node, node, 2.0, node, 1.0)         1                     Anocris        com.bluestacks.launcher:id/app_name_three                    android.widget.TextView  com.bluestacks.launcher                         False       False         False        True         False       False          False              False        False        False    NaN         642         828       801       876       159         48          721          852     7632  x: 721 y: 852 t:1  x: 721 y: 852  x: 721 y: 852 t:1  x: 721 y: 852   x: 721 y: 852 t:1   x: 721 y: 852   x: 721 y: 852 t:1   x: 721 y: 852  x: 721 y: 852 t:1  x: 721 y: 852  x: 721 y: 852 t:1  x: 721 y: 852  x: 721 y: 852          x: 721 y: 852 t:1          x: 721 y: 852   x: 721 y: 852 t:1   x: 721 y: 852      x: 721 y: 852 t:1      x: 721 y: 852    x: 721 y: 852 t:1    x: 721 y: 852
# 36                   (node, node, node, node, node, node, node, 1.0, node, 2.0, node, 1, node, 0, node, node, 3.0)         3                               com.bluestacks.launcher:id/appFourLinearLayout                android.widget.LinearLayout  com.bluestacks.launcher                         False       False          True        True          True       False          False              False        False        False    NaN         801         694       960       876       159        182          880          785    28938  x: 880 y: 785 t:1  x: 880 y: 785  x: 880 y: 785 t:1  x: 880 y: 785   x: 880 y: 785 t:1   x: 880 y: 785   x: 880 y: 785 t:1   x: 880 y: 785  x: 880 y: 785 t:1  x: 880 y: 785  x: 880 y: 785 t:1  x: 880 y: 785  x: 880 y: 785          x: 880 y: 785 t:1          x: 880 y: 785   x: 880 y: 785 t:1   x: 880 y: 785      x: 880 y: 785 t:1      x: 880 y: 785    x: 880 y: 785 t:1    x: 880 y: 785
# 37        (node, node, node, node, node, node, node, 1.0, node, 2.0, node, 1, node, 0, node, node, 3.0, node, 0.0)         0                                    com.bluestacks.launcher:id/app_image_four                 android.widget.FrameLayout  com.bluestacks.launcher                         False       False         False        True         False       False          False              False        False        False    NaN         830         720       930       820       100        100          880          770    10000  x: 880 y: 770 t:1  x: 880 y: 770  x: 880 y: 770 t:1  x: 880 y: 770   x: 880 y: 770 t:1   x: 880 y: 770   x: 880 y: 770 t:1   x: 880 y: 770  x: 880 y: 770 t:1  x: 880 y: 770  x: 880 y: 770 t:1  x: 880 y: 770  x: 880 y: 770          x: 880 y: 770 t:1          x: 880 y: 770   x: 880 y: 770 t:1   x: 880 y: 770      x: 880 y: 770 t:1      x: 880 y: 770    x: 880 y: 770 t:1    x: 880 y: 770
# 38        (node, node, node, node, node, node, node, 1.0, node, 2.0, node, 1, node, 0, node, node, 3.0, node, 1.0)         1  Lords Mobile: Kingdom Wars         com.bluestacks.launcher:id/app_name_four                    android.widget.TextView  com.bluestacks.launcher                         False       False         False        True         False       False          False              False        False        False    NaN         801         828       960       876       159         48          880          852     7632  x: 880 y: 852 t:1  x: 880 y: 852  x: 880 y: 852 t:1  x: 880 y: 852   x: 880 y: 852 t:1   x: 880 y: 852   x: 880 y: 852 t:1   x: 880 y: 852  x: 880 y: 852 t:1  x: 880 y: 852  x: 880 y: 852 t:1  x: 880 y: 852  x: 880 y: 852          x: 880 y: 852 t:1          x: 880 y: 852   x: 880 y: 852 t:1   x: 880 y: 852      x: 880 y: 852 t:1      x: 880 y: 852    x: 880 y: 852 t:1    x: 880 y: 852
# 39                   (node, node, node, node, node, node, node, 1.0, node, 2.0, node, 1, node, 0, node, node, 4.0)         4                               com.bluestacks.launcher:id/appFiveLinearLayout                android.widget.LinearLayout  com.bluestacks.launcher                         False       False          True        True          True       False          False              False        False        False    NaN         960         694      1118       876       158        182         1039          785    28756  x:1039 y: 785 t:1  x:1039 y: 785  x:1039 y: 785 t:1  x:1039 y: 785   x:1039 y: 785 t:1   x:1039 y: 785   x:1039 y: 785 t:1   x:1039 y: 785  x:1039 y: 785 t:1  x:1039 y: 785  x:1039 y: 785 t:1  x:1039 y: 785  x:1039 y: 785          x:1039 y: 785 t:1          x:1039 y: 785   x:1039 y: 785 t:1   x:1039 y: 785      x:1039 y: 785 t:1      x:1039 y: 785    x:1039 y: 785 t:1    x:1039 y: 785
# 40        (node, node, node, node, node, node, node, 1.0, node, 2.0, node, 1, node, 0, node, node, 4.0, node, 0.0)         0                                    com.bluestacks.launcher:id/app_image_five                 android.widget.FrameLayout  com.bluestacks.launcher                         False       False         False        True         False       False          False              False        False        False    NaN         989         720      1089       820       100        100         1039          770    10000  x:1039 y: 770 t:1  x:1039 y: 770  x:1039 y: 770 t:1  x:1039 y: 770   x:1039 y: 770 t:1   x:1039 y: 770   x:1039 y: 770 t:1   x:1039 y: 770  x:1039 y: 770 t:1  x:1039 y: 770  x:1039 y: 770 t:1  x:1039 y: 770  x:1039 y: 770          x:1039 y: 770 t:1          x:1039 y: 770   x:1039 y: 770 t:1   x:1039 y: 770      x:1039 y: 770 t:1      x:1039 y: 770    x:1039 y: 770 t:1    x:1039 y: 770
# 41        (node, node, node, node, node, node, node, 1.0, node, 2.0, node, 1, node, 0, node, node, 4.0, node, 1.0)         1                 Idle Heroes         com.bluestacks.launcher:id/app_name_five                    android.widget.TextView  com.bluestacks.launcher                         False       False         False        True         False       False          False              False        False        False    NaN         960         828      1118       876       158         48         1039          852     7584  x:1039 y: 852 t:1  x:1039 y: 852  x:1039 y: 852 t:1  x:1039 y: 852   x:1039 y: 852 t:1   x:1039 y: 852   x:1039 y: 852 t:1   x:1039 y: 852  x:1039 y: 852 t:1  x:1039 y: 852  x:1039 y: 852 t:1  x:1039 y: 852  x:1039 y: 852          x:1039 y: 852 t:1          x:1039 y: 852   x:1039 y: 852 t:1   x:1039 y: 852      x:1039 y: 852 t:1      x:1039 y: 852    x:1039 y: 852 t:1    x:1039 y: 852
# 42                   (node, node, node, node, node, node, node, 1.0, node, 2.0, node, 1, node, 0, node, node, 5.0)         5                                com.bluestacks.launcher:id/appSixLinearLayout                android.widget.LinearLayout  com.bluestacks.launcher                         False       False          True        True          True       False          False              False        False        False    NaN        1118         694      1276       876       158        182         1197          785    28756  x:1197 y: 785 t:1  x:1197 y: 785  x:1197 y: 785 t:1  x:1197 y: 785   x:1197 y: 785 t:1   x:1197 y: 785   x:1197 y: 785 t:1   x:1197 y: 785  x:1197 y: 785 t:1  x:1197 y: 785  x:1197 y: 785 t:1  x:1197 y: 785  x:1197 y: 785          x:1197 y: 785 t:1          x:1197 y: 785   x:1197 y: 785 t:1   x:1197 y: 785      x:1197 y: 785 t:1      x:1197 y: 785    x:1197 y: 785 t:1    x:1197 y: 785
# 43        (node, node, node, node, node, node, node, 1.0, node, 2.0, node, 1, node, 0, node, node, 5.0, node, 0.0)         0                                     com.bluestacks.launcher:id/app_image_six                 android.widget.FrameLayout  com.bluestacks.launcher                         False       False         False        True         False       False          False              False        False        False    NaN        1147         720      1247       820       100        100         1197          770    10000  x:1197 y: 770 t:1  x:1197 y: 770  x:1197 y: 770 t:1  x:1197 y: 770   x:1197 y: 770 t:1   x:1197 y: 770   x:1197 y: 770 t:1   x:1197 y: 770  x:1197 y: 770 t:1  x:1197 y: 770  x:1197 y: 770 t:1  x:1197 y: 770  x:1197 y: 770          x:1197 y: 770 t:1          x:1197 y: 770   x:1197 y: 770 t:1   x:1197 y: 770      x:1197 y: 770 t:1      x:1197 y: 770    x:1197 y: 770 t:1    x:1197 y: 770
# 44  (node, node, node, node, node, node, node, 1.0, node, 2.0, node, 1, node, 0, node, node, 5.0, node, 0.0, node)         0                                   com.bluestacks.launcher:id/popup_image_six                   android.widget.ImageView  com.bluestacks.launcher                         False       False         False        True         False       False          False              False        False        False    NaN        1221         723      1244       746        23         23         1232          734      529  x:1232 y: 734 t:1  x:1232 y: 734  x:1232 y: 734 t:1  x:1232 y: 734   x:1232 y: 734 t:1   x:1232 y: 734   x:1232 y: 734 t:1   x:1232 y: 734  x:1232 y: 734 t:1  x:1232 y: 734  x:1232 y: 734 t:1  x:1232 y: 734  x:1232 y: 734          x:1232 y: 734 t:1          x:1232 y: 734   x:1232 y: 734 t:1   x:1232 y: 734      x:1232 y: 734 t:1      x:1232 y: 734    x:1232 y: 734 t:1    x:1232 y: 734
# 45        (node, node, node, node, node, node, node, 1.0, node, 2.0, node, 1, node, 0, node, node, 5.0, node, 1.0)         1                     Tentlan          com.bluestacks.launcher:id/app_name_six                    android.widget.TextView  com.bluestacks.launcher                         False       False         False        True         False       False          False              False        False        False    NaN        1118         828      1276       876       158         48         1197          852     7584  x:1197 y: 852 t:1  x:1197 y: 852  x:1197 y: 852 t:1  x:1197 y: 852   x:1197 y: 852 t:1   x:1197 y: 852   x:1197 y: 852 t:1   x:1197 y: 852  x:1197 y: 852 t:1  x:1197 y: 852  x:1197 y: 852 t:1  x:1197 y: 852  x:1197 y: 852          x:1197 y: 852 t:1          x:1197 y: 852   x:1197 y: 852 t:1   x:1197 y: 852      x:1197 y: 852 t:1      x:1197 y: 852    x:1197 y: 852 t:1    x:1197 y: 852
# 46                                    (node, node, node, node, node, node, node, 1.0, node, 2.0, node, 1, node, 1)         1                                    com.bluestacks.launcher:id/viewBackground                          android.view.View  com.bluestacks.launcher                         False       False         False        True         False       False          False              False        False        False    NaN         196         784      1404       900      1208        116          800          842   140128  x: 800 y: 842 t:1  x: 800 y: 842  x: 800 y: 842 t:1  x: 800 y: 842   x: 800 y: 842 t:1   x: 800 y: 842   x: 800 y: 842 t:1   x: 800 y: 842  x: 800 y: 842 t:1  x: 800 y: 842  x: 800 y: 842 t:1  x: 800 y: 842  x: 800 y: 842          x: 800 y: 842 t:1          x: 800 y: 842   x: 800 y: 842 t:1   x: 800 y: 842      x: 800 y: 842 t:1      x: 800 y: 842    x: 800 y: 842 t:1    x: 800 y: 842
```