/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.Credential;

public class Password
extends Credential {
    private static Log log = LogFactory.getLog(class$org$mortbay$util$Password == null ? (class$org$mortbay$util$Password = Password.class$("org.mortbay.util.Password")) : class$org$mortbay$util$Password);
    private String _pw;
    static /* synthetic */ Class class$org$mortbay$util$Password;

    public Password(String password) {
        this._pw = password;
        while (this._pw != null && this._pw.startsWith("OBF:")) {
            this._pw = Password.deobfuscate(this._pw);
        }
    }

    public String toString() {
        return this._pw;
    }

    public String toStarString() {
        return "*****************************************************".substring(0, this._pw.length());
    }

    public boolean check(Object credentials) {
        if (this == credentials) {
            return true;
        }
        if (credentials instanceof Password) {
            return credentials.equals(this._pw);
        }
        if (credentials instanceof String) {
            return credentials.equals(this._pw);
        }
        if (credentials instanceof Credential) {
            return ((Credential)credentials).check(this._pw);
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o) {
            return false;
        }
        if (o instanceof Password) {
            Password p = (Password)o;
            return p._pw == this._pw || null != this._pw && this._pw.equals(p._pw);
        }
        if (o instanceof String) {
            return o.equals(this._pw);
        }
        return false;
    }

    public int hashCode() {
        return null == this._pw ? super.hashCode() : this._pw.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String obfuscate(String s) {
        StringBuffer buf = new StringBuffer();
        byte[] b = s.getBytes();
        StringBuffer stringBuffer = buf;
        synchronized (stringBuffer) {
            buf.append("OBF:");
            for (int i = 0; i < b.length; ++i) {
                byte b1 = b[i];
                byte b2 = b[s.length() - (i + 1)];
                int i1 = b1 + b2 + 127;
                int i2 = b1 - b2 + 127;
                int i0 = i1 * 256 + i2;
                String x = Integer.toString(i0, 36);
                switch (x.length()) {
                    case 1: {
                        buf.append('0');
                    }
                    case 2: {
                        buf.append('0');
                    }
                    case 3: {
                        buf.append('0');
                    }
                }
                buf.append(x);
            }
            return buf.toString();
        }
    }

    public static String deobfuscate(String s) {
        if (s.startsWith("OBF:")) {
            s = s.substring(4);
        }
        byte[] b = new byte[s.length() / 2];
        int l = 0;
        for (int i = 0; i < s.length(); i += 4) {
            String x = s.substring(i, i + 4);
            int i0 = Integer.parseInt(x, 36);
            int i1 = i0 / 256;
            int i2 = i0 % 256;
            b[l++] = (byte)((i1 + i2 - 254) / 2);
        }
        return new String(b, 0, l);
    }

    public static Password getPassword(String realm, String dft, String promptDft) {
        String passwd = System.getProperty(realm, dft);
        if (passwd == null || passwd.length() == 0) {
            try {
                System.out.print(realm + (promptDft != null && promptDft.length() > 0 ? " [dft]" : "") + " : ");
                System.out.flush();
                byte[] buf = new byte[512];
                int len = System.in.read(buf);
                if (len > 0) {
                    passwd = new String(buf, 0, len).trim();
                }
            }
            catch (IOException e) {
                log.warn("EXCEPTION ", e);
            }
            if (passwd == null || passwd.length() == 0) {
                passwd = promptDft;
            }
        }
        return new Password(passwd);
    }

    public static void main(String[] arg) {
        if (arg.length != 1 && arg.length != 2) {
            System.err.println("Usage - java org.mortbay.util.Password [<user>] <password>");
            System.err.println("If the password is ?, the user will be prompted for the password");
            System.exit(1);
        }
        String p = arg[arg.length == 1 ? 0 : 1];
        Password pw = "?".equals(p) ? new Password(p) : new Password(p);
        System.err.println(pw.toString());
        System.err.println(Password.obfuscate(pw.toString()));
        System.err.println(Credential.MD5.digest(p));
        if (arg.length == 2) {
            System.err.println(Credential.Crypt.crypt(arg[0], pw.toString()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

