"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cfn_parameter_1 = require("../cfn-parameter");
const construct_1 = require("../construct");
class FileAssetParameters extends construct_1.Construct {
    constructor(scope, id) {
        super(scope, id);
        // add parameters for s3 bucket and s3 key. those will be set by
        // the toolkit or by CI/CD when the stack is deployed and will include
        // the name of the bucket and the S3 key where the code lives.
        this.bucketNameParameter = new cfn_parameter_1.CfnParameter(this, 'S3Bucket', {
            type: 'String',
            description: `S3 bucket for asset "${id}"`,
        });
        this.objectKeyParameter = new cfn_parameter_1.CfnParameter(this, 'S3VersionKey', {
            type: 'String',
            description: `S3 key for asset version "${id}"`
        });
        this.artifactHashParameter = new cfn_parameter_1.CfnParameter(this, 'ArtifactHash', {
            description: `Artifact hash for asset "${id}"`,
            type: 'String',
        });
    }
}
exports.FileAssetParameters = FileAssetParameters;
class DockerImageAssetParameters extends construct_1.Construct {
    constructor(scope, id) {
        super(scope, id);
        this.imageNameParameter = new cfn_parameter_1.CfnParameter(this, 'ImageName', {
            type: 'String',
            description: `ECR repository name and tag for asset "${id}"`,
        });
    }
}
exports.DockerImageAssetParameters = DockerImageAssetParameters;
//# sourceMappingURL=data:application/json;base64,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