import '../style/index.css';
import { IEditorServices } from '@jupyterlab/codeeditor';
import { ABCWidgetFactory, DocumentRegistry, DocumentWidget } from '@jupyterlab/docregistry';
import { FileEditor } from '@jupyterlab/fileeditor';
/**
 * A widget for python editors.
 */
export declare class PythonFileEditor extends DocumentWidget<FileEditor, DocumentRegistry.ICodeModel> {
    private runner;
    private kernelSettings;
    private dockPanel;
    private outputAreaWidget;
    private scrollingWidget;
    private model;
    private emptyOutput;
    private runDisabled;
    /**
     * Construct a new editor widget.
     */
    constructor(options: DocumentWidget.IOptions<FileEditor, DocumentRegistry.ICodeModel>);
    /**
     * Function: Creates an OutputArea widget wrapped in a DockPanel.
     */
    private createOutputAreaWidget;
    /**
     * Function: Updates kernel settings as per drop down selection.
     */
    private updateSelectedKernel;
    /**
     * Function: Clears existing output area and runs python code from file editor.
     */
    private runPython;
    private stopRun;
    private disableRun;
    /**
     * Function: Clears existing output area.
     */
    private resetOutputArea;
    /**
     * Function: Call back function passed to runner, that handles messages coming from the kernel.
     */
    private handleKernelMsg;
    private createScrollButtons;
    /**
     * Function: Displays output area widget.
     */
    private displayOutputArea;
    /**
     * Function: Displays kernel status, similar to notebook.
     */
    private displayKernelStatus;
    /**
     * Function: Displays python code in OutputArea widget.
     */
    private displayOutput;
    private setOutputAreaClasses;
    /**
     * Function: Gets OutputArea child widget, where output and kernel status are displayed.
     */
    private getOutputAreaChildWidget;
    /**
     * Function: Gets OutputArea prompt widget, where kernel status is displayed.
     */
    private getOutputAreaOutputWidget;
    /**
     * Function: Gets OutputArea prompt widget, where kernel status is displayed.
     */
    private getOutputAreaPromptWidget;
    /**
     * Function: Updates OutputArea prompt widget to display kernel status.
     */
    private updatePromptText;
    /**
     * Function: Saves file editor content.
     */
    private saveFile;
}
/**
 * A widget factory for python editors.
 */
export declare class PythonFileEditorFactory extends ABCWidgetFactory<PythonFileEditor, DocumentRegistry.ICodeModel> {
    /**
     * Construct a new editor widget factory.
     */
    constructor(options: PythonFileEditorFactory.IOptions);
    /**
     * Create a new widget given a context.
     */
    protected createNewWidget(context: DocumentRegistry.CodeContext): PythonFileEditor;
    private _services;
}
/**
 * The namespace for `PythonFileEditorFactory` class statics.
 */
export declare namespace PythonFileEditorFactory {
    /**
     * The options used to create an editor widget factory.
     */
    interface IOptions {
        /**
         * The editor services used by the factory.
         */
        editorServices: IEditorServices;
        /**
         * The factory options associated with the factory.
         */
        factoryOptions: DocumentRegistry.IWidgetFactoryOptions<PythonFileEditor>;
    }
}
