import '../style/index.css';
import { ReactWidget } from '@jupyterlab/apputils';
import { IDocumentManager } from '@jupyterlab/docmanager';
import { IRenderMimeRegistry } from '@jupyterlab/rendermime';
import { Message } from '@phosphor/messaging';
import { Signal } from '@phosphor/signaling';
import React from 'react';
import { CodeSnippetManager, ICodeSnippet } from './CodeSnippet';
/**
 * A widget for Code Snippets.
 */
export declare class CodeSnippetWidget extends ReactWidget {
    codeSnippetManager: CodeSnippetManager;
    renderCodeSnippetsSignal: Signal<this, ICodeSnippet[]>;
    constructor();
    fetchData(): Promise<ICodeSnippet[]>;
    onAfterShow(msg: Message): void;
    render(): React.ReactElement;
}
/**
 * A namespace for CodeSnippet statics.
 */
export declare namespace CodeSnippetWidget {
    /**
     * Interface describing table of contents widget options.
     */
    interface IOptions {
        /**
         * Application document manager.
         */
        docmanager: IDocumentManager;
        /**
         * Application rendered MIME type.
         */
        rendermime: IRenderMimeRegistry;
    }
}
